/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.dataformat.JsonLibrary;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.ObjectHelper;

@XmlRootElement(name="json")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class JsonDataFormat
extends DataFormatDefinition {
    @XmlAttribute
    private Boolean prettyPrint;
    @XmlAttribute
    private JsonLibrary library = JsonLibrary.XStream;
    @XmlAttribute
    private String unmarshalTypeName;
    @XmlTransient
    private Class<?> unmarshalType;
    @XmlAttribute
    private Class<?> jsonView;
    @XmlAttribute
    private String include;
    @XmlAttribute
    private Boolean allowJmsType;
    @XmlAttribute
    private String collectionTypeName;
    @XmlTransient
    private Class<?> collectionType;
    @XmlAttribute
    private Boolean useList;

    public JsonDataFormat() {
    }

    public JsonDataFormat(JsonLibrary library) {
        this.library = library;
    }

    public Boolean getPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(Boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public String getUnmarshalTypeName() {
        return this.unmarshalTypeName;
    }

    public void setUnmarshalTypeName(String unmarshalTypeName) {
        this.unmarshalTypeName = unmarshalTypeName;
    }

    public Class<?> getUnmarshalType() {
        return this.unmarshalType;
    }

    public void setUnmarshalType(Class<?> unmarshalType) {
        this.unmarshalType = unmarshalType;
    }

    public JsonLibrary getLibrary() {
        return this.library;
    }

    public void setLibrary(JsonLibrary library) {
        this.library = library;
    }

    public Class<?> getJsonView() {
        return this.jsonView;
    }

    public void setJsonView(Class<?> jsonView) {
        this.jsonView = jsonView;
    }

    public String getInclude() {
        return this.include;
    }

    public void setInclude(String include) {
        this.include = include;
    }

    public Boolean getAllowJmsType() {
        return this.allowJmsType;
    }

    public void setAllowJmsType(Boolean allowJmsType) {
        this.allowJmsType = allowJmsType;
    }

    public String getCollectionTypeName() {
        return this.collectionTypeName;
    }

    public void setCollectionTypeName(String collectionTypeName) {
        this.collectionTypeName = collectionTypeName;
    }

    public Boolean getUseList() {
        return this.useList;
    }

    public void setUseList(Boolean useList) {
        this.useList = useList;
    }

    @Override
    protected DataFormat createDataFormat(RouteContext routeContext) {
        if (this.library == JsonLibrary.XStream) {
            this.setProperty(routeContext.getCamelContext(), this, "dataFormatName", "json-xstream");
        } else if (this.library == JsonLibrary.Jackson) {
            this.setProperty(routeContext.getCamelContext(), this, "dataFormatName", "json-jackson");
        } else {
            this.setProperty(routeContext.getCamelContext(), this, "dataFormatName", "json-gson");
        }
        if (this.unmarshalType == null && this.unmarshalTypeName != null) {
            try {
                this.unmarshalType = routeContext.getCamelContext().getClassResolver().resolveMandatoryClass(this.unmarshalTypeName);
            }
            catch (ClassNotFoundException e) {
                throw ObjectHelper.wrapRuntimeCamelException(e);
            }
        }
        if (this.collectionType == null && this.collectionTypeName != null) {
            try {
                this.collectionType = routeContext.getCamelContext().getClassResolver().resolveMandatoryClass(this.collectionTypeName);
            }
            catch (ClassNotFoundException e) {
                throw ObjectHelper.wrapRuntimeCamelException(e);
            }
        }
        return super.createDataFormat(routeContext);
    }

    @Override
    protected void configureDataFormat(DataFormat dataFormat, CamelContext camelContext) {
        if (this.unmarshalType != null) {
            this.setProperty(camelContext, dataFormat, "unmarshalType", this.unmarshalType);
        }
        if (this.prettyPrint != null) {
            this.setProperty(camelContext, dataFormat, "prettyPrint", this.prettyPrint);
        }
        if (this.jsonView != null) {
            this.setProperty(camelContext, dataFormat, "jsonView", this.jsonView);
        }
        if (this.include != null) {
            this.setProperty(camelContext, dataFormat, "include", this.include);
        }
        if (this.allowJmsType != null) {
            this.setProperty(camelContext, dataFormat, "allowJmsType", this.allowJmsType);
        }
        if (this.collectionType != null) {
            this.setProperty(camelContext, dataFormat, "collectionType", this.collectionType);
        }
        if (this.useList != null) {
            this.setProperty(camelContext, dataFormat, "useList", this.useList);
        }
    }
}

