/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.event;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.management.event.AbstractExchangeEvent;

public class ExchangeFailureHandledEvent
extends AbstractExchangeEvent {
    private static final long serialVersionUID = -7554809462006009547L;
    private final Processor failureHandler;
    private final boolean deadLetterChannel;
    private final boolean handled;

    public ExchangeFailureHandledEvent(Exchange source, Processor failureHandler, boolean deadLetterChannel) {
        super(source);
        this.failureHandler = failureHandler;
        this.deadLetterChannel = deadLetterChannel;
        this.handled = source.getProperty("CamelErrorHandlerHandled", false, Boolean.class);
    }

    public Processor getFailureHandler() {
        return this.failureHandler;
    }

    public boolean isDeadLetterChannel() {
        return this.deadLetterChannel;
    }

    public boolean isHandled() {
        return this.handled;
    }

    @Override
    public String toString() {
        if (this.isDeadLetterChannel()) {
            return this.getExchange().getExchangeId() + " exchange failed: " + this.getExchange() + " but was handled by dead letter channel: " + this.failureHandler;
        }
        return this.getExchange().getExchangeId() + " exchange failed: " + this.getExchange() + " but was processed by: " + this.failureHandler;
    }
}

