/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.repository.specification;

import java.util.Collection;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.fao.geonet.domain.OperationAllowed;
import org.fao.geonet.domain.OperationAllowedId_;
import org.fao.geonet.domain.OperationAllowed_;
import org.fao.geonet.domain.ReservedGroup;
import org.fao.geonet.domain.ReservedOperation;
import org.springframework.data.jpa.domain.Specification;

public final class OperationAllowedSpecs {
    private OperationAllowedSpecs() {
    }

    public static Specification<OperationAllowed> hasMetadataId(String metadataId) {
        return OperationAllowedSpecs.hasMetadataId(Integer.valueOf(metadataId));
    }

    public static Specification<OperationAllowed> hasMetadataId(final int metadataId) {
        return new Specification<OperationAllowed>(){

            public Predicate toPredicate(Root<OperationAllowed> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                Path mdIdAttributePath = root.get(OperationAllowed_.id).get(OperationAllowedId_.metadataId);
                Predicate mdIdEqualPredicate = cb.equal((Expression)mdIdAttributePath, cb.literal((Object)metadataId));
                return mdIdEqualPredicate;
            }
        };
    }

    public static Specification<OperationAllowed> hasGroupId(final int groupId) {
        return new Specification<OperationAllowed>(){

            public Predicate toPredicate(Root<OperationAllowed> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                Path mdIdAttributePath = root.get(OperationAllowed_.id).get(OperationAllowedId_.groupId);
                return cb.equal((Expression)mdIdAttributePath, cb.literal((Object)groupId));
            }
        };
    }

    public static Specification<OperationAllowed> hasOperation(ReservedOperation operation) {
        return OperationAllowedSpecs.hasOperationId(operation.getId());
    }

    public static Specification<OperationAllowed> hasOperationId(final int operationId) {
        return new Specification<OperationAllowed>(){

            public Predicate toPredicate(Root<OperationAllowed> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                Path opIdAttributePath = root.get(OperationAllowed_.id).get(OperationAllowedId_.operationId);
                Predicate opIdEqualPredicate = cb.equal((Expression)opIdAttributePath, cb.literal((Object)operationId));
                return opIdEqualPredicate;
            }
        };
    }

    public static Specification<OperationAllowed> isPublic(final ReservedOperation operation) {
        return new Specification<OperationAllowed>(){

            public Predicate toPredicate(Root<OperationAllowed> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                Path opIdAttributePath = root.get(OperationAllowed_.id).get(OperationAllowedId_.operationId);
                Path groupIdAttributePath = root.get(OperationAllowed_.id).get(OperationAllowedId_.groupId);
                Predicate opIdEqualPredicate = cb.equal((Expression)opIdAttributePath, cb.literal((Object)operation.getId()));
                Predicate allGroup = cb.equal((Expression)groupIdAttributePath, cb.literal((Object)ReservedGroup.all.getId()));
                return cb.and((Expression)opIdEqualPredicate, (Expression)allGroup);
            }
        };
    }

    public static Specification<OperationAllowed> hasMetadataIdIn(final Collection<Integer> metadataIds) {
        return new Specification<OperationAllowed>(){

            public Predicate toPredicate(Root<OperationAllowed> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                return root.get(OperationAllowed_.id).get(OperationAllowedId_.metadataId).in(metadataIds);
            }
        };
    }

    public static Specification<OperationAllowed> hasGroupIdIn(final Collection<Integer> groupIds) {
        return new Specification<OperationAllowed>(){

            public Predicate toPredicate(Root<OperationAllowed> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                return root.get(OperationAllowed_.id).get(OperationAllowedId_.groupId).in(groupIds);
            }
        };
    }

    public static Specification<OperationAllowed> hasOperationIdIn(final Collection<Integer> operationIds) {
        return new Specification<OperationAllowed>(){

            public Predicate toPredicate(Root<OperationAllowed> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                return root.get(OperationAllowed_.id).get(OperationAllowedId_.operationId).in(operationIds);
            }
        };
    }
}

