/*
 * Decompiled with CFR 0.152.
 */
package org.z3950.zing.cql;

import java.util.Vector;
import org.z3950.zing.cql.Utils;

public class ModifierSet {
    String base;
    Vector modifiers;

    public ModifierSet(String string) {
        this.base = string;
        this.modifiers = new Vector();
    }

    public String getBase() {
        return this.base;
    }

    public void addModifier(String string, String string2) {
        Vector<String> vector = new Vector<String>();
        vector.add(string);
        vector.add(string2);
        this.modifiers.add(vector);
    }

    public String modifier(String string) {
        int n = this.modifiers.size();
        for (int i = 0; i < n; ++i) {
            Vector vector = (Vector)this.modifiers.get(i);
            if (!vector.get(0).equals(string)) continue;
            return (String)vector.get(1);
        }
        return null;
    }

    public Vector[] getModifiers() {
        int n = this.modifiers.size();
        Vector[] vectorArray = new Vector[n];
        for (int i = 0; i < n; ++i) {
            vectorArray[i] = (Vector)this.modifiers.get(i);
        }
        return vectorArray;
    }

    public String toXCQL(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Utils.indent(n) + "<" + string + ">\n" + Utils.indent(n + 1) + "<value>" + Utils.xq(this.base) + "</value>\n");
        Vector[] vectorArray = this.getModifiers();
        if (vectorArray.length > 0) {
            stringBuffer.append(Utils.indent(n + 1) + "<modifiers>\n");
            for (int i = 0; i < vectorArray.length; ++i) {
                Vector vector = vectorArray[i];
                stringBuffer.append(Utils.indent(n + 2)).append("<modifier>");
                if (vector.get(0) != null) {
                    stringBuffer.append("<type>").append(Utils.xq((String)vector.get(0))).append("</type>");
                }
                stringBuffer.append("<value>").append(Utils.xq((String)vector.get(1))).append("</value>");
                stringBuffer.append("</modifier>\n");
            }
            stringBuffer.append(Utils.indent(n + 1) + "</modifiers>\n");
        }
        stringBuffer.append(Utils.indent(n) + "</" + string + ">\n");
        return stringBuffer.toString();
    }

    public String toCQL() {
        StringBuffer stringBuffer = new StringBuffer(this.base);
        Vector[] vectorArray = this.getModifiers();
        for (int i = 0; i < vectorArray.length; ++i) {
            stringBuffer.append("/").append(vectorArray[i].get(1));
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.err.println("Usage: ModifierSet <base> [<type> <name>]...");
            System.exit(1);
        }
        ModifierSet modifierSet = new ModifierSet(stringArray[0]);
        for (int i = 1; i < stringArray.length; i += 2) {
            modifierSet.addModifier(stringArray[i], stringArray[i + 1]);
        }
        System.out.println(modifierSet.toCQL());
    }
}

