/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc2;

import org.tmatesoft.svn.core.SVNException;

public class SvnChecksum {
    private Kind kind;
    private String digest;

    public SvnChecksum(Kind kind, String digest) {
        this.setKind(kind);
        this.setDigest(digest);
    }

    public Kind getKind() {
        return this.kind;
    }

    public String getDigest() {
        return this.digest;
    }

    public void setKind(Kind kind) {
        this.kind = kind;
    }

    public void setDigest(String digest) {
        this.digest = digest;
    }

    public String toString() {
        return '$' + (this.getKind() == Kind.md5 ? "md5 $" : "sha1$") + this.getDigest();
    }

    public int hashCode() {
        int hashCode = 17;
        if (this.digest != null) {
            hashCode += 37 * this.digest.hashCode();
        }
        if (this.kind != null) {
            hashCode += 37 * this.kind.hashCode();
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != SvnChecksum.class) {
            return false;
        }
        SvnChecksum other = (SvnChecksum)obj;
        boolean equals = true;
        equals = other.digest == null ? this.digest == null : other.digest.equals(this.digest);
        if (equals) {
            equals = other.kind == this.kind;
        }
        return equals;
    }

    public static SvnChecksum fromString(String checksum) throws SVNException {
        if (checksum == null || checksum.length() < 7) {
            return null;
        }
        Kind kind = checksum.charAt(1) == 'm' ? Kind.md5 : Kind.sha1;
        String digest = checksum.substring(6);
        return new SvnChecksum(kind, digest);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Kind {
        sha1,
        md5;

    }
}

