/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.utils;

import javax.persistence.EntityManager;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public abstract class JpaClassUtils {
    private JpaClassUtils() {
    }

    public static boolean isEntityManagerOfType(EntityManager em, String type) {
        Assert.notNull((Object)em, (String)"EntityManager must not be null!");
        Assert.hasText((String)type, (String)"EntityManager type must not be null!");
        try {
            ClassLoader loader = em.getDelegate().getClass().getClassLoader();
            Class emType = ClassUtils.forName((String)type, (ClassLoader)loader);
            emType.cast(em);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

