/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs;

import java.awt.RenderingHints;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.ows.HTTPClient;
import org.geotools.data.ows.HTTPResponse;
import org.geotools.data.ows.SimpleHttpClient;
import org.geotools.data.wfs.WFSDataStore;
import org.geotools.data.wfs.protocol.http.HttpMethod;
import org.geotools.data.wfs.protocol.http.HttpUtil;
import org.geotools.data.wfs.protocol.wfs.Version;
import org.geotools.data.wfs.v1_0_0.WFS100ProtocolHandler;
import org.geotools.data.wfs.v1_0_0.WFS_1_0_0_DataStore;
import org.geotools.data.wfs.v1_1_0.ArcGISServerStrategy;
import org.geotools.data.wfs.v1_1_0.CubeWerxStrategy;
import org.geotools.data.wfs.v1_1_0.DefaultWFSStrategy;
import org.geotools.data.wfs.v1_1_0.GeoServerStrategy;
import org.geotools.data.wfs.v1_1_0.IonicStrategy;
import org.geotools.data.wfs.v1_1_0.MapServerStrategy;
import org.geotools.data.wfs.v1_1_0.WFSStrategy;
import org.geotools.data.wfs.v1_1_0.WFS_1_1_0_DataStore;
import org.geotools.data.wfs.v1_1_0.WFS_1_1_0_Protocol;
import org.geotools.util.logging.Logging;
import org.geotools.wfs.WFS;
import org.geotools.wfs.protocol.ConnectionFactory;
import org.geotools.wfs.protocol.DefaultConnectionFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class WFSDataStoreFactory
implements DataStoreFactorySpi {
    private static final Logger logger = Logging.getLogger((String)"org.geotools.data.wfs");
    private HTTPClient http = new SimpleHttpClient();
    private static final WFSFactoryParam<?>[] parametersInfo = new WFSFactoryParam[17];
    public static final WFSFactoryParam<URL> URL;
    public static final WFSFactoryParam<Boolean> PROTOCOL;
    public static final WFSFactoryParam<String> USERNAME;
    public static final WFSFactoryParam<String> PASSWORD;
    public static final WFSFactoryParam<String> ENCODING;
    public static final WFSFactoryParam<Integer> TIMEOUT;
    public static final WFSFactoryParam<Integer> BUFFER_SIZE;
    public static final WFSFactoryParam<Boolean> TRY_GZIP;
    public static final WFSFactoryParam<Boolean> LENIENT;
    public static final WFSFactoryParam<Integer> MAXFEATURES;
    public static final WFSFactoryParam<Integer> FILTER_COMPLIANCE;
    public static final WFSFactoryParam<String> WFS_STRATEGY;
    public static final WFSFactoryParam<String> NAMESPACE;
    public static final WFSFactoryParam<Boolean> USEDEFAULTSRS;
    public static final WFSFactoryParam<String> AXIS_ORDER;
    public static final WFSFactoryParam<String> AXIS_ORDER_FILTER;
    public static final WFSFactoryParam<String> OUTPUTFORMAT;

    @Override
    public WFSDataStore createDataStore(Map params) throws IOException {
        WFSDataStore dataStore;
        URL getCapabilitiesRequest = URL.lookUp(params);
        Boolean protocol = PROTOCOL.lookUp(params);
        String user = USERNAME.lookUp(params);
        String pass = PASSWORD.lookUp(params);
        int timeoutMillis = TIMEOUT.lookUp(params);
        int buffer = BUFFER_SIZE.lookUp(params);
        boolean tryGZIP = TRY_GZIP.lookUp(params);
        boolean lenient = LENIENT.lookUp(params);
        String encoding = ENCODING.lookUp(params);
        Integer maxFeatures = MAXFEATURES.lookUp(params);
        Charset defaultEncoding = Charset.forName(encoding);
        String wfsStrategy = WFS_STRATEGY.lookUp(params);
        Integer filterCompliance = FILTER_COMPLIANCE.lookUp(params);
        String namespaceOverride = NAMESPACE.lookUp(params);
        Boolean useDefaultSRS = USEDEFAULTSRS.lookUp(params);
        String axisOrder = AXIS_ORDER.lookUp(params);
        String axisOrderFilter = AXIS_ORDER_FILTER.lookUp(params) == null ? AXIS_ORDER.lookUp(params) : AXIS_ORDER_FILTER.lookUp(params);
        String outputFormat = OUTPUTFORMAT.lookUp(params);
        if (user == null && pass != null || pass == null && user != null) {
            throw new IOException("Cannot define only one of USERNAME or PASSWORD, must define both or neither");
        }
        this.http.setTryGzip(tryGZIP);
        this.http.setUser(user);
        this.http.setPassword(pass);
        this.http.setConnectTimeout(timeoutMillis / 1000);
        this.http.setReadTimeout(timeoutMillis / 1000);
        byte[] wfsCapabilitiesRawData = this.loadCapabilities(getCapabilitiesRequest, this.http);
        Document capsDoc = WFSDataStoreFactory.parseCapabilities(wfsCapabilitiesRawData);
        Element rootElement = capsDoc.getDocumentElement();
        String capsVersion = rootElement.getAttribute("version");
        Version version = Version.find(capsVersion);
        if (Version.v1_0_0 == version) {
            DefaultConnectionFactory connectionFac = new DefaultConnectionFactory(tryGZIP, user, pass, defaultEncoding, timeoutMillis);
            ByteArrayInputStream reader = new ByteArrayInputStream(wfsCapabilitiesRawData);
            WFS100ProtocolHandler protocolHandler = new WFS100ProtocolHandler(reader, (ConnectionFactory)connectionFac);
            try {
                HttpMethod prefferredProtocol = Boolean.TRUE.equals(protocol) ? HttpMethod.POST : HttpMethod.GET;
                dataStore = new WFS_1_0_0_DataStore(prefferredProtocol, protocolHandler, timeoutMillis, buffer, lenient, wfsStrategy, filterCompliance);
            }
            catch (SAXException e) {
                logger.warning(e.toString());
                throw new IOException(e.toString());
            }
        } else {
            ByteArrayInputStream capsIn = new ByteArrayInputStream(wfsCapabilitiesRawData);
            WFSStrategy strategy = WFSDataStoreFactory.determineCorrectStrategy(getCapabilitiesRequest, capsDoc, wfsStrategy);
            WFS_1_1_0_Protocol wfs = new WFS_1_1_0_Protocol(capsIn, this.http, defaultEncoding, strategy);
            dataStore = new WFS_1_1_0_DataStore(wfs);
            dataStore.setMaxFeatures(maxFeatures);
            dataStore.setPreferPostOverGet(protocol);
            dataStore.setUseDefaultSRS(useDefaultSRS);
            ((WFS_1_1_0_DataStore)dataStore).setAxisOrder(axisOrder, axisOrderFilter);
            ((WFS_1_1_0_DataStore)dataStore).setGetFeatureOutputFormat(outputFormat);
            ((WFS_1_1_0_DataStore)dataStore).setMappedURIs(strategy.getNamespaceURIMappings());
        }
        dataStore.setNamespaceOverride(namespaceOverride);
        return dataStore;
    }

    private static Document parseCapabilities(byte[] wfsCapabilitiesRawData) throws IOException, DataSourceException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(wfsCapabilitiesRawData);
        Document capsDoc = WFSDataStoreFactory.parseCapabilities(inputStream);
        Element root = capsDoc.getDocumentElement();
        String localName = root.getLocalName();
        String namespace = root.getNamespaceURI();
        if (!"http://www.opengis.net/wfs".equals(namespace) || !WFS.WFS_Capabilities.getLocalPart().equals(localName)) {
            if ("http://www.opengis.net/ows".equals(namespace) && "ExceptionReport".equals(localName)) {
                StringBuffer message = new StringBuffer();
                Element exception = (Element)capsDoc.getElementsByTagNameNS("*", "Exception").item(0);
                if (exception == null) {
                    throw new DataSourceException("Exception Report when requesting capabilities");
                }
                Node exceptionCode = exception.getAttributes().getNamedItem("exceptionCode");
                Node locator = exception.getAttributes().getNamedItem("locator");
                Node exceptionText = exception.getElementsByTagNameNS("*", "ExceptionText").item(0);
                message.append("Exception Report ");
                String text = exceptionText.getTextContent();
                if (text != null) {
                    message.append(text.trim());
                }
                message.append(" Exception Code:");
                message.append(exceptionCode == null ? "" : exceptionCode.getTextContent());
                message.append(" Locator: ");
                message.append(locator == null ? "" : locator.getTextContent());
                throw new DataSourceException(message.toString());
            }
            throw new DataSourceException("Expected " + WFS.WFS_Capabilities + " but was " + namespace + "#" + localName);
        }
        return capsDoc;
    }

    static WFSStrategy determineCorrectStrategy(URL getCapabilitiesRequest, Document capabilitiesDoc, String override) {
        Element root;
        String ionicNs;
        DefaultWFSStrategy strategy = null;
        if (override != null) {
            if (override.equalsIgnoreCase("geoserver")) {
                strategy = new GeoServerStrategy();
            } else if (override.equalsIgnoreCase("mapserver")) {
                strategy = new MapServerStrategy();
            } else if (override.equalsIgnoreCase("arcgis")) {
                strategy = new ArcGISServerStrategy();
            } else if (override.equalsIgnoreCase("cubewerx")) {
                strategy = new CubeWerxStrategy();
            } else if (override.equalsIgnoreCase("ionic")) {
                strategy = new IonicStrategy();
            } else {
                logger.warning("Could not handle wfs strategy override " + override + " proceeding with autodetection");
            }
        }
        if (strategy == null) {
            NodeList childNodes = capabilitiesDoc.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node child = childNodes.item(i);
                if (child.getNodeType() != 8) continue;
                String nodeValue = child.getNodeValue();
                if (!(nodeValue = nodeValue.toLowerCase()).contains("cubewerx")) continue;
                strategy = new CubeWerxStrategy();
                break;
            }
        }
        if (strategy == null && (ionicNs = (root = capabilitiesDoc.getDocumentElement()).getAttribute("xmlns:ionic")) != null) {
            if (ionicNs.equals("http://www.ionicsoft.com/versions/4")) {
                strategy = new IonicStrategy();
            } else if (ionicNs.startsWith("http://www.ionicsoft.com/versions")) {
                logger.warning("Found a Ionic server but the version may not match the strategy we have (v.4). Ionic namespace url: " + ionicNs);
                strategy = new IonicStrategy();
            }
        }
        if (strategy == null) {
            String uri = getCapabilitiesRequest.toExternalForm();
            if (uri.contains("geoserver")) {
                strategy = new GeoServerStrategy();
            } else if (uri.contains("/ArcGIS/services/")) {
                strategy = new ArcGISServerStrategy();
            }
        }
        if (strategy == null) {
            strategy = new DefaultWFSStrategy();
        }
        logger.info("Using WFS Strategy: " + strategy.getClass().getName());
        return strategy;
    }

    public void setHTTPClient(HTTPClient http) {
        this.http = http;
    }

    public DataStore createNewDataStore(Map params) throws IOException {
        throw new UnsupportedOperationException("Operation not applicable to a WFS service");
    }

    @Override
    public String getDescription() {
        return "The WFSDataStore represents a connection to a Web Feature Server. This connection provides access to the Features published by the server, and the ability to perform transactions on the server (when supported / allowed).";
    }

    @Override
    public DataAccessFactory.Param[] getParametersInfo() {
        int length = parametersInfo.length;
        DataAccessFactory.Param[] params = new DataAccessFactory.Param[length];
        System.arraycopy(parametersInfo, 0, params, 0, length);
        return params;
    }

    public boolean canProcess(Map params) {
        if (params == null) {
            return false;
        }
        try {
            URL url = URL.lookUp(params);
            if (!"http".equalsIgnoreCase(url.getProtocol()) && !"https".equalsIgnoreCase(url.getProtocol())) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return !(params.containsKey(WFSDataStoreFactory.USERNAME.key) ? !params.containsKey(WFSDataStoreFactory.PASSWORD.key) : params.containsKey(WFSDataStoreFactory.PASSWORD.key));
    }

    @Override
    public String getDisplayName() {
        return "Web Feature Server";
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    public static URL createGetCapabilitiesRequest(URL host, Version version) {
        URL getcapsUrl;
        if (host == null) {
            throw new NullPointerException("null url");
        }
        if (version == null) {
            throw new NullPointerException("version");
        }
        HashMap<String, String> getCapsKvp = new HashMap<String, String>();
        getCapsKvp.put("SERVICE", "WFS");
        getCapsKvp.put("REQUEST", "GetCapabilities");
        getCapsKvp.put("VERSION", version.toString());
        try {
            getcapsUrl = HttpUtil.createUrl(host, getCapsKvp);
        }
        catch (MalformedURLException e) {
            logger.log(Level.WARNING, "Can't create GetCapabilities request from " + host, e);
            throw new RuntimeException(e);
        }
        return getcapsUrl;
    }

    public static URL createGetCapabilitiesRequest(URL host) {
        Version defaultVersion;
        if (host == null) {
            throw new NullPointerException("url");
        }
        String queryString = host.getQuery();
        queryString = queryString == null || "".equals(queryString.trim()) ? "" : queryString.toUpperCase();
        Version requestVersion = defaultVersion = Version.v1_0_0;
        if (queryString.length() > 0) {
            String version;
            String[] split;
            HashMap<String, String> params = new HashMap<String, String>();
            for (String kvp : split = queryString.split("&")) {
                int index = kvp.indexOf(61);
                String key = index > 0 ? kvp.substring(0, index) : kvp;
                String value = index > 0 ? kvp.substring(index + 1) : null;
                params.put(key, value);
            }
            String request = (String)params.get("REQUEST");
            if ("GETCAPABILITIES".equals(request) && (version = (String)params.get("VERSION")) != null && (requestVersion = Version.find(version)) == null) {
                requestVersion = defaultVersion;
            }
        }
        return WFSDataStoreFactory.createGetCapabilitiesRequest(host, requestVersion);
    }

    byte[] loadCapabilities(URL capabilitiesUrl, HTTPClient http) throws IOException {
        int readCount;
        HTTPResponse httpResponse = http.get(capabilitiesUrl);
        InputStream inputStream = httpResponse.getResponseStream();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buff = new byte[1024];
        while ((readCount = inputStream.read(buff)) != -1) {
            out.write(buff, 0, readCount);
        }
        byte[] wfsCapabilitiesRawData = out.toByteArray();
        return wfsCapabilitiesRawData;
    }

    static Document parseCapabilities(InputStream inputStream) throws IOException, DataSourceException {
        Document document;
        DocumentBuilder documentBuilder;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        try {
            documentBuilder = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        try {
            document = documentBuilder.parse(inputStream);
        }
        catch (SAXException e) {
            throw new DataSourceException("Error parsing capabilities document", e);
        }
        return document;
    }

    public Map<RenderingHints.Key, ?> getImplementationHints() {
        return Collections.EMPTY_MAP;
    }

    static {
        String name = "WFSDataStoreFactory:GET_CAPABILITIES_URL";
        String description = "Represents a URL to the getCapabilities document or a server instance.";
        URL = new WFSFactoryParam<URL>(name, URL.class, description);
        WFSDataStoreFactory.parametersInfo[0] = URL;
        name = "WFSDataStoreFactory:PROTOCOL";
        description = "Sets a preference for the HTTP protocol to use when requesting WFS functionality. Set this value to Boolean.TRUE for POST, Boolean.FALSE for GET or NULL for AUTO";
        PROTOCOL = new WFSFactoryParam<Object>(name, (Class<Object>)Boolean.class, description, null);
        WFSDataStoreFactory.parametersInfo[1] = PROTOCOL;
        name = "WFSDataStoreFactory:USERNAME";
        description = "This allows the user to specify a username. This param should not be used without the PASSWORD param.";
        USERNAME = new WFSFactoryParam<Object>(name, (Class<Object>)String.class, description, null);
        WFSDataStoreFactory.parametersInfo[2] = USERNAME;
        name = "WFSDataStoreFactory:PASSWORD";
        description = "This allows the user to specify a username. This param should not be used without the USERNAME param.";
        PASSWORD = new WFSFactoryParam<Object>(name, String.class, description, null, "isPassword", true);
        WFSDataStoreFactory.parametersInfo[3] = PASSWORD;
        name = "WFSDataStoreFactory:ENCODING";
        description = "This allows the user to specify the character encoding of the XML-Requests sent to the Server. Defaults to UTF-8";
        String defaultValue = "UTF-8";
        ArrayList<String> options = new ArrayList<String>(Charset.availableCharsets().keySet());
        Collections.sort(options);
        ENCODING = new WFSFactoryParam<String>(name, String.class, description, defaultValue, "options", options);
        WFSDataStoreFactory.parametersInfo[4] = ENCODING;
        name = "WFSDataStoreFactory:TIMEOUT";
        description = "This allows the user to specify a timeout in milliseconds. This param has a default value of 3000ms.";
        TIMEOUT = new WFSFactoryParam<Integer>(name, Integer.class, description, Integer.valueOf(3000));
        WFSDataStoreFactory.parametersInfo[5] = TIMEOUT;
        name = "WFSDataStoreFactory:BUFFER_SIZE";
        description = "This allows the user to specify a buffer size in features. This param has a default value of 10 features.";
        BUFFER_SIZE = new WFSFactoryParam<Integer>(name, Integer.class, description, Integer.valueOf(10));
        WFSDataStoreFactory.parametersInfo[6] = BUFFER_SIZE;
        name = "WFSDataStoreFactory:TRY_GZIP";
        description = "Indicates that datastore should use gzip to transfer data if the server supports it. Default is true";
        TRY_GZIP = new WFSFactoryParam<Boolean>(name, Boolean.class, description, Boolean.TRUE);
        WFSDataStoreFactory.parametersInfo[7] = TRY_GZIP;
        name = "WFSDataStoreFactory:LENIENT";
        description = "Indicates that datastore should do its best to create features from the provided data even if it does not accurately match the schema.  Errors will be logged but the parsing will continue if this is true.  Default is false";
        LENIENT = new WFSFactoryParam<Boolean>(name, Boolean.class, description, Boolean.valueOf(false));
        WFSDataStoreFactory.parametersInfo[8] = LENIENT;
        name = "WFSDataStoreFactory:MAXFEATURES";
        description = "Positive integer used as a hard limit for the amount of Features to retrieve for each FeatureType. A value of zero or not providing this parameter means no limit.";
        MAXFEATURES = new WFSFactoryParam<Integer>(name, Integer.class, description, Integer.valueOf(0));
        WFSDataStoreFactory.parametersInfo[9] = MAXFEATURES;
        name = "WFSDataStoreFactory:FILTER_COMPLIANCE";
        description = "Level of compliance to WFS specification (0-low,1-medium,2-high)";
        List<Object> options2 = Arrays.asList(0, 1, 2);
        FILTER_COMPLIANCE = new WFSFactoryParam<Object>(name, Integer.class, description, null, "options", options2);
        WFSDataStoreFactory.parametersInfo[10] = FILTER_COMPLIANCE;
        name = "WFSDataStoreFactory:WFS_STRATEGY";
        description = "Override wfs stragegy with either arcgis, cubwerx, ionic, mapserver, geoserver, strict or nonstrict strategy.";
        options2 = Arrays.asList("strict", "nonstrict", "mapserver", "geoserver", "arcgis", "cubewerx", "ionix");
        WFS_STRATEGY = new WFSFactoryParam<Object>(name, String.class, description, null, "options", options2);
        WFSDataStoreFactory.parametersInfo[11] = WFS_STRATEGY;
        name = "namespace";
        description = "Override the original WFS type name namespaces";
        NAMESPACE = new WFSFactoryParam<Object>(name, (Class<Object>)String.class, description, null);
        WFSDataStoreFactory.parametersInfo[12] = NAMESPACE;
        name = "usedefaultsrs";
        description = "Use always the declared DefaultSRS for requests and reproject locally if necessary";
        USEDEFAULTSRS = new WFSFactoryParam<Boolean>(name, Boolean.class, description, Boolean.valueOf(false));
        WFSDataStoreFactory.parametersInfo[13] = USEDEFAULTSRS;
        name = "WFSDataStoreFactory:AXIS_ORDER";
        description = "Indicates axis order used by the remote WFS server in result coordinates. It applies only to WFS 1.1.0 servers. Default is Compliant";
        options2 = Arrays.asList("Compliant", "East / North", "North / East");
        AXIS_ORDER = new WFSFactoryParam<String>(name, String.class, description, "Compliant", "options", options2);
        WFSDataStoreFactory.parametersInfo[14] = AXIS_ORDER;
        name = "WFSDataStoreFactory:AXIS_ORDER_FILTER";
        description = "Indicates axis order used by the remote WFS server for filters. It applies only to WFS 1.1.0 servers. Default is the same as AXIS_ORDER";
        options2 = Arrays.asList("Compliant", "East / North", "North / East");
        AXIS_ORDER_FILTER = new WFSFactoryParam<Object>(name, String.class, description, null, "options", options2);
        WFSDataStoreFactory.parametersInfo[15] = AXIS_ORDER_FILTER;
        name = "WFSDataStoreFactory:OUTPUTFORMAT";
        description = "This allows the user to specify an outputFormat, different from the default one.";
        OUTPUTFORMAT = new WFSFactoryParam<Object>(name, (Class<Object>)String.class, description, null);
        WFSDataStoreFactory.parametersInfo[16] = OUTPUTFORMAT;
    }

    public static class WFSFactoryParam<T>
    extends DataAccessFactory.Param {
        private T defaultValue;

        public WFSFactoryParam(String key, Class<T> type, String description) {
            super(key, type, description, true);
        }

        public WFSFactoryParam(String key, Class<T> type, String description, T defaultValue) {
            super(key, type, description, false, defaultValue);
            this.defaultValue = defaultValue;
        }

        public WFSFactoryParam(String key, Class<T> type, String description, T defaultValue, Object ... metadata) {
            super(key, type, description, false, defaultValue, metadata);
            this.defaultValue = defaultValue;
        }

        public T lookUp(Map params) throws IOException {
            Object parameter = super.lookUp(params);
            return (T)(parameter == null ? this.defaultValue : parameter);
        }
    }
}

