/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.component.csw;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jeeves.server.context.ServiceContext;
import jeeves.server.sources.ServiceRequest;
import org.fao.geonet.Util;
import org.fao.geonet.csw.common.exceptions.CatalogException;
import org.fao.geonet.csw.common.exceptions.MissingParameterValueEx;
import org.fao.geonet.csw.common.exceptions.NoApplicableCodeEx;
import org.fao.geonet.csw.common.exceptions.OperationNotSupportedEx;
import org.fao.geonet.kernel.csw.CatalogService;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.SOAPUtil;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class CatalogDispatcher {
    @Autowired
    ApplicationContext appContext;

    public static Map<String, String> extractParams(Element request) {
        HashMap<String, String> hm = new HashMap<String, String>();
        List params = request.getChildren();
        for (Element param : params) {
            String name = param.getName().toLowerCase();
            String value = param.getTextTrim();
            hm.put(name, value);
        }
        return hm;
    }

    public Element dispatch(Element request, ServiceContext context, String cswServiceSpecificContraint) {
        CatalogException exc;
        context.info("Received:\n" + Xml.getString((Element)request));
        ServiceRequest.InputMethod im = context.getInputMethod();
        ServiceRequest.OutputMethod om = context.getOutputMethod();
        boolean inSOAP = im == ServiceRequest.InputMethod.SOAP;
        boolean outSOAP = inSOAP || om == ServiceRequest.OutputMethod.SOAP;
        try {
            if (inSOAP) {
                request = SOAPUtil.unembed((Element)request);
            }
            Element response = this.dispatchI(request, context, cswServiceSpecificContraint);
            if (outSOAP) {
                response = SOAPUtil.embed((Element)response);
            }
            return response;
        }
        catch (CatalogException e) {
            exc = e;
        }
        catch (Exception e) {
            context.info("Exception stack trace : \n" + Util.getStackTrace((Throwable)e));
            exc = new NoApplicableCodeEx(e.toString());
        }
        Element response = CatalogException.marshal(exc);
        boolean sender = exc instanceof NoApplicableCodeEx;
        if (outSOAP) {
            return SOAPUtil.embedExc((Element)response, (boolean)sender, (String)exc.getCode(), (String)exc.toString());
        }
        return response;
    }

    private Element dispatchI(Element request, ServiceContext context, String cswServiceSpecificContraint) throws CatalogException {
        ServiceRequest.InputMethod im = context.getInputMethod();
        if (im == ServiceRequest.InputMethod.XML || im == ServiceRequest.InputMethod.SOAP) {
            String operation = request.getName();
            CatalogService cs = this.lookUpService(operation);
            if (cs == null) {
                throw new OperationNotSupportedEx(operation);
            }
            Log.info((String)"geonetwork.csw", (Object)("Dispatching operation : " + operation));
            if (cswServiceSpecificContraint != null) {
                request.addContent((Content)new Element("filter").setText(cswServiceSpecificContraint));
            }
            return cs.execute(request, context);
        }
        Map<String, String> params = CatalogDispatcher.extractParams(request);
        String operation = params.get("request");
        if (operation == null) {
            throw new MissingParameterValueEx("request");
        }
        CatalogService cs = this.lookUpService(operation);
        if (cs == null) {
            throw new OperationNotSupportedEx(operation);
        }
        request = cs.adaptGetRequest(params);
        if (cswServiceSpecificContraint != null) {
            request.addContent((Content)new Element("filter").setText(cswServiceSpecificContraint));
        }
        if (context.isDebugEnabled()) {
            context.debug("Adapted GET request is:\n" + Xml.getString((Element)request));
        }
        context.info("Dispatching operation : " + operation);
        return cs.execute(request, context);
    }

    private CatalogService lookUpService(String operation) {
        return (CatalogService)this.appContext.getBean("CswService." + operation, CatalogService.class);
    }
}

