/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.pdf.PdfContentByte;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.map.MapTileTask;
import org.pvalsecc.concurrent.BlockingSimpleTarget;
import org.pvalsecc.concurrent.OrderedResultsExecutor;

public class ParallelMapTileLoader
implements OrderedResultsExecutor.ResultCollector<MapTileTask> {
    private final PdfContentByte dc;
    private RenderingContext context;
    private final OrderedResultsExecutor<MapTileTask> executor;
    private final BlockingSimpleTarget target = new BlockingSimpleTarget("mapTiles");
    private int nbTiles = 0;

    public ParallelMapTileLoader(RenderingContext context, PdfContentByte dc) {
        this.executor = context.getConfig().getMapRenderingExecutor();
        this.dc = dc;
        this.context = context;
    }

    public void addTileToLoad(MapTileTask task) {
        ++this.nbTiles;
        if (this.executor != null) {
            this.executor.addTask(task, this);
        } else {
            task.process();
            this.handle(task);
        }
    }

    public void waitForCompletion() {
        this.target.setTarget(this.nbTiles);
        try {
            this.target.waitForCompletion(TimeUnit.MINUTES.toMillis(this.context.getConfig().getPrintTimeoutMinutes()));
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(MapTileTask mapTileTaskResult) {
        block11: {
            try {
                if (mapTileTaskResult.handleException(this.context)) break block11;
                Object object = this.context.getPdfLock();
                synchronized (object) {
                    this.dc.saveState();
                    try {
                        mapTileTaskResult.renderOnPdf(this.dc);
                    }
                    catch (DocumentException e) {
                        this.context.addError((Exception)((Object)e));
                    }
                    finally {
                        this.dc.restoreState();
                    }
                }
            }
            finally {
                this.target.addDone(1);
            }
        }
    }
}

