/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.config.layout;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfPTable;
import java.util.ArrayList;
import org.mapfish.print.InvalidValueException;
import org.mapfish.print.PDFUtils;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.config.layout.Block;
import org.mapfish.print.utils.PJsonObject;

public class HeaderFooter {
    private int height = 0;
    private ArrayList<Block> items = new ArrayList();

    public void setHeight(int height) {
        this.height = height;
    }

    public void setItems(ArrayList<Block> items) {
        this.items = items;
    }

    public int getHeight() {
        return this.height;
    }

    public void render(Rectangle rectangle, PdfContentByte dc, PJsonObject params, RenderingContext context) {
        try {
            PdfPTable table = PDFUtils.buildTable(this.items, params, context, 1, null);
            if (table != null) {
                table.setTotalWidth(rectangle.getWidth());
                table.writeSelectedRows(0, -1, rectangle.getLeft(), rectangle.getTop(), dc);
            }
        }
        catch (DocumentException e) {
            context.addError((Exception)((Object)e));
        }
    }

    public void validate() {
        if (this.height <= 0) {
            throw new InvalidValueException("height", this.height);
        }
        for (int i = 0; i < this.items.size(); ++i) {
            this.items.get(i).validate();
        }
    }
}

