/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.set;

import bak.pcj.CharCollection;
import bak.pcj.CharIterator;
import bak.pcj.hash.CharHashFunction;
import bak.pcj.hash.DefaultCharHashFunction;
import bak.pcj.hash.Primes;
import bak.pcj.set.AbstractCharSet;
import bak.pcj.set.CharSet;
import bak.pcj.util.Exceptions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;

public class CharOpenHashSet
extends AbstractCharSet
implements CharSet,
Cloneable,
Serializable {
    private static final int GROWTH_POLICY_RELATIVE = 0;
    private static final int GROWTH_POLICY_ABSOLUTE = 1;
    private static final int DEFAULT_GROWTH_POLICY = 0;
    public static final double DEFAULT_GROWTH_FACTOR = 1.0;
    public static final int DEFAULT_GROWTH_CHUNK = 10;
    public static final int DEFAULT_CAPACITY = 11;
    public static final double DEFAULT_LOAD_FACTOR = 0.75;
    private CharHashFunction keyhash;
    private int size;
    private transient char[] data;
    private transient byte[] states;
    private static final byte EMPTY = 0;
    private static final byte OCCUPIED = 1;
    private static final byte REMOVED = 2;
    private transient int used;
    private int growthPolicy;
    private double growthFactor;
    private int growthChunk;
    private double loadFactor;
    private int expandAt;

    private CharOpenHashSet(CharHashFunction keyhash, int capacity, int growthPolicy, double growthFactor, int growthChunk, double loadFactor) {
        if (keyhash == null) {
            Exceptions.nullArgument("hash function");
        }
        if (capacity < 0) {
            Exceptions.negativeArgument("capacity", String.valueOf(capacity));
        }
        if (growthFactor <= 0.0) {
            Exceptions.negativeOrZeroArgument("growthFactor", String.valueOf(growthFactor));
        }
        if (growthChunk <= 0) {
            Exceptions.negativeOrZeroArgument("growthChunk", String.valueOf(growthChunk));
        }
        if (loadFactor <= 0.0) {
            Exceptions.negativeOrZeroArgument("loadFactor", String.valueOf(loadFactor));
        }
        this.keyhash = keyhash;
        capacity = Primes.nextPrime(capacity);
        this.data = new char[capacity];
        this.states = new byte[capacity];
        this.size = 0;
        this.expandAt = (int)Math.round(loadFactor * (double)capacity);
        this.used = 0;
        this.growthPolicy = growthPolicy;
        this.growthFactor = growthFactor;
        this.growthChunk = growthChunk;
        this.loadFactor = loadFactor;
    }

    private CharOpenHashSet(int capacity, int growthPolicy, double growthFactor, int growthChunk, double loadFactor) {
        this(DefaultCharHashFunction.INSTANCE, capacity, growthPolicy, growthFactor, growthChunk, loadFactor);
    }

    public CharOpenHashSet() {
        this(11);
    }

    public CharOpenHashSet(CharCollection c) {
        this();
        this.addAll(c);
    }

    public CharOpenHashSet(char[] a) {
        this();
        int i = 0;
        while (i < a.length) {
            this.add(a[i]);
            ++i;
        }
    }

    public CharOpenHashSet(int capacity) {
        this(capacity, 0, 1.0, 10, 0.75);
    }

    public CharOpenHashSet(double loadFactor) {
        this(11, 0, 1.0, 10, loadFactor);
    }

    public CharOpenHashSet(int capacity, double loadFactor) {
        this(capacity, 0, 1.0, 10, loadFactor);
    }

    public CharOpenHashSet(int capacity, double loadFactor, double growthFactor) {
        this(capacity, 0, growthFactor, 10, loadFactor);
    }

    public CharOpenHashSet(int capacity, double loadFactor, int growthChunk) {
        this(capacity, 1, 1.0, growthChunk, loadFactor);
    }

    public CharOpenHashSet(CharHashFunction keyhash) {
        this(keyhash, 11, 0, 1.0, 10, 0.75);
    }

    public CharOpenHashSet(CharHashFunction keyhash, int capacity) {
        this(keyhash, capacity, 0, 1.0, 10, 0.75);
    }

    public CharOpenHashSet(CharHashFunction keyhash, double loadFactor) {
        this(keyhash, 11, 0, 1.0, 10, loadFactor);
    }

    public CharOpenHashSet(CharHashFunction keyhash, int capacity, double loadFactor) {
        this(keyhash, capacity, 0, 1.0, 10, loadFactor);
    }

    public CharOpenHashSet(CharHashFunction keyhash, int capacity, double loadFactor, double growthFactor) {
        this(keyhash, capacity, 0, growthFactor, 10, loadFactor);
    }

    public CharOpenHashSet(CharHashFunction keyhash, int capacity, double loadFactor, int growthChunk) {
        this(keyhash, capacity, 1, 1.0, growthChunk, loadFactor);
    }

    private void ensureCapacity(int elements) {
        if (elements >= this.expandAt) {
            int newcapacity = this.growthPolicy == 0 ? (int)((double)this.data.length * (1.0 + this.growthFactor)) : this.data.length + this.growthChunk;
            if ((double)newcapacity * this.loadFactor < (double)elements) {
                newcapacity = (int)Math.round((double)elements / this.loadFactor);
            }
            newcapacity = Primes.nextPrime(newcapacity);
            this.expandAt = (int)Math.round(this.loadFactor * (double)newcapacity);
            char[] newdata = new char[newcapacity];
            byte[] newstates = new byte[newcapacity];
            this.used = 0;
            int i = 0;
            while (i < this.data.length) {
                if (this.states[i] == 1) {
                    ++this.used;
                    char v = this.data[i];
                    int h = Math.abs(this.keyhash.hash(v));
                    int n = h % newcapacity;
                    if (newstates[n] == 1) {
                        int c = 1 + h % (newcapacity - 2);
                        do {
                            if ((n -= c) >= 0) continue;
                            n += newcapacity;
                        } while (newstates[n] != 0);
                    }
                    newstates[n] = 1;
                    newdata[n] = v;
                }
                ++i;
            }
            this.data = newdata;
            this.states = newstates;
        }
    }

    public boolean add(char v) {
        int i;
        block5: {
            this.ensureCapacity(this.used + 1);
            int h = Math.abs(this.keyhash.hash(v));
            i = h % this.data.length;
            if (this.states[i] == 1) {
                if (this.data[i] == v) {
                    return false;
                }
                int c = 1 + h % (this.data.length - 2);
                do {
                    if ((i -= c) < 0) {
                        i += this.data.length;
                    }
                    if (this.states[i] == 0 || this.states[i] == 2) break block5;
                } while (this.states[i] != 1 || this.data[i] != v);
                return false;
            }
        }
        if (this.states[i] == 0) {
            ++this.used;
        }
        this.states[i] = 1;
        this.data[i] = v;
        ++this.size;
        return true;
    }

    public CharIterator iterator() {
        return new CharIterator(){
            int nextEntry = this.nextEntry(0);
            int lastEntry = -1;

            int nextEntry(int index) {
                while (index < CharOpenHashSet.this.data.length && CharOpenHashSet.this.states[index] != 1) {
                    ++index;
                }
                return index;
            }

            public boolean hasNext() {
                return this.nextEntry < CharOpenHashSet.this.data.length;
            }

            public char next() {
                if (!this.hasNext()) {
                    Exceptions.endOfIterator();
                }
                this.lastEntry = this.nextEntry;
                this.nextEntry = this.nextEntry(this.nextEntry + 1);
                return CharOpenHashSet.this.data[this.lastEntry];
            }

            public void remove() {
                if (this.lastEntry == -1) {
                    Exceptions.noElementToRemove();
                }
                ((CharOpenHashSet)CharOpenHashSet.this).states[this.lastEntry] = 2;
                CharOpenHashSet.this.size--;
                this.lastEntry = -1;
            }
        };
    }

    public void trimToSize() {
    }

    public Object clone() {
        try {
            CharOpenHashSet c = (CharOpenHashSet)super.clone();
            c.data = new char[this.data.length];
            System.arraycopy(this.data, 0, c.data, 0, this.data.length);
            c.states = new byte[this.data.length];
            System.arraycopy(this.states, 0, c.states, 0, this.states.length);
            return c;
        }
        catch (CloneNotSupportedException e) {
            Exceptions.cloning();
            throw new RuntimeException();
        }
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        this.size = 0;
        this.used = 0;
        Arrays.fill(this.states, (byte)0);
    }

    public boolean contains(char v) {
        int h = Math.abs(this.keyhash.hash(v));
        int i = h % this.data.length;
        if (this.states[i] != 0) {
            if (this.states[i] == 1 && this.data[i] == v) {
                return true;
            }
            int c = 1 + h % (this.data.length - 2);
            do {
                if ((i -= c) < 0) {
                    i += this.data.length;
                }
                if (this.states[i] != 0) continue;
                return false;
            } while (this.states[i] != 1 || this.data[i] != v);
            return true;
        }
        return false;
    }

    public int hashCode() {
        int h = 0;
        int i = 0;
        while (i < this.data.length) {
            if (this.states[i] == 1) {
                h += this.data[i];
            }
            ++i;
        }
        return h;
    }

    public boolean remove(char v) {
        int h = Math.abs(this.keyhash.hash(v));
        int i = h % this.data.length;
        if (this.states[i] != 0) {
            if (this.states[i] == 1 && this.data[i] == v) {
                this.states[i] = 2;
                --this.size;
                return true;
            }
            int c = 1 + h % (this.data.length - 2);
            do {
                if ((i -= c) < 0) {
                    i += this.data.length;
                }
                if (this.states[i] != 0) continue;
                return false;
            } while (this.states[i] != 1 || this.data[i] != v);
            this.states[i] = 2;
            --this.size;
            return true;
        }
        return false;
    }

    public char[] toArray(char[] a) {
        if (a == null || a.length < this.size) {
            a = new char[this.size];
        }
        int p = 0;
        int i = 0;
        while (i < this.data.length) {
            if (this.states[i] == 1) {
                a[p++] = this.data[i];
            }
            ++i;
        }
        return a;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.data.length);
        CharIterator i = this.iterator();
        while (i.hasNext()) {
            char x = i.next();
            s.writeChar(x);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.data = new char[s.readInt()];
        this.states = new byte[this.data.length];
        this.used = this.size;
        int n = 0;
        while (n < this.size) {
            char v = s.readChar();
            int h = Math.abs(this.keyhash.hash(v));
            int i = h % this.data.length;
            if (this.states[i] == 1) {
                int c = 1 + h % (this.data.length - 2);
                do {
                    if ((i -= c) >= 0) continue;
                    i += this.data.length;
                } while (this.states[i] != 0);
            }
            this.states[i] = 1;
            this.data[i] = v;
            ++n;
        }
    }
}

