/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.adapter.DoubleSetToSetAdapter;
import bak.pcj.hash.DefaultDoubleHashFunction;
import bak.pcj.map.DoubleKeyMap;
import bak.pcj.map.DoubleKeyMapIterator;
import bak.pcj.util.Exceptions;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DoubleKeyMapToMapAdapter
implements Map {
    protected DoubleKeyMap map;

    public DoubleKeyMapToMapAdapter(DoubleKeyMap map) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey((Double)key);
    }

    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    public Set entrySet() {
        return new EntrySet();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Map)) {
            return false;
        }
        Map m = (Map)obj;
        if (m.size() != this.map.size()) {
            return false;
        }
        Iterator i = m.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            if (e.getKey() == null) {
                return false;
            }
            if (e.getValue() == null) {
                return false;
            }
            if (this.get(e.getKey()).equals(e.getValue())) continue;
            return false;
        }
        return true;
    }

    public Object get(Object key) {
        double k = (Double)key;
        return this.map.get(k);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Set keySet() {
        return new DoubleSetToSetAdapter(this.map.keySet());
    }

    public Object put(Object key, Object value) {
        double k = (Double)key;
        return this.map.put(k, value);
    }

    public void putAll(Map map) {
        Iterator i = map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            this.put(e.getKey(), e.getValue());
        }
    }

    public Object remove(Object key) {
        if (key == null) {
            return null;
        }
        if (!(key instanceof Double)) {
            return null;
        }
        double k = (Double)key;
        return this.map.remove(k);
    }

    public int size() {
        return this.map.size();
    }

    public Collection values() {
        return this.map.values();
    }

    class Entry
    implements Map.Entry {
        Double key;
        Object value;

        Entry(double key, Object value) {
            this.key = new Double(key);
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            return DoubleKeyMapToMapAdapter.this.put(this.key, value);
        }

        public int hashCode() {
            return DefaultDoubleHashFunction.INSTANCE.hash(this.key) ^ this.value.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)obj;
            return this.key.equals(e.getKey()) && this.value.equals(e.getValue());
        }
    }

    class EntrySet
    extends AbstractSet {
        EntrySet() {
        }

        public Iterator iterator() {
            return new Iterator(this){
                DoubleKeyMapIterator i;
                private final /* synthetic */ EntrySet this$1;
                {
                    this.this$1 = this$1;
                    this.i = EntrySet.access$000((EntrySet)this.this$1).map.entries();
                }

                public boolean hasNext() {
                    return this.i.hasNext();
                }

                public Object next() {
                    this.i.next();
                    return EntrySet.access$000(this.this$1).new Entry(this.i.getKey(), this.i.getValue());
                }

                public void remove() {
                    this.i.remove();
                }
            };
        }

        public boolean add(Object obj) {
            Map.Entry e = (Map.Entry)obj;
            if (this.contains(e)) {
                return false;
            }
            DoubleKeyMapToMapAdapter.this.put(e.getKey(), e.getValue());
            return true;
        }

        public int size() {
            return DoubleKeyMapToMapAdapter.this.map.size();
        }

        static /* synthetic */ DoubleKeyMapToMapAdapter access$000(EntrySet x0) {
            return x0.DoubleKeyMapToMapAdapter.this;
        }
    }
}

