/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.adapter.BooleanListIteratorToListIteratorAdapter;
import bak.pcj.list.BooleanList;
import bak.pcj.util.Exceptions;
import java.util.AbstractList;
import java.util.Collection;
import java.util.ListIterator;

public class BooleanListToListAdapter
extends AbstractList {
    protected BooleanList list;

    public BooleanListToListAdapter(BooleanList list) {
        if (list == null) {
            Exceptions.nullArgument("list");
        }
        this.list = list;
    }

    public boolean addAll(int index, Collection c) {
        if (index > this.size() || index < 0) {
            Exceptions.indexOutOfBounds(index, 0, this.size());
        }
        return super.addAll(index, c);
    }

    public void add(int index, Object o) {
        if (o == null) {
            Exceptions.nullElementNotAllowed();
        }
        this.list.add(index, (Boolean)o);
    }

    public Object get(int index) {
        return new Boolean(this.list.get(index));
    }

    public ListIterator listIterator(int index) {
        return new BooleanListIteratorToListIteratorAdapter(this.list.listIterator(index));
    }

    public Object remove(int index) {
        return new Boolean(this.list.removeElementAt(index));
    }

    public boolean removeAll(Collection c) {
        if (c == null) {
            Exceptions.nullArgument("collection");
        }
        return super.removeAll(c);
    }

    public boolean retainAll(Collection c) {
        if (c == null) {
            Exceptions.nullArgument("collection");
        }
        return super.retainAll(c);
    }

    public Object set(int index, Object o) {
        if (o == null) {
            Exceptions.nullElementNotAllowed();
        }
        return new Boolean(this.list.set(index, (Boolean)o));
    }

    public int size() {
        return this.list.size();
    }
}

