/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.dbs.xml.transform;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.TransformerFactoryImpl;
import org.apache.log4j.Logger;
import org.fao.geonet.utils.CachedTransformer;

public class CachingTransformerFactory
extends TransformerFactoryImpl
implements CachedTransformer {
    protected static final Logger logger = Logger.getLogger(CachingTransformerFactory.class);
    static int activeReaders = 0;
    static int activeWriters = 0;
    private static Map<String, TemplatesCacheEntry> templatesCache = new HashMap<String, TemplatesCacheEntry>();

    public void clearCache() {
        this.beforeWrite();
        templatesCache.clear();
        this.afterWrite();
    }

    public Transformer newTransformer(Source source) throws TransformerConfigurationException {
        if (source instanceof StreamSource) {
            try {
                String srcId = source.getSystemId();
                URI uri = new URI(srcId);
                if ("file".equalsIgnoreCase(uri.getScheme())) {
                    return this.newTransformer(new File(uri.getPath()));
                }
            }
            catch (URISyntaxException urise) {
                throw new TransformerConfigurationException(urise);
            }
        }
        return super.newTransformer(source);
    }

    protected Transformer newTransformer(File file) throws TransformerConfigurationException {
        TemplatesCacheEntry templatesCacheEntry = this.read(file.getAbsolutePath());
        if (templatesCacheEntry != null && templatesCacheEntry.lastModified < templatesCacheEntry.templatesFile.lastModified()) {
            templatesCacheEntry = null;
        }
        if (templatesCacheEntry == null) {
            if (!file.exists()) {
                throw new TransformerConfigurationException("Requested transformation [" + file.getAbsolutePath() + "] does not exist.");
            }
            templatesCacheEntry = new TemplatesCacheEntry(this.newTemplates(new StreamSource(file)), file);
            this.write(file.getAbsolutePath(), templatesCacheEntry);
        }
        return templatesCacheEntry.templates.newTransformer();
    }

    protected TemplatesCacheEntry read(String absolutePath) {
        this.beforeRead();
        TemplatesCacheEntry templatesCacheEntry = templatesCache.get(absolutePath);
        this.afterRead();
        return templatesCacheEntry;
    }

    protected void write(String absolutePath, TemplatesCacheEntry templatesCacheEntry) {
        this.beforeWrite();
        templatesCache.put(absolutePath, templatesCacheEntry);
        this.afterWrite();
    }

    protected synchronized void beforeRead() {
        while (activeWriters > 0) {
            try {
                ((Object)((Object)this)).wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        ++activeReaders;
    }

    protected synchronized void afterRead() {
        --activeReaders;
        ((Object)((Object)this)).notifyAll();
    }

    protected synchronized void beforeWrite() {
        while (activeReaders > 0 || activeWriters > 0) {
            try {
                ((Object)((Object)this)).wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        ++activeWriters;
    }

    protected synchronized void afterWrite() {
        --activeWriters;
        ((Object)((Object)this)).notifyAll();
    }

    private static final class TemplatesCacheEntry {
        private long lastModified;
        private Templates templates;
        private File templatesFile;

        private TemplatesCacheEntry(Templates templates, File templatesFile) {
            this.templates = templates;
            this.templatesFile = templatesFile;
            this.lastModified = templatesFile.lastModified();
        }
    }
}

