/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import org.geotools.styling.ChannelSelection;
import org.geotools.styling.SelectedChannelType;
import org.geotools.styling.SelectedChannelTypeImpl;
import org.geotools.styling.StyleVisitor;
import org.geotools.util.Utilities;

public class ChannelSelectionImpl
implements ChannelSelection {
    private SelectedChannelType gray;
    private SelectedChannelType red;
    private SelectedChannelType blue;
    private SelectedChannelType green;

    @Override
    public SelectedChannelType getGrayChannel() {
        return this.gray;
    }

    @Override
    public SelectedChannelType[] getRGBChannels() {
        return new SelectedChannelType[]{this.red, this.green, this.blue};
    }

    @Override
    public SelectedChannelType[] getSelectedChannels() {
        SelectedChannelType[] ret = null;
        if (this.gray != null) {
            ret = new SelectedChannelType[]{this.gray};
        } else if (this.red != null || this.green != null || this.blue != null) {
            ret = new SelectedChannelType[]{this.red, this.green, this.blue};
        }
        return ret;
    }

    @Override
    public void setGrayChannel(SelectedChannelType gray) {
        this.gray = gray;
    }

    public void setGrayChannel(org.opengis.style.SelectedChannelType gray) {
        this.gray = new SelectedChannelTypeImpl(gray);
    }

    @Override
    public void setRGBChannels(SelectedChannelType[] channels) {
        if (channels.length != 3) {
            throw new IllegalArgumentException("Three channels are required in setRGBChannels, got " + channels.length);
        }
        this.red = channels[0];
        this.green = channels[1];
        this.blue = channels[2];
    }

    @Override
    public void setRGBChannels(SelectedChannelType red, SelectedChannelType green, SelectedChannelType blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public void setRGBChannels(org.opengis.style.SelectedChannelType red, org.opengis.style.SelectedChannelType green, org.opengis.style.SelectedChannelType blue) {
        this.red = new SelectedChannelTypeImpl(red);
        this.green = new SelectedChannelTypeImpl(green);
        this.blue = new SelectedChannelTypeImpl(blue);
    }

    @Override
    public void setSelectedChannels(SelectedChannelType[] channels) {
        if (channels.length == 1) {
            this.gray = channels[0];
        } else if (channels.length == 3) {
            this.red = channels[0];
            this.green = channels[1];
            this.blue = channels[2];
        } else {
            throw new IllegalArgumentException("Wrong number of elements in setSelectedChannels, expected 1 or 3, got " + channels.length);
        }
    }

    public Object accept(org.opengis.style.StyleVisitor visitor, Object data) {
        return visitor.visit((org.opengis.style.ChannelSelection)this, data);
    }

    @Override
    public void accept(StyleVisitor visitor) {
        visitor.visit(this);
    }

    public void accept(org.opengis.style.StyleVisitor visitor) {
        visitor.visit((org.opengis.style.ChannelSelection)this, null);
    }

    public int hashCode() {
        int PRIME = 1000003;
        int result = 0;
        if (this.gray != null) {
            result = 1000003 * result + this.gray.hashCode();
        }
        if (this.red != null) {
            result = 1000003 * result + this.red.hashCode();
        }
        if (this.blue != null) {
            result = 1000003 * result + this.blue.hashCode();
        }
        if (this.green != null) {
            result = 1000003 * result + this.green.hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ChannelSelectionImpl) {
            ChannelSelectionImpl other = (ChannelSelectionImpl)obj;
            return Utilities.equals((Object)this.gray, (Object)other.gray) && Utilities.equals((Object)this.red, (Object)other.red) && Utilities.equals((Object)this.blue, (Object)other.blue) && Utilities.equals((Object)this.green, (Object)other.green);
        }
        return false;
    }

    static ChannelSelectionImpl cast(org.opengis.style.ChannelSelection channel) {
        if (channel == null) {
            return null;
        }
        if (channel instanceof ChannelSelectionImpl) {
            return (ChannelSelectionImpl)channel;
        }
        ChannelSelectionImpl copy = new ChannelSelectionImpl();
        if (channel.getGrayChannel() != null) {
            copy.setGrayChannel(channel.getGrayChannel());
        } else {
            org.opengis.style.SelectedChannelType[] rgb = channel.getRGBChannels();
            copy.setRGBChannels(rgb[0], rgb[1], rgb[2]);
        }
        return copy;
    }
}

