/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.rendered.viewer;

import it.geosolutions.rendered.viewer.HTMLBuilder;
import it.geosolutions.rendered.viewer.HTMLRenderer;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HTMLRenderers {
    private static List<HTMLRenderer> renderers = new ArrayList<HTMLRenderer>();

    public static List<HTMLRenderer> getRenderers() {
        return renderers;
    }

    public static void addRendered(HTMLRenderer renderer) {
        renderers.add(renderer);
    }

    private HTMLRenderers() {
    }

    static {
        renderers.add(new ArrayRenderer());
    }

    private static class ArrayRenderer
    implements HTMLRenderer {
        private ArrayRenderer() {
        }

        public boolean canRender(Object o) {
            return o != null && o.getClass().isArray();
        }

        public String render(Object o) {
            int length = Array.getLength(o);
            StringBuffer sb = new StringBuffer();
            sb.append('[');
            for (int i = 0; i < length; ++i) {
                sb.append(HTMLBuilder.render(Array.get(o, i)));
                if (i < length - 1) {
                    sb.append(", ");
                    continue;
                }
                sb.append(']');
            }
            return sb.toString();
        }
    }
}

