/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.thesaurus;

import java.nio.file.Path;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.Util;
import org.fao.geonet.domain.Constants;
import org.fao.geonet.domain.ThesaurusActivation;
import org.fao.geonet.kernel.Thesaurus;
import org.fao.geonet.kernel.ThesaurusManager;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.languages.IsoLanguagesMapper;
import org.fao.geonet.repository.ThesaurusActivationRepository;
import org.fao.geonet.services.NotInReadOnlyModeService;
import org.jdom.Content;
import org.jdom.Element;

public class Add
extends NotInReadOnlyModeService {
    public void init(Path appPath, ServiceConfig params) throws Exception {
    }

    public Element serviceSpecificExec(Element params, ServiceContext context) throws Exception {
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        String fname = Util.getParam((Element)params, (String)"fname");
        String tname = Util.getParam((Element)params, (String)"tname");
        String tnamespace = Util.getParam((Element)params, (String)"tns");
        String dname = Util.getParam((Element)params, (String)"dname");
        String type = Util.getParam((Element)params, (String)"type");
        String activated = Util.getParam((Element)params, (String)"activated", (String)"y");
        if (!(fname = fname.trim().replaceAll("\\s+", "")).endsWith(".rdf")) {
            fname = fname + ".rdf";
        }
        ThesaurusManager tm = (ThesaurusManager)gc.getBean(ThesaurusManager.class);
        Path rdfFile = tm.buildThesaurusFilePath(fname, type, dname);
        String siteURL = ((SettingManager)context.getBean(SettingManager.class)).getSiteURL(context);
        IsoLanguagesMapper isoLanguageMapper = (IsoLanguagesMapper)context.getBean(IsoLanguagesMapper.class);
        Thesaurus thesaurus = new Thesaurus(isoLanguageMapper, fname, tname, tnamespace, type, dname, rdfFile, siteURL, false);
        tm.addThesaurus(thesaurus, true);
        ThesaurusActivation activation = new ThesaurusActivation();
        activation.setActivated(Constants.toBoolean_fromYNChar((char)activated.charAt(0)));
        activation.setId(fname);
        ((ThesaurusActivationRepository)context.getBean(ThesaurusActivationRepository.class)).save((Object)activation);
        Element elResp = new Element("response");
        Element elRef = new Element("ref");
        elRef.addContent(thesaurus.getKey());
        elResp.addContent((Content)elRef);
        Element elName = new Element("thesaName").setText(fname);
        elResp.addContent((Content)elName);
        return elResp;
    }
}

