/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.metadata;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import jeeves.server.ServiceConfig;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.Util;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.User;
import org.fao.geonet.exceptions.SchematronValidationErrorEx;
import org.fao.geonet.exceptions.XSDValidationErrorEx;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.MetadataIndexerProcessor;
import org.fao.geonet.kernel.mef.MEFLib;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.services.NotInReadOnlyModeService;
import org.fao.geonet.services.metadata.ImportConfig;
import org.fao.geonet.services.metadata.ImportInfo;
import org.fao.geonet.util.ThreadUtils;
import org.fao.geonet.utils.FilePathChecker;
import org.fao.geonet.utils.IO;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Element;

public class ImportFromDir
extends NotInReadOnlyModeService {
    private static final String CONFIG_FILE = "import-config.xml";
    private Path stylePath;
    private Map<String, Exception> exceptions = new HashMap<String, Exception>();
    private boolean failOnError;

    public void init(Path appPath, ServiceConfig params) throws Exception {
        this.stylePath = appPath.resolve("xsl/conversion/import");
    }

    public Element serviceSpecificExec(Element params, ServiceContext context) throws Exception {
        String dir = Util.getParam((Element)params, (String)"dir");
        this.failOnError = Util.getParam((Element)params, (String)"failOnError", (String)"off").equals("on");
        Path file = IO.toPath((String)dir, (String[])new String[0]).resolve(CONFIG_FILE);
        long start = System.currentTimeMillis();
        int result = Files.exists(file, new LinkOption[0]) ? this.configImport(params, context, file) : this.standardImport(params, context);
        long end = System.currentTimeMillis();
        long duration = (end - start) / 1000L;
        context.info("Import time is :" + duration + " secs");
        Element response = new Element("response").addContent((Content)new Element("records").setText("" + result)).addContent((Content)new Element("time").setText("" + duration));
        if (this.exceptions.size() > 0) {
            Element ex = new Element("exceptions").setAttribute("count", "" + this.exceptions.size());
            for (Map.Entry<String, Exception> e : this.exceptions.entrySet()) {
                Element exceptionInfo = new Element("exception");
                exceptionInfo.setAttribute("file", e.getKey());
                if (e.getValue() instanceof SchematronValidationErrorEx) {
                    exceptionInfo.addContent((Content)((Element)((SchematronValidationErrorEx)e.getValue()).getObject()));
                } else if (e instanceof XSDValidationErrorEx) {
                    exceptionInfo.addContent((Content)((Element)((XSDValidationErrorEx)((Object)e.getValue())).getObject()));
                } else {
                    exceptionInfo.setText(e.getValue().getMessage());
                }
                ex.addContent((Content)exceptionInfo);
            }
            response.addContent((Content)ex);
        }
        return response;
    }

    private int standardImport(Element params, ServiceContext context) throws Exception {
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        DataManager dm = (DataManager)gc.getBean(DataManager.class);
        String dir = Util.getParam((Element)params, (String)"dir");
        boolean recurse = Util.getParam((Element)params, (String)"recurse", (String)"off").equals("on");
        final ArrayList files = Lists.newArrayList();
        final MEFLib.MefOrXmlFileFilter predicate = new MEFLib.MefOrXmlFileFilter();
        if (recurse) {
            Files.walkFileTree(IO.toPath((String)dir, (String[])new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (predicate.accept(file)) {
                        files.add(file);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        } else {
            try (DirectoryStream<Path> paths = Files.newDirectoryStream(IO.toPath((String)dir, (String[])new String[0]), (DirectoryStream.Filter<? super Path>)predicate);){
                for (Path file : paths) {
                    files.add(file);
                }
            }
        }
        if (files.size() == 0) {
            throw new Exception("No XML or MEF file found in " + dir);
        }
        ImportMetadataReindexer r = new ImportMetadataReindexer(dm, params, context, files, this.stylePath, this.failOnError);
        r.process();
        this.exceptions = r.getExceptions();
        return files.size();
    }

    private int configImport(Element params, ServiceContext context, Path configFile) throws Exception {
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        DataManager dm = (DataManager)gc.getBean(DataManager.class);
        ImportConfig config = new ImportConfig(configFile, context);
        String dir = Util.getParam((Element)params, (String)"dir");
        String group = Util.getParam((Element)params, (String)"group");
        String style = Util.getParam((Element)params, (String)"styleSheet");
        boolean validate = Util.getParam((Element)params, (String)"validate", (String)"off").equals("on");
        int counter = 0;
        ArrayList<ImportInfo> alImport = new ArrayList<ImportInfo>();
        try (DirectoryStream<Path> sites = Files.newDirectoryStream(IO.toPath((String)dir, (String[])new String[0]));){
            for (Path site : sites) {
                if (context.isDebugEnabled()) {
                    context.debug("Scanning site : " + site);
                }
                DirectoryStream<Path> categs = Files.newDirectoryStream(site);
                Throwable throwable = null;
                try {
                    for (Path categ : categs) {
                        if (context.isDebugEnabled()) {
                            context.debug("   Scanning category : " + categ);
                        }
                        DirectoryStream<Path> paths = Files.newDirectoryStream(categ, (DirectoryStream.Filter<? super Path>)new MEFLib.MefOrXmlFileFilter());
                        Throwable throwable2 = null;
                        try {
                            for (Path file : paths) {
                                Element xml = Xml.loadFile((Path)file);
                                if (!style.equals("_none_")) {
                                    FilePathChecker.verify((String)style);
                                    xml = Xml.transform((Element)xml, (Path)this.stylePath.resolve(style));
                                }
                                String category = config.mapCategory(categ.toString());
                                String schema = config.mapSchema(categ.toString());
                                if (validate) {
                                    dm.validate(schema, xml);
                                }
                                alImport.add(new ImportInfo(schema, category, xml));
                                ++counter;
                            }
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (paths == null) continue;
                            if (throwable2 != null) {
                                try {
                                    paths.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            paths.close();
                        }
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (categs == null) continue;
                    if (throwable != null) {
                        try {
                            categs.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    categs.close();
                }
            }
        }
        for (ImportInfo ii : alImport) {
            this.insert(ii.schema, ii.xml, group, context, ii.category);
        }
        return counter;
    }

    private void insert(String schema, Element xml, String group, ServiceContext context, String category) throws Exception {
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        DataManager dm = (DataManager)gc.getBean(DataManager.class);
        String uuid = dm.extractUUID(schema, xml);
        if (uuid.length() == 0) {
            uuid = UUID.randomUUID().toString();
        }
        if (category.equals("_none_")) {
            category = null;
        }
        String docType = null;
        Object title = null;
        String createDate = null;
        String changeDate = null;
        boolean ufo = true;
        boolean indexImmediate = true;
        String isTemplate = "n";
        dm.insertMetadata(context, schema, xml, uuid, context.getUserSession().getUserIdAsInt(), group, ((SettingManager)gc.getBean(SettingManager.class)).getSiteId(), isTemplate, docType, category, createDate, changeDate, ufo, indexImmediate);
    }

    public class ImportMetadataReindexer
    extends MetadataIndexerProcessor {
        Element params;
        List<Path> files;
        Path stylePath;
        ServiceContext context;
        HashMap<String, Exception> exceptions;

        public ImportMetadataReindexer(DataManager dm, Element params, ServiceContext context, List<Path> fileList, Path stylePath, boolean failOnError) {
            super(dm);
            this.exceptions = new HashMap();
            this.params = params;
            this.context = context;
            this.files = fileList;
            this.stylePath = stylePath;
        }

        public void process() throws Exception {
            int n;
            int threadCount = ThreadUtils.getNumberOfThreads();
            ExecutorService executor = Executors.newFixedThreadPool(threadCount);
            int perThread = this.files.size() < threadCount ? this.files.size() : this.files.size() / threadCount;
            ArrayList<Future<HashMap<String, Exception>>> submitList = new ArrayList<Future<HashMap<String, Exception>>>();
            for (int index = 0; index < this.files.size(); index += n) {
                int start = index;
                n = Math.min(perThread, this.files.size() - start);
                ImportCallable worker = new ImportCallable(this.files, start, n, this.params, this.context, this.stylePath, ImportFromDir.this.failOnError);
                Future<HashMap<String, Exception>> submit = executor.submit(worker);
                submitList.add(submit);
            }
            for (Future future : submitList) {
                try {
                    this.exceptions.putAll((Map)future.get());
                }
                catch (InterruptedException e) {
                    Log.error((String)"geonetwork", (Object)("ImportMetadataReindexer error: " + e.getMessage()), (Throwable)e);
                }
                catch (ExecutionException e) {
                    Log.error((String)"geonetwork", (Object)("ImportMetadataReindexer error: " + e.getMessage()), (Throwable)e);
                }
            }
            executor.shutdown();
        }

        public Map<String, Exception> getExceptions() {
            return this.exceptions;
        }
    }

    public static final class ImportCallable
    implements Callable<HashMap<String, Exception>> {
        private final List<Path> files;
        private final int beginIndex;
        private final int count;
        private final Element params;
        private final Path stylePath;
        private final boolean failOnError;
        private final ServiceContext context;
        private final int userId;
        private final String userName;
        private final Profile userProfile;

        ImportCallable(List<Path> files, int beginIndex, int count, Element params, ServiceContext context, Path stylePath, boolean failOnError) {
            this.files = files;
            this.beginIndex = beginIndex;
            this.count = count;
            this.params = params;
            this.context = context;
            this.stylePath = stylePath;
            this.failOnError = failOnError;
            this.userId = Integer.valueOf(this.context.getUserSession().getUserId());
            this.userName = this.context.getUserSession().getUsername();
            this.userProfile = this.context.getUserSession().getProfile();
        }

        private void login() {
            UserSession session = new UserSession();
            session.loginAs(new User().setUsername(this.userName).setId(this.userId).setProfile(this.userProfile));
            this.context.setUserSession(session);
        }

        @Override
        public HashMap<String, Exception> call() throws Exception {
            HashMap<String, Exception> exceptions = new HashMap<String, Exception>();
            this.login();
            for (Path file : this.files) {
                try {
                    MEFLib.doImport((Element)this.params, (ServiceContext)this.context, (Path)file, (Path)this.stylePath);
                }
                catch (Exception e) {
                    if (this.failOnError) {
                        throw e;
                    }
                    exceptions.put(file.toString(), e);
                }
            }
            return exceptions;
        }
    }
}

