/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.group;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.UUID;
import javax.imageio.ImageIO;
import jeeves.server.ServiceConfig;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import org.apache.commons.io.FilenameUtils;
import org.fao.geonet.Util;
import org.fao.geonet.domain.Group;
import org.fao.geonet.domain.Language;
import org.fao.geonet.domain.MetadataCategory;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.UserGroup;
import org.fao.geonet.repository.GroupRepository;
import org.fao.geonet.repository.LanguageRepository;
import org.fao.geonet.repository.MetadataCategoryRepository;
import org.fao.geonet.repository.Updater;
import org.fao.geonet.repository.UserGroupRepository;
import org.fao.geonet.repository.specification.GroupSpecs;
import org.fao.geonet.resources.Resources;
import org.fao.geonet.services.NotInReadOnlyModeService;
import org.fao.geonet.utils.FilePathChecker;
import org.fao.geonet.utils.IO;
import org.jdom.Content;
import org.jdom.Element;

@Deprecated
public class Update
extends NotInReadOnlyModeService {
    public void init(Path appPath, ServiceConfig params) throws Exception {
    }

    public Element serviceSpecificExec(Element params, ServiceContext context) throws Exception {
        UserSession session;
        String id = params.getChildText("id");
        final String name = Util.getParam((Element)params, (String)"name");
        final String description = Util.getParam((Element)params, (String)"description", (String)"");
        final boolean deleteLogo = Util.getParam((Element)params, (String)"deleteLogo", (boolean)false);
        String copyLogo = Util.getParam((Element)params, (String)"copyLogo", null);
        final String email = params.getChildText("email");
        String category = Util.getParam((Element)params, (String)"category", (String)"-1");
        final List allowedCategories = Util.getParamsAsInt((Element)params, (String)"allowedCategories");
        final Boolean enableAllowedCategories = Util.getParam((Element)params, (String)"enableAllowedCategories", (boolean)false);
        String website = params.getChildText("website");
        if (website != null && website.length() > 0 && !website.startsWith("http://")) {
            website = "http://" + website;
        }
        if (!(session = context.getUserSession()).getProfile().equals((Object)Profile.Administrator)) {
            List usergroups = ((UserGroupRepository)context.getBean(UserGroupRepository.class)).findAll(GroupSpecs.isEditorOrMore((Integer)session.getUserIdAsInt()));
            boolean canEditGroup = false;
            if (id != null && !"".equals(id)) {
                Integer i = Integer.valueOf(id);
                for (UserGroup ug : usergroups) {
                    if (ug.getGroup().getId() != i.intValue()) continue;
                    canEditGroup = ug.getProfile().equals((Object)Profile.UserAdmin);
                }
            }
            if (!canEditGroup) {
                throw new SecurityException("You cannot edit this group");
            }
        }
        String logoFile = params.getChildText("logofile");
        FilePathChecker.verify((String)logoFile);
        FilePathChecker.verify((String)copyLogo);
        final String logoUUID = copyLogo == null ? this.copyLogoFromRequest(context, logoFile) : this.copyLogoFromHarvesters(context, copyLogo);
        GroupRepository groupRepository = (GroupRepository)context.getBean(GroupRepository.class);
        final MetadataCategoryRepository catRepository = (MetadataCategoryRepository)context.getBean(MetadataCategoryRepository.class);
        MetadataCategory tmpcat = null;
        try {
            tmpcat = (MetadataCategory)catRepository.findOne((Serializable)Integer.valueOf(category));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        final MetadataCategory cat = tmpcat;
        Element elRes = new Element("response");
        if (id == null || "".equals(id)) {
            Group group = new Group().setName(name).setDescription(description).setEmail(email).setLogo(logoUUID).setWebsite(website).setDefaultCategory(cat).setEnableAllowedCategories(enableAllowedCategories);
            this.setUpAllowedCategories(allowedCategories, enableAllowedCategories, catRepository, group);
            LanguageRepository langRepository = (LanguageRepository)context.getBean(LanguageRepository.class);
            List allLanguages = langRepository.findAll();
            for (Language l : allLanguages) {
                group.getLabelTranslations().put(l.getId(), name);
            }
            groupRepository.save((Object)group);
            elRes.addContent((Content)new Element("operation").setText("added"));
        } else {
            final String finalWebsite = website;
            groupRepository.update((Serializable)Integer.valueOf(id), (Updater)new Updater<Group>(){

                public void apply(Group entity) {
                    entity.setEmail(email).setName(name).setDescription(description).setWebsite(finalWebsite).setDefaultCategory(cat).setEnableAllowedCategories(enableAllowedCategories);
                    Update.this.setUpAllowedCategories(allowedCategories, enableAllowedCategories, catRepository, entity);
                    if (!deleteLogo && logoUUID != null) {
                        entity.setLogo(logoUUID);
                    }
                    if (deleteLogo) {
                        entity.setLogo(null);
                    }
                }
            });
            elRes.addContent((Content)new Element("operation").setText("updated"));
        }
        return elRes;
    }

    private void setUpAllowedCategories(List<Integer> allowedCategories, Boolean enableAllowedCategories, MetadataCategoryRepository catRepository, Group group) {
        if (enableAllowedCategories.booleanValue()) {
            if (group.getAllowedCategories() != null) {
                group.getAllowedCategories().clear();
            }
            for (Integer i : allowedCategories) {
                try {
                    MetadataCategory c = (MetadataCategory)catRepository.findOne((Serializable)i);
                    group.getAllowedCategories().add(c);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private String copyLogoFromRequest(ServiceContext context, String logoFile) throws IOException {
        String logoUUID = null;
        if (logoFile != null && logoFile.length() > 0) {
            logoFile = this.stripPath(logoFile);
            Path input = context.getUploadDir().resolve(logoFile);
            try (InputStream in = IO.newInputStream((Path)input);){
                ImageIO.read(in);
            }
            Resources resources = (Resources)context.getBean(Resources.class);
            Path logoDir = resources.locateLogosDir(context);
            logoUUID = UUID.randomUUID().toString();
            try (Resources.ResourceHolder outputResource = resources.getWritableImage(context, logoUUID + ".png", logoDir);){
                Files.copy(input, outputResource.getPath(), new CopyOption[0]);
            }
        }
        return logoUUID;
    }

    private String copyLogoFromHarvesters(ServiceContext context, String logoFile) throws IOException {
        String logoUUID;
        block38: {
            logoUUID = UUID.randomUUID().toString();
            Resources resources = (Resources)context.getBean(Resources.class);
            Path harvesterDir = resources.locateHarvesterLogosDir(context);
            try (Resources.ResourceHolder harvestLogo = resources.getImage(context, logoFile, harvesterDir);){
                if (harvestLogo != null) {
                    try (InputStream in = IO.newInputStream((Path)harvestLogo.getPath());){
                        ImageIO.read(in);
                    }
                    String extension = FilenameUtils.getExtension((String)harvestLogo.getRelativePath());
                    try (Resources.ResourceHolder outputResource = resources.getWritableImage(context, logoUUID + "." + extension, resources.locateLogosDir(context));){
                        Files.copy(harvestLogo.getPath(), outputResource.getPath(), new CopyOption[0]);
                        break block38;
                    }
                }
                throw new IOException("Cannot find " + logoFile + " in " + harvesterDir);
            }
        }
        return logoUUID;
    }

    private String stripPath(String file) {
        if (file.indexOf(92) > 0) {
            String[] pathTokens = file.split("\\\\");
            file = pathTokens[pathTokens.length - 1];
        }
        return file;
    }
}

