/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.crs;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Set;
import jeeves.interfaces.Service;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.Util;
import org.fao.geonet.services.crs.Constant;
import org.fao.geonet.services.crs.GetCRS;
import org.fao.geonet.utils.Log;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.jdom.Content;
import org.jdom.Element;
import org.opengis.metadata.Identifier;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Deprecated
public class Search
implements Service {
    public void init(Path appPath, ServiceConfig params) throws Exception {
    }

    public Element exec(Element params, ServiceContext context) throws Exception {
        int maxResults = Integer.valueOf(Util.getParam((Element)params, (String)"maxResults", (String)"50"));
        String searchText = Util.getParam((Element)params, (String)"name", (String)"");
        String[] filter = searchText.toUpperCase().split(" ");
        String crsType = Util.getParam((Element)params, (String)"type", (String)"");
        Class<CoordinateReferenceSystem> crsTypeClass = CoordinateReferenceSystem.class;
        if (Constant.CRSType.containsKey(crsType)) {
            crsTypeClass = Constant.CRSType.get(crsType);
        }
        Element crs = this.filterCRS(filter, crsTypeClass, maxResults);
        return crs;
    }

    private Element filterCRS(String[] filter, Class<? extends IdentifiedObject> crsTypeClass, int maxResults) {
        Element crsList = new Element("crsList");
        int i = 0;
        for (Object object : ReferencingFactoryFinder.getCRSAuthorityFactories(null)) {
            CRSAuthorityFactory factory = (CRSAuthorityFactory)object;
            String authorityTitle = factory.getAuthority().getTitle() == null ? "" : factory.getAuthority().getTitle().toString();
            String authorityEdition = factory.getAuthority().getEdition() == null ? "" : factory.getAuthority().getEdition().toString();
            String authorityCodeSpace = "";
            Collection ids = factory.getAuthority().getIdentifiers();
            for (Identifier id : ids) {
                authorityCodeSpace = id.getCode();
            }
            try {
                Set codes = factory.getAuthorityCodes(crsTypeClass);
                for (Object codeObj : codes) {
                    String description;
                    String code = (String)codeObj;
                    try {
                        description = factory.getDescriptionText(code).toString();
                    }
                    catch (Exception e1) {
                        description = "-";
                    }
                    if (!this.matchesFilter((description = description + " (" + authorityCodeSpace + ":" + code + ")").toUpperCase(), filter)) continue;
                    Element crs = GetCRS.formatCRS(authorityTitle, authorityEdition, authorityCodeSpace, code, description);
                    crsList.addContent((Content)crs);
                    if (++i < maxResults) continue;
                    return crsList;
                }
            }
            catch (FactoryException e) {
                Log.error((String)"geonetwork", (Object)("CRS Authority:" + e.getMessage()), (Throwable)e);
            }
        }
        return crsList;
    }

    protected boolean matchesFilter(String input, String[] filter) {
        for (String match : filter) {
            if (input.contains(match)) continue;
            return false;
        }
        return true;
    }
}

