/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.users;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import javax.persistence.metamodel.SingularAttribute;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.bind.DatatypeConverter;
import jeeves.server.UserSession;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.users.GroupElem;
import org.fao.geonet.api.users.model.UserDto;
import org.fao.geonet.domain.Address;
import org.fao.geonet.domain.Group;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.User;
import org.fao.geonet.domain.UserGroup;
import org.fao.geonet.domain.UserGroupId;
import org.fao.geonet.domain.UserGroupId_;
import org.fao.geonet.domain.UserSecurityNotification;
import org.fao.geonet.domain.User_;
import org.fao.geonet.exceptions.UserNotFoundEx;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.repository.GroupRepository;
import org.fao.geonet.repository.SortUtils;
import org.fao.geonet.repository.UserGroupRepository;
import org.fao.geonet.repository.UserRepository;
import org.fao.geonet.repository.UserSavedSelectionRepository;
import org.fao.geonet.repository.specification.MetadataSpecs;
import org.fao.geonet.repository.specification.UserGroupSpecs;
import org.fao.geonet.repository.specification.UserSpecs;
import org.fao.geonet.util.PasswordUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.domain.Specifications;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import springfox.documentation.annotations.ApiIgnore;

@RequestMapping(value={"/{portal}/api/users", "/{portal}/api/0.1/users"})
@Api(value="users", tags={"users"}, description="User operations")
@Controller(value="users")
public class UsersApi {
    @Autowired
    SettingManager settingManager;
    @Autowired
    UserRepository userRepository;
    @Autowired
    GroupRepository groupRepository;
    @Autowired
    UserGroupRepository userGroupRepository;
    @Autowired
    UserSavedSelectionRepository userSavedSelectionRepository;
    @Autowired
    DataManager dataManager;
    private BufferedImage pixel = new BufferedImage(1, 1, 2);

    public UsersApi() {
        this.pixel.setRGB(0, 0, 255);
    }

    @ApiOperation(value="Get users", notes="", nickname="getUsers")
    @RequestMapping(produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="isAuthenticated()")
    @ResponseBody
    public List<User> getUsers(@ApiIgnore HttpSession httpSession) throws Exception {
        UserSession session = ApiUtils.getUserSession(httpSession);
        Profile profile = session.getProfile();
        if (profile == Profile.Administrator) {
            return this.userRepository.findAll(SortUtils.createSort((SingularAttribute[])new SingularAttribute[]{User_.name}));
        }
        if (profile != Profile.UserAdmin) {
            return this.userRepository.findAll(UserSpecs.hasUserId((int)session.getUserIdAsInt()));
        }
        if (profile == Profile.UserAdmin) {
            int userId = session.getUserIdAsInt();
            List<Integer> userGroupIds = this.getGroupIdsWhereUserIsUserAdmin(userId);
            List allUsers = this.userRepository.findAll(SortUtils.createSort((SingularAttribute[])new SingularAttribute[]{User_.name}));
            allUsers.removeIf(u -> userGroupIds.stream().noneMatch(this.getGroupIds(u.getId())::contains) || u.getProfile().equals((Object)Profile.Administrator));
            return allUsers;
        }
        return null;
    }

    @ApiOperation(value="Get user", notes="", nickname="getUser")
    @RequestMapping(value={"/{userIdentifier}"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="isAuthenticated()")
    @ResponseBody
    public User getUser(@ApiParam(value="User identifier.") @PathVariable Integer userIdentifier, @ApiIgnore HttpSession httpSession) throws Exception {
        UserSession session = ApiUtils.getUserSession(httpSession);
        Profile myProfile = session.getProfile();
        String myUserId = session.getUserId();
        if (myProfile.equals((Object)Profile.Administrator) || myProfile.equals((Object)Profile.UserAdmin) || myUserId.equals(Integer.toString(userIdentifier))) {
            List adminlist;
            User user = (User)this.userRepository.findOne((Serializable)userIdentifier);
            if (user == null) {
                throw new UserNotFoundEx(Integer.toString(userIdentifier));
            }
            if (!myUserId.equals(Integer.toString(userIdentifier)) && myProfile == Profile.UserAdmin && (adminlist = this.userGroupRepository.findGroupIds((Specification)Specifications.where((Specification)UserGroupSpecs.hasUserId((int)Integer.parseInt(myUserId))).or(UserGroupSpecs.hasUserId((int)userIdentifier)))).isEmpty()) {
                throw new IllegalArgumentException("You don't have rights to do this because the user you want to edit is not part of your group");
            }
            return user;
        }
        throw new IllegalArgumentException("You don't have rights to do this");
    }

    @ApiOperation(value="Get user identicon", notes="", nickname="getUserIdentIcon")
    @RequestMapping(value={"/{userIdentifier}.png"}, produces={"image/png"}, method={RequestMethod.GET})
    @ResponseBody
    public void getUser(@ApiParam(value="User identifier.") @PathVariable Integer userIdentifier, @ApiParam(value="Size.") @RequestParam(defaultValue="18") Integer size, @ApiIgnore HttpServletResponse response) throws IOException {
        String identiconType = this.settingManager.getValue("system/users/identicon");
        if (identiconType != null && identiconType.startsWith("gravatar")) {
            try {
                User user = (User)this.userRepository.findOne((Serializable)userIdentifier);
                if (user == null) {
                    throw new UserNotFoundEx(Integer.toString(userIdentifier));
                }
                String[] config = identiconType.split(":");
                String dParameter = config.length > 1 ? config[1] : null;
                String fParameter = config.length == 3 ? config[2] : null;
                String email = user.getEmail() != null ? user.getEmail() : "";
                MessageDigest md = MessageDigest.getInstance("MD5");
                byte[] hash = md.digest(email.getBytes());
                URL url = new URL("https://gravatar.com/avatar/" + DatatypeConverter.printHexBinary((byte[])hash).toLowerCase() + "?s=" + size + (dParameter == null ? "" : "&d=" + dParameter) + (fParameter == null ? "" : "&f=" + fParameter));
                BufferedImage image = ImageIO.read(url);
                response.setStatus(HttpStatus.OK.value());
                ImageIO.write((RenderedImage)image, "PNG", (OutputStream)response.getOutputStream());
            }
            catch (NoSuchAlgorithmException e) {
                ImageIO.write((RenderedImage)this.pixel, "PNG", (OutputStream)response.getOutputStream());
            }
        } else {
            ImageIO.write((RenderedImage)this.pixel, "PNG", (OutputStream)response.getOutputStream());
        }
    }

    @ApiOperation(value="Delete a user", notes="Deletes a catalog user by identifier.", nickname="deleteUser")
    @RequestMapping(value={"/{userIdentifier}"}, produces={"application/json"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasRole('UserAdmin') or hasRole('Administrator')")
    @ResponseBody
    public ResponseEntity<String> deleteUser(@ApiParam(value="User identifier.") @PathVariable Integer userIdentifier, @ApiIgnore ServletRequest request, @ApiIgnore HttpSession httpSession) throws Exception {
        List groupIdsUserToDelete;
        Integer iMyUserId;
        List groupIdsSessionUser;
        UserSession session = ApiUtils.getUserSession(httpSession);
        Profile myProfile = session.getProfile();
        String myUserId = session.getUserId();
        if (myUserId == null || myUserId.equals(Integer.toString(userIdentifier))) {
            throw new IllegalArgumentException("You cannot delete yourself from the user database");
        }
        if (myProfile == Profile.UserAdmin && CollectionUtils.intersection((Collection)(groupIdsSessionUser = this.userGroupRepository.findGroupIds((Specification)Specifications.where((Specification)UserGroupSpecs.hasUserId((int)(iMyUserId = Integer.valueOf(Integer.parseInt(myUserId))))))), (Collection)(groupIdsUserToDelete = this.userGroupRepository.findGroupIds((Specification)Specifications.where((Specification)UserGroupSpecs.hasUserId((int)userIdentifier))))).isEmpty()) {
            throw new IllegalArgumentException("You don't have rights to delete this user because the user is not part of your group");
        }
        if (this.dataManager.isUserMetadataOwner(userIdentifier.intValue())) {
            IMetadataUtils metadataRepository = (IMetadataUtils)ApplicationContextHolder.get().getBean(IMetadataUtils.class);
            long numUserRecords = metadataRepository.count(MetadataSpecs.isOwnedByUser((int)userIdentifier));
            throw new IllegalArgumentException(String.format("Cannot delete a user that is also metadata owner of %d record(s) (can be records, templates, subtemplates). Change owner of those records or remove them first.", numUserRecords));
        }
        if (this.dataManager.isUserMetadataStatus(userIdentifier.intValue())) {
            throw new IllegalArgumentException("Cannot delete a user that has set a metadata status");
        }
        this.userGroupRepository.deleteAllByIdAttribute(UserGroupId_.userId, Arrays.asList(userIdentifier));
        this.userSavedSelectionRepository.deleteAllByUser(userIdentifier);
        try {
            this.userRepository.delete((Serializable)userIdentifier);
        }
        catch (EmptyResultDataAccessException ex) {
            throw new UserNotFoundEx(Integer.toString(userIdentifier));
        }
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @ApiOperation(value="Check if a user property already exist", notes="", authorizations={@Authorization(value="basicAuth")}, nickname="checkUserPropertyExist")
    @RequestMapping(value={"/properties/{property}"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasRole('UserAdmin')")
    @ApiResponses(value={@ApiResponse(code=200, message="Property does not exist."), @ApiResponse(code=404, message="A property with that value already exist."), @ApiResponse(code=403, message="Operation not allowed. Only UserAdmins can access it.")})
    public ResponseEntity<HttpStatus> checkUserPropertyExist(@ApiParam(value="The user property to check") @PathVariable String property, @ApiParam(value="The value to search") @RequestParam String exist) {
        if ("userid".equals(property)) {
            if (this.userRepository.count((Specification)Specifications.where((Specification)UserSpecs.hasUserName((String)exist))) > 0L) {
                return new ResponseEntity(HttpStatus.OK);
            }
        } else if ("email".equals(property)) {
            if (this.userRepository.count((Specification)Specifications.where((Specification)UserSpecs.hasEmail((String)exist))) > 0L) {
                return new ResponseEntity(HttpStatus.OK);
            }
        } else {
            throw new IllegalArgumentException(String.format("Property '%s' is not supported. You can only check username and email", new Object[0]));
        }
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    @ApiOperation(value="Creates a user", notes="Creates a catalog user.", nickname="createUser")
    @RequestMapping(produces={"application/json"}, method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasRole('UserAdmin') or hasRole('Administrator')")
    @ResponseBody
    public ResponseEntity<String> createUser(@ApiParam(name="user") @RequestBody UserDto userDto, @ApiIgnore ServletRequest request, @ApiIgnore HttpSession httpSession) throws Exception {
        Profile profile = Profile.findProfileIgnoreCase((String)userDto.getProfile());
        UserSession session = ApiUtils.getUserSession(httpSession);
        Profile myProfile = session.getProfile();
        if (profile == Profile.Administrator) {
            this.checkIfAtLeastOneAdminIsEnabled(userDto, this.userRepository);
        }
        if (!myProfile.getAll().contains(profile)) {
            throw new IllegalArgumentException("Trying to set profile to " + profile + " max profile permitted is: " + myProfile);
        }
        if (StringUtils.isEmpty((String)userDto.getUsername())) {
            throw new IllegalArgumentException("username is a required parameter for newuser operation");
        }
        List existingUsers = this.userRepository.findByUsernameIgnoreCase(userDto.getUsername());
        if (!existingUsers.isEmpty()) {
            throw new IllegalArgumentException("Users with username " + userDto.getUsername() + " ignore case already exists");
        }
        LinkedList<GroupElem> groups = new LinkedList<GroupElem>();
        groups.addAll(this.processGroups(userDto.getGroupsRegisteredUser(), Profile.RegisteredUser));
        groups.addAll(this.processGroups(userDto.getGroupsEditor(), Profile.Editor));
        groups.addAll(this.processGroups(userDto.getGroupsReviewer(), Profile.Reviewer));
        groups.addAll(this.processGroups(userDto.getGroupsUserAdmin(), Profile.UserAdmin));
        User user = new User();
        user.getSecurity().setPassword(PasswordUtil.encoder((ApplicationContext)ApplicationContextHolder.get()).encode((CharSequence)userDto.getPassword()));
        this.fillUserFromParams(user, userDto);
        user = (User)this.userRepository.save((Object)user);
        this.setUserGroups(user, groups);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @ApiOperation(value="Update a user", notes="Updates a catalog user.", nickname="updateUser")
    @RequestMapping(value={"/{userIdentifier}"}, produces={"application/json"}, method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="isAuthenticated()")
    @ResponseBody
    public ResponseEntity<String> updateUser(@ApiParam(value="User identifier.") @PathVariable Integer userIdentifier, @ApiParam(name="user") @RequestBody UserDto userDto, @ApiIgnore ServletRequest request, @ApiIgnore HttpSession httpSession) throws Exception {
        User user;
        Profile profile = Profile.findProfileIgnoreCase((String)userDto.getProfile());
        UserSession session = ApiUtils.getUserSession(httpSession);
        Profile myProfile = session.getProfile();
        String myUserId = session.getUserId();
        if (myProfile != Profile.Administrator && myProfile != Profile.UserAdmin && !myUserId.equals(Integer.toString(userIdentifier))) {
            throw new IllegalArgumentException("You don't have rights to do this");
        }
        if (profile == Profile.Administrator) {
            this.checkIfAtLeastOneAdminIsEnabled(userDto, this.userRepository);
        }
        if ((user = (User)this.userRepository.findOne((Serializable)userIdentifier)) == null) {
            throw new IllegalArgumentException("No user found with id: " + userDto.getId());
        }
        List usersWithUsernameIgnoreCase = this.userRepository.findByUsernameIgnoreCase(userDto.getUsername());
        if (usersWithUsernameIgnoreCase.size() != 0 && (!usersWithUsernameIgnoreCase.stream().anyMatch(u -> u.getId() == userIdentifier.intValue()) || usersWithUsernameIgnoreCase.stream().anyMatch(u -> u.getUsername().equals(userDto.getUsername()) && u.getId() != userIdentifier.intValue()))) {
            throw new IllegalArgumentException(String.format("Another user with username '%s' ignore case already exists", user.getUsername()));
        }
        if (!myProfile.getAll().contains(profile)) {
            throw new IllegalArgumentException("Trying to set profile to " + profile + " max profile permitted is: " + myProfile);
        }
        LinkedList<GroupElem> groups = new LinkedList<GroupElem>();
        groups.addAll(this.processGroups(userDto.getGroupsRegisteredUser(), Profile.RegisteredUser));
        groups.addAll(this.processGroups(userDto.getGroupsEditor(), Profile.Editor));
        groups.addAll(this.processGroups(userDto.getGroupsReviewer(), Profile.Reviewer));
        groups.addAll(this.processGroups(userDto.getGroupsUserAdmin(), Profile.UserAdmin));
        if (!myProfile.equals((Object)Profile.Administrator)) {
            List myUserAdminGroups = this.userGroupRepository.findGroupIds((Specification)Specifications.where((Specification)UserGroupSpecs.hasProfile((Profile)myProfile)).and(UserGroupSpecs.hasUserId((int)Integer.parseInt(myUserId))));
            List usergroups = this.userGroupRepository.findAll((Specification)Specifications.where((Specification)UserGroupSpecs.hasUserId((int)Integer.parseInt(userDto.getId()))));
            List userToUpdateGroupIds = usergroups.stream().map(ug -> ug.getId().getGroupId()).collect(Collectors.toList());
            Set groupsInCommon = myUserAdminGroups.stream().distinct().filter(userToUpdateGroupIds::contains).collect(Collectors.toSet());
            if (groupsInCommon.isEmpty()) {
                throw new IllegalArgumentException("You don't have rights to do this");
            }
            for (UserGroup ug2 : usergroups) {
                if (myUserAdminGroups.contains(ug2.getGroup().getId())) continue;
                groups.add(new GroupElem(ug2.getProfile().name(), ug2.getGroup().getId()));
            }
        }
        this.fillUserFromParams(user, userDto);
        user = (User)this.userRepository.save((Object)user);
        this.setUserGroups(user, groups);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @ApiOperation(value="Resets user password", notes="Resets the user password.", nickname="resetUserPassword")
    @RequestMapping(value={"/{userIdentifier}/actions/forget-password"}, produces={"application/json"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="isAuthenticated()")
    @ResponseBody
    public ResponseEntity<String> resetUserPassword(@ApiParam(value="User identifier.") @PathVariable Integer userIdentifier, @ApiParam(value="Password to change.") @RequestParam(value="password") String password, @ApiParam(value="Password to change (repeat).") @RequestParam(value="password2") String password2, @ApiIgnore ServletRequest request, @ApiIgnore HttpSession httpSession) throws Exception {
        if (!password.equals(password2)) {
            throw new IllegalArgumentException("Passwords should be equal");
        }
        UserSession session = ApiUtils.getUserSession(httpSession);
        Profile myProfile = session.getProfile();
        String myUserId = session.getUserId();
        if (myProfile != Profile.Administrator && myProfile != Profile.UserAdmin && !myUserId.equals(Integer.toString(userIdentifier))) {
            throw new IllegalArgumentException("You don't have rights to do this");
        }
        User user = (User)this.userRepository.findOne((Serializable)userIdentifier);
        if (user == null) {
            throw new UserNotFoundEx(Integer.toString(userIdentifier));
        }
        String passwordHash = PasswordUtil.encoder((ApplicationContext)ApplicationContextHolder.get()).encode((CharSequence)password);
        user.getSecurity().setPassword(passwordHash);
        user.getSecurity().getSecurityNotifications().remove(UserSecurityNotification.UPDATE_HASH_REQUIRED);
        this.userRepository.save((Object)user);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @ApiOperation(value="Retrieve user groups", notes="Retrieve the user groups.", nickname="retrieveUserGroups")
    @RequestMapping(value={"/{userIdentifier}/groups"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="isAuthenticated()")
    @ResponseBody
    public List<UserGroup> retrieveUserGroups(@ApiParam(value="User identifier.") @PathVariable Integer userIdentifier, @ApiIgnore ServletRequest request, @ApiIgnore HttpSession httpSession) throws Exception {
        UserSession session = ApiUtils.getUserSession(httpSession);
        Profile myProfile = session.getProfile();
        String myUserId = session.getUserId();
        if (myProfile == Profile.Administrator || myProfile == Profile.UserAdmin || myUserId.equals(Integer.toString(userIdentifier))) {
            ArrayList<UserGroup> userGroups;
            User user = (User)this.userRepository.findOne((Serializable)userIdentifier);
            if (user == null) {
                throw new IllegalArgumentException("user " + userIdentifier + " doesn't exist");
            }
            String userProfile = user.getProfile().name();
            if (myProfile == Profile.Administrator && userProfile.equals(Profile.Administrator.name())) {
                userGroups = new ArrayList();
                List groups = this.groupRepository.findAll();
                for (Group g : groups) {
                    UserGroup ug = new UserGroup();
                    UserGroupId ugId = new UserGroupId();
                    ugId.setProfile(Profile.Administrator);
                    ugId.setGroupId(g.getId());
                    ugId.setUserId(userIdentifier.intValue());
                    ug.setGroup(g);
                    ug.setUser(user);
                    ug.setProfile(Profile.Administrator);
                    ug.setId(ugId);
                    userGroups.add(ug);
                }
            } else {
                List adminList;
                if (!myUserId.equals(Integer.toString(userIdentifier)) && myProfile == Profile.UserAdmin && (adminList = this.userGroupRepository.findGroupIds((Specification)Specifications.where((Specification)UserGroupSpecs.hasUserId((int)Integer.parseInt(myUserId))).or(UserGroupSpecs.hasUserId((int)userIdentifier)))).isEmpty()) {
                    throw new SecurityException("You don't have rights to do this because the user you want is not part of your group");
                }
                userGroups = this.userGroupRepository.findAll(UserGroupSpecs.hasUserId((int)userIdentifier));
            }
            return userGroups;
        }
        throw new SecurityException("You don't have rights to do get the groups for this user");
    }

    private List<Integer> getGroupIds(int userId) {
        return this.userGroupRepository.findGroupIds(UserGroupSpecs.hasUserId((int)userId));
    }

    private List<Integer> getGroupIdsWhereUserIsUserAdmin(int userId) {
        return this.userGroupRepository.findGroupIds(UserGroupSpecs.hasUserIdAndProfile((int)userId, (Profile)Profile.UserAdmin));
    }

    private void setUserGroups(User user, List<GroupElem> userGroups) throws Exception {
        List all = this.userGroupRepository.findAll(UserGroupSpecs.hasUserId((int)user.getId()));
        HashSet<String> listOfAddedProfiles = new HashSet<String>();
        for (UserGroup ug : all) {
            String key = ug.getProfile().name() + ug.getGroup().getId();
            if (listOfAddedProfiles.contains(key)) continue;
            listOfAddedProfiles.add(key);
        }
        ArrayList toRemove = new ArrayList();
        toRemove.addAll(all);
        ArrayList<UserGroup> toAdd = new ArrayList<UserGroup>();
        for (GroupElem element : userGroups) {
            String key;
            UserGroup userGroup;
            Integer groupId = element.getId();
            Group group = (Group)this.groupRepository.findOne((Serializable)groupId);
            String profile = element.getProfile();
            if (profile.equals(Profile.Reviewer.name())) {
                userGroup = new UserGroup().setGroup(group).setProfile(Profile.Editor).setUser(user);
                key = Profile.Editor.toString() + group.getId();
                if (!listOfAddedProfiles.contains(key)) {
                    toAdd.add(userGroup);
                    listOfAddedProfiles.add(key);
                }
                for (UserGroup g : all) {
                    if (g.getGroup().getId() != groupId.intValue() || !g.getProfile().equals((Object)Profile.Editor)) continue;
                    toRemove.remove(g);
                }
            }
            userGroup = new UserGroup().setGroup(group).setProfile(Profile.findProfileIgnoreCase((String)profile)).setUser(user);
            key = profile + group.getId();
            if (!listOfAddedProfiles.contains(key)) {
                toAdd.add(userGroup);
                listOfAddedProfiles.add(key);
            }
            for (UserGroup g : all) {
                if (g.getGroup().getId() != groupId.intValue() || !g.getProfile().name().equalsIgnoreCase(profile)) continue;
                toRemove.remove(g);
            }
        }
        this.userGroupRepository.delete(toRemove);
        this.userGroupRepository.save(toAdd);
    }

    private List<GroupElem> processGroups(List<String> groupsToProcessList, Profile profile) {
        LinkedList<GroupElem> groups = new LinkedList<GroupElem>();
        for (String g : groupsToProcessList) {
            groups.add(new GroupElem(profile.name(), Integer.parseInt(g)));
        }
        return groups;
    }

    private void fillUserFromParams(User user, UserDto userDto) {
        user.setEnabled(Boolean.valueOf(userDto.isEnabled()));
        if (StringUtils.isNotEmpty((String)userDto.getUsername())) {
            user.setUsername(userDto.getUsername());
        }
        user.setProfile(Profile.valueOf((String)userDto.getProfile()));
        user.setName(userDto.getName());
        user.setSurname(userDto.getSurname());
        user.setOrganisation(userDto.getOrganisation());
        user.setName(userDto.getName());
        user.setKind(userDto.getKind());
        if (!userDto.getAddresses().isEmpty()) {
            Address userAddress;
            Set userAddresses = user.getAddresses();
            if (userAddresses.isEmpty()) {
                userAddress = new Address();
                userAddresses.add(userAddress);
            } else {
                userAddress = (Address)userAddresses.toArray()[0];
            }
            for (Address address : userDto.getAddresses()) {
                userAddress.setAddress(address.getAddress());
                userAddress.setCity(address.getCity());
                userAddress.setCountry(address.getCountry());
                userAddress.setState(address.getState());
                userAddress.setZip(address.getZip());
            }
        }
        if (!userDto.getEmailAddresses().isEmpty()) {
            user.getEmailAddresses().clear();
            for (String mail : userDto.getEmailAddresses()) {
                user.getEmailAddresses().add(mail);
            }
        }
    }

    private void checkIfAtLeastOneAdminIsEnabled(UserDto userDto, UserRepository userRepository) {
        User adminUser;
        List adminEnabledList;
        if (StringUtils.isNotEmpty((String)userDto.getId()) && !userDto.isEnabled() && (adminEnabledList = userRepository.findAll((Specification)Specifications.where((Specification)UserSpecs.hasProfile((Profile)Profile.Administrator)).and(UserSpecs.hasEnabled((Boolean)true)))).size() == 1 && (adminUser = (User)adminEnabledList.get(0)).getId() == Integer.parseInt(userDto.getId())) {
            throw new IllegalArgumentException("Trying to disable all administrator users is not allowed");
        }
    }
}

