/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.formatters.cache;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fao.geonet.api.records.formatters.FormatType;
import org.fao.geonet.api.records.formatters.cache.AbstractCacheConfig;
import org.fao.geonet.api.records.formatters.cache.Key;

public class ConfigurableCacheConfig
extends AbstractCacheConfig {
    private Set<FormatType> allowedTypes = Sets.newHashSet((Object[])FormatType.values());
    private Set<String> allowedLanguages = null;
    private Set<String> formatterIds = null;
    private boolean cacheFullMetadata = true;
    private boolean cacheHideWithheld = true;
    private HashSet<FormatType> typeExceptions;
    private HashSet<String> formatterExceptions;
    private HashSet<String> langExceptions;

    public ConfigurableCacheConfig() {
        this.allowedTypes.remove((Object)FormatType.pdf);
        this.allowedTypes.remove((Object)FormatType.testpdf);
    }

    @Override
    public boolean extraChecks(Key key) {
        if (this.typeExceptions != null && this.typeExceptions.contains((Object)key.formatType)) {
            return false;
        }
        if (this.formatterExceptions != null && this.formatterExceptions.contains(key.formatterId)) {
            return false;
        }
        if (this.langExceptions != null && this.langExceptions.contains(key.lang)) {
            return false;
        }
        if (!this.allowedTypes.contains((Object)key.formatType)) {
            return false;
        }
        if (this.allowedLanguages != null && !this.allowedLanguages.contains(key.lang)) {
            return false;
        }
        if (this.formatterIds != null && !this.formatterIds.contains(key.formatterId)) {
            return false;
        }
        if (this.formatterIds != null && !this.formatterIds.contains(key.formatterId)) {
            return false;
        }
        if (key.hideWithheld && !this.cacheHideWithheld) {
            return false;
        }
        return key.hideWithheld || this.cacheFullMetadata;
    }

    public void setAllowedTypes(@Nonnull Set<FormatType> allowedTypes) {
        this.allowedTypes = allowedTypes;
    }

    public void setAllowedLanguages(@Nullable Set<String> allowedLanguages) {
        this.allowedLanguages = allowedLanguages;
    }

    public void setFormatterIds(@Nullable Set<String> formatterIds) {
        this.formatterIds = formatterIds;
    }

    public void setCacheFullMetadata(boolean cacheFullMetadata) {
        this.cacheFullMetadata = cacheFullMetadata;
    }

    public void setCacheHideWithheld(boolean cacheHideWithheld) {
        this.cacheHideWithheld = cacheHideWithheld;
    }

    public void setTypeExceptions(HashSet<FormatType> typeExceptions) {
        this.typeExceptions = typeExceptions;
    }

    public void setFormatterExceptions(HashSet<String> formatterExceptions) {
        this.formatterExceptions = formatterExceptions;
    }

    public void setLangExceptions(HashSet<String> langExceptions) {
        this.langExceptions = langExceptions;
    }
}

