/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.formatters;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import jeeves.services.ReadWriteController;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.records.formatters.cache.FormatterCache;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/{portal}/api/formatters", "/{portal}/api/0.1/formatters"})
@Api(value="formatters", tags={"formatters"}, description="Formatter operations")
@Controller(value="formatters")
@ReadWriteController
public class CacheApi {
    @ApiOperation(value="Clear formatter cache", notes="Formatters are used to render records in various format (HTML, PDF, ...). When a record is rendered a cache is populated for better performance. By default the cache is an H2 database with files on the filesystems (See <dataDirectory>/resources/htmlcache/formatter-cache folder).", authorizations={@Authorization(value="basicAuth")}, nickname="clearFormatterCache")
    @RequestMapping(value={"/cache"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @PreAuthorize(value="hasRole('Administrator')")
    @ApiResponses(value={@ApiResponse(code=204, message="Cache cleared."), @ApiResponse(code=403, message="Operation not allowed. Only Administrator can access it.")})
    public void clearFormatterCache() throws Exception {
        FormatterCache formatterCache = (FormatterCache)ApplicationContextHolder.get().getBean(FormatterCache.class);
        formatterCache.clear();
    }
}

