/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api;

import com.google.common.collect.Sets;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.MissingResourceException;
import javax.servlet.http.HttpServletRequest;
import org.fao.geonet.api.ApiError;
import org.fao.geonet.api.exception.FeatureNotEnabledException;
import org.fao.geonet.api.exception.GeoPublisherException;
import org.fao.geonet.api.exception.NoResultsFoundException;
import org.fao.geonet.api.exception.NotAllowedException;
import org.fao.geonet.api.exception.ResourceAlreadyExistException;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.api.exception.WebApplicationException;
import org.fao.geonet.doi.client.DoiClientException;
import org.fao.geonet.exceptions.ServiceNotAllowedEx;
import org.fao.geonet.exceptions.UserNotFoundEx;
import org.fao.geonet.exceptions.XSDValidationErrorEx;
import org.json.JSONException;
import org.springframework.http.HttpStatus;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.UnsatisfiedServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.springframework.web.multipart.MultipartException;

@ControllerAdvice
public class GlobalExceptionController {
    @ResponseBody
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ExceptionHandler(value={NotAllowedException.class})
    public ApiError notAllowedHandler(Exception exception, HttpServletRequest request) {
        ApiError response = null;
        if (this.contentTypeNeedsBody(request)) {
            response = new ApiError("forbidden", exception.getMessage());
        }
        return response;
    }

    @ResponseBody
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ExceptionHandler(value={ServiceNotAllowedEx.class})
    public Object unauthorizedHandler(Exception exception) {
        return new ApiError("unauthorized", exception.getClass().getSimpleName(), exception.getMessage());
    }

    @ResponseBody
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ExceptionHandler(value={SecurityException.class, AccessDeniedException.class})
    public Object securityHandler(Exception exception) {
        return new ApiError("forbidden", exception.getClass().getSimpleName(), exception.getMessage());
    }

    @ResponseBody
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={MaxUploadSizeExceededException.class})
    public ApiError maxFileExceededHandler(Exception exception) {
        return new ApiError("max_file_exceeded", exception.getClass().getSimpleName(), exception.getMessage());
    }

    @ResponseBody
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={HttpMessageNotReadableException.class, Exception.class, RuntimeException.class})
    public ApiError runtimeExceptionHandler(Exception exception) {
        return new ApiError("runtime_exception", exception.getClass().getSimpleName(), exception.getMessage());
    }

    @ResponseBody
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={FeatureNotEnabledException.class})
    public ApiError runtimeExceptionHandler(FeatureNotEnabledException exception) {
        return new ApiError("feature_disabled", exception.getClass().getSimpleName(), exception.getMessage());
    }

    @ResponseBody
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(value={WebApplicationException.class})
    public ApiError webappExceptionHandler(Exception exception) {
        return new ApiError("webapplication_exception", exception.getClass().getSimpleName(), exception.getMessage());
    }

    @ResponseBody
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ExceptionHandler(value={FileNotFoundException.class, GeoPublisherException.class, NoResultsFoundException.class})
    public ApiError NotFoundHandler(Exception exception) {
        return new ApiError("not_found", exception.getClass().getSimpleName(), exception.getMessage());
    }

    @ResponseBody
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ExceptionHandler(value={UserNotFoundEx.class, ResourceNotFoundException.class})
    public ApiError resourceNotFoundHandler(HttpServletRequest request, Exception exception) {
        if (this.contentTypeNeedsBody(request)) {
            return new ApiError("resource_not_found", exception.getClass().getSimpleName(), exception.getMessage());
        }
        return null;
    }

    private boolean contentTypeNeedsBody(HttpServletRequest request) {
        List<MediaType> requestMediaTypes = this.resolveMediaTypes((NativeWebRequest)new ServletWebRequest(request));
        HashSet allowedContentTypes = Sets.newHashSet((Object[])new MediaType[]{MediaType.APPLICATION_XML, MediaType.APPLICATION_XHTML_XML, MediaType.APPLICATION_JSON});
        int posHtmlMediaType = requestMediaTypes.indexOf(MediaType.TEXT_HTML);
        boolean requestedHtmlMediaType = false;
        if (posHtmlMediaType == 0) {
            requestedHtmlMediaType = true;
        } else if (posHtmlMediaType > -1) {
            List<MediaType> allowedContentTypesAndHtml = Arrays.asList(MediaType.APPLICATION_XML, MediaType.APPLICATION_XHTML_XML, MediaType.APPLICATION_JSON, MediaType.TEXT_HTML);
            ArrayList<MediaType> requestMediaTypes2 = new ArrayList<MediaType>(requestMediaTypes);
            requestMediaTypes2.retainAll(allowedContentTypesAndHtml);
            requestedHtmlMediaType = requestMediaTypes2.indexOf(MediaType.TEXT_HTML) == 0;
        }
        boolean needsBody = !Collections.disjoint(allowedContentTypes, requestMediaTypes) && !requestedHtmlMediaType;
        return needsBody;
    }

    public List<MediaType> resolveMediaTypes(NativeWebRequest request) {
        String header = request.getHeader("Accept");
        if (!StringUtils.hasText((String)header)) {
            return Collections.emptyList();
        }
        try {
            List mediaTypes = MediaType.parseMediaTypes((String)header);
            MediaType.sortBySpecificityAndQuality((List)mediaTypes);
            return mediaTypes;
        }
        catch (InvalidMediaTypeException ex) {
            return Collections.emptyList();
        }
    }

    @ResponseBody
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={ResourceAlreadyExistException.class})
    public ApiError resourceAlreadyExistHandler(Exception exception) {
        return new ApiError("resource_already_exist", exception.getClass().getSimpleName(), exception.getMessage());
    }

    @ResponseBody
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    public ApiError missingParameterHandler(Exception exception) {
        return new ApiError("required_parameter_missing", exception.getClass().getSimpleName(), exception.getMessage());
    }

    @ResponseBody
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={UnsatisfiedServletRequestParameterException.class, IllegalArgumentException.class, XSDValidationErrorEx.class, JSONException.class, MultipartException.class, DoiClientException.class})
    public ApiError unsatisfiedParameterHandler(Exception exception) {
        return new ApiError("unsatisfied_request_parameter", exception.getClass().getSimpleName(), exception.getMessage());
    }

    @ResponseBody
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={MissingResourceException.class})
    public ApiError missingResourceHandler(Exception exception) {
        return new ApiError("missing_resource_parameter", exception.getClass().getSimpleName(), exception.getMessage());
    }
}

