/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.notifier;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.MetadataNotification;
import org.fao.geonet.domain.MetadataNotificationAction;
import org.fao.geonet.domain.MetadataNotificationId;
import org.fao.geonet.domain.MetadataNotifier;
import org.fao.geonet.notifier.MetadataNotifierClient;
import org.fao.geonet.repository.MetadataNotificationRepository;
import org.fao.geonet.repository.MetadataNotifierRepository;
import org.fao.geonet.repository.MetadataRepository;
import org.fao.geonet.repository.Updater;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Element;
import org.springframework.context.ConfigurableApplicationContext;

public class MetadataNotifierManager {
    public void updateMetadataBatch() throws MetadataNotifierException {
        if (Log.isDebugEnabled((String)"geonetwork.datamanager")) {
            Log.debug((String)"geonetwork.datamanager", (Object)"updateMetadata unregistered");
        }
        MetadataNotifierClient client = (MetadataNotifierClient)ApplicationContextHolder.get().getBean(MetadataNotifierClient.class);
        for (MetadataNotifier notifier : this.loadNotifiers()) {
            try {
                Map<AbstractMetadata, MetadataNotification> unregisteredMetadata = this.getUnnotifiedMetadata(notifier.getId(), MetadataNotificationAction.UPDATE);
                for (Map.Entry<AbstractMetadata, MetadataNotification> entry : unregisteredMetadata.entrySet()) {
                    AbstractMetadata metadata = entry.getKey();
                    client.webUpdate(notifier, metadata.getData(), metadata.getUuid());
                    this.setMetadataNotified(metadata.getId(), metadata.getUuid(), notifier, false);
                }
                Map<AbstractMetadata, MetadataNotification> unregisteredMetadataToDelete = this.getUnnotifiedMetadata(notifier.getId(), MetadataNotificationAction.DELETE);
                for (Map.Entry<AbstractMetadata, MetadataNotification> entry : unregisteredMetadataToDelete.entrySet()) {
                    AbstractMetadata metadata = entry.getKey();
                    String uuid = metadata.getUuid();
                    client.webDelete(notifier, uuid);
                    this.setMetadataNotified(metadata.getId(), metadata.getUuid(), notifier, true);
                }
            }
            catch (Exception ex) {
                Log.error((String)"geonetwork.datamanager", (Object)("updateMetadataBatch ERROR: " + ex.getMessage()), (Throwable)ex);
            }
        }
    }

    public void updateMetadata(Element metadataElement, String id, String uuid, ServiceContext context) {
        ConfigurableApplicationContext applicationContext = context.getApplicationContext();
        ScheduledThreadPoolExecutor timer = (ScheduledThreadPoolExecutor)applicationContext.getBean("timerThreadPool", ScheduledThreadPoolExecutor.class);
        timer.schedule(new UpdateTask(metadataElement, id, uuid), 10L, TimeUnit.MILLISECONDS);
    }

    public void deleteMetadata(String id, String uuid, ServiceContext context) {
        ConfigurableApplicationContext applicationContext = context.getApplicationContext();
        ScheduledThreadPoolExecutor timer = (ScheduledThreadPoolExecutor)applicationContext.getBean("timerThreadPool", ScheduledThreadPoolExecutor.class);
        timer.schedule(new DeleteTask(id, uuid), 10L, TimeUnit.MILLISECONDS);
    }

    private List<MetadataNotifier> loadNotifiers() throws MetadataNotifierException {
        try {
            ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
            MetadataNotifierRepository metadataNotifierRepository = (MetadataNotifierRepository)applicationContext.getBean(MetadataNotifierRepository.class);
            return metadataNotifierRepository.findAllByEnabled(true);
        }
        catch (Exception ex) {
            Log.error((String)"geonetwork.datamanager", (Object)("loadNotifiers: " + ex.getMessage()), (Throwable)ex);
            throw new MetadataNotifierException(ex.getMessage(), ex);
        }
    }

    private Map<AbstractMetadata, MetadataNotification> getUnnotifiedMetadata(int notifierId, MetadataNotificationAction ... actions) {
        if (Log.isDebugEnabled((String)"geonetwork.datamanager")) {
            Log.debug((String)"geonetwork.datamanager", (Object)"getUnnotifiedMetadata start");
        }
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        MetadataNotificationRepository metadataNotificationRepository = (MetadataNotificationRepository)applicationContext.getBean(MetadataNotificationRepository.class);
        MetadataRepository metadataRepository = (MetadataRepository)applicationContext.getBean(MetadataRepository.class);
        List unNotified = metadataNotificationRepository.findAllNotNotifiedForNotifier(notifierId, actions);
        HashMap<Integer, MetadataNotification> idToNotification = new HashMap<Integer, MetadataNotification>();
        for (MetadataNotification metadataNotification : unNotified) {
            idToNotification.put(metadataNotification.getId().getMetadataId(), metadataNotification);
        }
        List allMetadata = metadataRepository.findAll(idToNotification.keySet());
        HashMap<AbstractMetadata, MetadataNotification> notificationMap = new HashMap<AbstractMetadata, MetadataNotification>();
        for (Metadata metadata : allMetadata) {
            notificationMap.put((AbstractMetadata)metadata, (MetadataNotification)idToNotification.get(metadata.getId()));
        }
        if (Log.isDebugEnabled((String)"geonetwork.datamanager")) {
            Log.debug((String)"geonetwork.datamanager", (Object)("getUnnotifiedMetadata returning #" + notificationMap.size() + " results"));
        }
        return notificationMap;
    }

    private void setMetadataNotified(int metadataId, String uuid, MetadataNotifier notifier, boolean deleteNotification) {
        MetadataNotificationId notificationId;
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        MetadataNotificationRepository metadataNotificationRepository = (MetadataNotificationRepository)applicationContext.getBean(MetadataNotificationRepository.class);
        MetadataNotification notification = (MetadataNotification)metadataNotificationRepository.findOne((Serializable)(notificationId = new MetadataNotificationId().setMetadataId(metadataId).setNotifierId(notifier.getId())));
        if (notification == null) {
            notification = new MetadataNotification();
            notification.setId(notificationId);
        }
        notification.setMetadataUuid(uuid);
        notification.setNotified(true);
        if (deleteNotification) {
            notification.setAction(MetadataNotificationAction.DELETE);
        } else {
            notification.setAction(MetadataNotificationAction.UPDATE);
        }
        metadataNotificationRepository.save((Object)notification);
        if (Log.isDebugEnabled((String)"geonetwork.datamanager")) {
            Log.debug((String)"geonetwork.datamanager", (Object)("setMetadataNotified finished for metadata with id " + metadataId + " and notifier with id " + notifier.getId()));
        }
    }

    private void setMetadataNotifiedError(int metadataId, String uuid, MetadataNotifier notifier, final boolean deleteNotification, final String error) {
        if (Log.isDebugEnabled((String)"geonetwork.datamanager")) {
            Log.debug((String)"geonetwork.datamanager", (Object)"setMetadataNotifiedError");
        }
        try {
            ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
            MetadataNotificationRepository metadataNotificationRepository = (MetadataNotificationRepository)applicationContext.getBean(MetadataNotificationRepository.class);
            MetadataNotificationId id = new MetadataNotificationId().setMetadataId(metadataId).setNotifierId(notifier.getId());
            MetadataNotification errorNotification = (MetadataNotification)metadataNotificationRepository.findOne((Serializable)id);
            if (errorNotification == null) {
                errorNotification = new MetadataNotification();
                errorNotification.setId(id);
                errorNotification.setNotified(true);
                errorNotification.setMetadataUuid(uuid);
                if (deleteNotification) {
                    errorNotification.setAction(MetadataNotificationAction.DELETE);
                } else {
                    errorNotification.setAction(MetadataNotificationAction.UPDATE);
                }
                metadataNotificationRepository.save((Object)errorNotification);
            } else {
                metadataNotificationRepository.update((Serializable)id, (Updater)new Updater<MetadataNotification>(){

                    public void apply(@Nonnull MetadataNotification entity) {
                        entity.setErrorMessage(error);
                        if (deleteNotification) {
                            entity.setAction(MetadataNotificationAction.DELETE);
                        } else {
                            entity.setAction(MetadataNotificationAction.UPDATE);
                        }
                    }
                });
            }
            if (Log.isDebugEnabled((String)"geonetwork.datamanager")) {
                Log.debug((String)"geonetwork.datamanager", (Object)("setMetadataNotifiedError finished for metadata with id " + metadataId + "and notitifer with id " + notifier.getId()));
            }
        }
        catch (Exception ex) {
            Log.error((String)"geonetwork.datamanager", (Object)("Notifier - setMetadataNotifiedError error: " + ex.getMessage()), (Throwable)ex);
            throw ex;
        }
    }

    class DeleteTask
    implements Runnable {
        private final int metadataId;
        private final String uuid;

        DeleteTask(String metadataId, String uuid) {
            this.metadataId = Integer.parseInt(metadataId);
            this.uuid = uuid;
        }

        @Override
        public void run() {
            try {
                ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
                MetadataNotifierClient client = (MetadataNotifierClient)applicationContext.getBean(MetadataNotifierClient.class);
                for (MetadataNotifier service : MetadataNotifierManager.this.loadNotifiers()) {
                    int notifierId = service.getId();
                    String notifierUrl = service.getUrl();
                    try {
                        if (Log.isDebugEnabled((String)"geonetwork.datamanager")) {
                            Log.debug((String)"geonetwork.datamanager", (Object)("deleteMetadata before (uuid): " + this.uuid));
                        }
                        client.webDelete(service, this.uuid);
                        if (Log.isDebugEnabled((String)"geonetwork.datamanager")) {
                            Log.debug((String)"geonetwork.datamanager", (Object)("deleteMetadata (uuid): " + this.uuid));
                        }
                        MetadataNotifierManager.this.setMetadataNotified(this.metadataId, this.uuid, service, true);
                    }
                    catch (Exception ex) {
                        Log.error((String)"geonetwork.datamanager", (Object)("deleteMetadata ERROR (uuid): " + this.uuid + " " + ex.getMessage()), (Throwable)ex);
                        try {
                            MetadataNotifierManager.this.setMetadataNotifiedError(this.metadataId, this.uuid, service, true, ex.getMessage());
                        }
                        catch (Exception ex2) {
                            Log.error((String)"geonetwork.datamanager", (Object)("updateMetadata ERROR (uuid): " + this.uuid + "notifier url " + notifierUrl + " " + ex2.getMessage()), (Throwable)ex2);
                        }
                    }
                }
            }
            catch (Exception e) {
                Log.error((String)"geonetwork.datamanager", (Object)("deleteTask ERROR (uuid): " + this.uuid + ", (id): " + this.metadataId + " " + e.getMessage()), (Throwable)e);
            }
        }
    }

    class UpdateTask
    implements Runnable {
        private final int metadataId;
        private final Element metadataElement;
        private final String uuid;

        UpdateTask(Element metadataElement, String metadataId, String uuid) {
            this.metadataId = Integer.parseInt(metadataId);
            this.uuid = uuid;
            this.metadataElement = metadataElement;
        }

        @Override
        public void run() {
            try {
                String metadataString = Xml.getString((Element)this.metadataElement);
                if (Log.isDebugEnabled((String)"geonetwork.datamanager")) {
                    Log.debug((String)"geonetwork.datamanager", (Object)("updateMetadata before (uuid): " + this.uuid));
                }
                ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
                MetadataNotifierClient client = (MetadataNotifierClient)applicationContext.getBean(MetadataNotifierClient.class);
                for (MetadataNotifier service : MetadataNotifierManager.this.loadNotifiers()) {
                    try {
                        client.webUpdate(service, metadataString, this.uuid);
                        if (Log.isDebugEnabled((String)"geonetwork.datamanager")) {
                            Log.debug((String)"geonetwork.datamanager", (Object)("updateMetadata (uuid): " + this.uuid));
                        }
                        MetadataNotifierManager.this.setMetadataNotified(this.metadataId, this.uuid, service, false);
                    }
                    catch (Exception ex) {
                        Log.error((String)"geonetwork.datamanager", (Object)("updateMetadata ERROR (uuid): " + this.uuid + "notifier url " + service.getUrl() + " " + ex.getMessage()), (Throwable)ex);
                        try {
                            MetadataNotifierManager.this.setMetadataNotifiedError(this.metadataId, this.uuid, service, false, ex.getMessage());
                        }
                        catch (Exception ex2) {
                            Log.error((String)"geonetwork.datamanager", (Object)("updateMetadata ERROR (uuid): " + this.uuid + "notifier url " + service.getUrl() + " " + ex2.getMessage()), (Throwable)ex2);
                        }
                    }
                }
            }
            catch (Exception e) {
                Log.error((String)"geonetwork.datamanager", (Object)("updateTask ERROR (uuid): " + this.uuid + ", (id): " + this.metadataId + " " + e.getMessage()), (Throwable)e);
            }
        }
    }

    static final class MetadataNotifierException
    extends Exception {
        public MetadataNotifierException(String newMessage) {
            super(newMessage);
        }

        public MetadataNotifierException(String message, Exception ex) {
            super(message, ex);
        }
    }
}

