/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.security.ecas;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.User;
import org.fao.geonet.repository.UserRepository;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.dao.AbstractUserDetailsAuthenticationProvider;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.password.PasswordEncoder;

public class ECasUserDetailAuthenticationProvider
extends AbstractUserDetailsAuthenticationProvider
implements ApplicationContextAware,
UserDetailsService {
    private static final Log logger = LogFactory.getLog(ECasUserDetailAuthenticationProvider.class);
    private static final String CAS_STATEFUL = "_cas_stateful_";
    private static final String CAS_FLAG = "ECAS";
    private PasswordEncoder encoder;
    @Autowired
    private UserRepository userRepo;

    protected void additionalAuthenticationChecks(UserDetails userDetails, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        User gnDetails = this.userRepo.findOneByUsername(userDetails.getUsername());
        if (authentication.getCredentials() == null) {
            logger.error((Object)"Authentication failed: no credentials provided");
            throw new BadCredentialsException("Authentication failed: no credentials provided");
        }
        if (!this.encoder.matches((CharSequence)authentication.getCredentials().toString(), gnDetails.getPassword())) {
            logger.warn((Object)"Authentication failed: wrong password provided");
            throw new BadCredentialsException("Authentication failed: wrong password provided");
        }
    }

    protected UserDetails retrieveUser(String username, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        if (CAS_STATEFUL.equalsIgnoreCase(username)) {
            logger.error((Object)"_cas_stateful_ detected in retrieveUser");
            return null;
        }
        try {
            User user = this.userRepo.findOneByUsername(username);
            if (user != null && !user.getSecurity().getAuthType().equalsIgnoreCase(CAS_FLAG)) {
                throw new AuthenticationServiceException("Trying to authenticate through ECAS a user that is not ECAS");
            }
            if (user == null) {
                user = new User();
                user.setUsername(username);
                user.setProfile(Profile.Guest);
                user.setName(username);
                user.getSecurity().setAuthType(CAS_FLAG);
                this.userRepo.saveAndFlush((Object)user);
            }
            return user;
        }
        catch (Throwable e) {
            throw new AuthenticationServiceException("Unexpected error while loading user", e);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.encoder = (PasswordEncoder)applicationContext.getBean("geonetworkEncoder");
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        return this.retrieveUser(username, null);
    }
}

