/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.search.index;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.fao.geonet.kernel.search.index.GeonetworkNRTManager;

public class GeonetworkMultiReader
extends MultiReader {
    private final AtomicInteger _openReaderCount;
    private Map<GeonetworkNRTManager.AcquireResult, GeonetworkNRTManager> _searchers;

    public GeonetworkMultiReader(AtomicInteger openReaderCounter, IndexReader[] subReaders, Map<GeonetworkNRTManager.AcquireResult, GeonetworkNRTManager> searchers) {
        super(subReaders);
        openReaderCounter.incrementAndGet();
        this._openReaderCount = openReaderCounter;
        this._searchers = searchers;
    }

    public void releaseToNRTManager() throws IOException {
        for (Map.Entry<GeonetworkNRTManager.AcquireResult, GeonetworkNRTManager> entry : this._searchers.entrySet()) {
            entry.getValue().release(entry.getKey().searcher);
        }
        this._searchers.clear();
        this._openReaderCount.decrementAndGet();
    }
}

