/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.search;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.WKTReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.text.NumberFormat;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jeeves.server.ServiceConfig;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.PerFieldAnalyzerWrapper;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.document.DocumentStoredFieldVisitor;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.facet.Facets;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.taxonomy.DocValuesOrdinalsReader;
import org.apache.lucene.facet.taxonomy.OrdinalsReader;
import org.apache.lucene.facet.taxonomy.TaxonomyFacetCounts;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.ChainedFilter;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.flexible.core.QueryNodeException;
import org.apache.lucene.queryparser.flexible.standard.StandardQueryParser;
import org.apache.lucene.queryparser.flexible.standard.config.NumericConfig;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.CachingWrapperFilter;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MultiCollector;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopFieldDocs;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.NodeInfo;
import org.fao.geonet.Util;
import org.fao.geonet.constants.Edit;
import org.fao.geonet.constants.Geonet;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.MetadataSourceInfo;
import org.fao.geonet.domain.Pair;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.ReservedGroup;
import org.fao.geonet.domain.ReservedOperation;
import org.fao.geonet.domain.Source;
import org.fao.geonet.exceptions.UnAuthorizedException;
import org.fao.geonet.kernel.AccessManager;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.region.Region;
import org.fao.geonet.kernel.region.RegionsDAO;
import org.fao.geonet.kernel.search.CaseInsensitiveFieldComparatorSource;
import org.fao.geonet.kernel.search.DuplicateDocFilter;
import org.fao.geonet.kernel.search.IndexAndTaxonomy;
import org.fao.geonet.kernel.search.LangSortField;
import org.fao.geonet.kernel.search.LuceneConfig;
import org.fao.geonet.kernel.search.LuceneQueryBuilder;
import org.fao.geonet.kernel.search.LuceneQueryInput;
import org.fao.geonet.kernel.search.LuceneUtils;
import org.fao.geonet.kernel.search.MetaSearcher;
import org.fao.geonet.kernel.search.MetadataRecordSelector;
import org.fao.geonet.kernel.search.NoFilterFilter;
import org.fao.geonet.kernel.search.SearchLoggerTask;
import org.fao.geonet.kernel.search.SearchManager;
import org.fao.geonet.kernel.search.UserQueryInput;
import org.fao.geonet.kernel.search.WildCardStringAnalyzer;
import org.fao.geonet.kernel.search.facet.Format;
import org.fao.geonet.kernel.search.facet.ItemBuilder;
import org.fao.geonet.kernel.search.facet.ItemConfig;
import org.fao.geonet.kernel.search.facet.SummaryType;
import org.fao.geonet.kernel.search.index.GeonetworkMultiReader;
import org.fao.geonet.kernel.search.lucenequeries.DateRangeQuery;
import org.fao.geonet.kernel.search.spatial.SpatialFilter;
import org.fao.geonet.kernel.setting.SettingInfo;
import org.fao.geonet.languages.LanguageDetector;
import org.fao.geonet.repository.SourceRepository;
import org.fao.geonet.repository.UserGroupRepository;
import org.fao.geonet.repository.specification.UserGroupSpecs;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.domain.Specifications;

public class LuceneSearcher
extends MetaSearcher
implements MetadataRecordSelector {
    private static Logger LOGGER = LoggerFactory.getLogger((String)"geonetwork.search");
    private SearchManager _sm;
    private String _styleSheetName;
    private Query _query;
    private Query _loggerQuery;
    private Filter _filter;
    private Sort _sort;
    private Element _elSummary;
    private int _numHits;
    private LanguageSelection _language;
    private Set<String> _tokenizedFieldSet;
    private LuceneConfig _luceneConfig;
    private String _boostQueryClass;
    private String _geomWKT = null;
    private long _versionToken = -1L;
    private SummaryType _summaryConfig;
    private boolean _logSearch = true;

    public LuceneSearcher(SearchManager sm, String styleSheetName, LuceneConfig luceneConfig) {
        this._sm = sm;
        this._styleSheetName = styleSheetName;
        this._luceneConfig = luceneConfig;
        this._boostQueryClass = this._luceneConfig.getBoostQueryClass();
        this._tokenizedFieldSet = luceneConfig.getTokenizedField();
    }

    public static void logSearch(ServiceContext srvContext, ServiceConfig config, Query query, int numHits, Sort sort, String geomWKT, SearchManager sm) {
        SettingInfo si = srvContext.getBean(SettingInfo.class);
        if (si.isSearchStatsEnabled()) {
            LOGGER.debug("Log search in asynch mode - start.");
            GeonetContext gc = (GeonetContext)srvContext.getHandlerContext("contextName");
            SearchLoggerTask logTask = srvContext.getBean(SearchLoggerTask.class);
            logTask.configure(srvContext, query, numHits, sort, geomWKT, config.getValue("guiService", "n"));
            gc.getThreadPool().runTask(logTask);
            LOGGER.debug("Log search in asynch mode - end.");
        }
    }

    @VisibleForTesting
    static void buildPrivilegesMetadataInfo(ServiceContext context, org.apache.lucene.document.Document doc, Element infoEl) throws Exception {
        HashSet operations;
        Integer owner = Integer.valueOf(doc.get("_owner"));
        String groupOwnerString = doc.get("_groupOwner");
        MetadataSourceInfo sourceInfo = new MetadataSourceInfo();
        sourceInfo.setOwner(owner);
        if (groupOwnerString != null) {
            sourceInfo.setGroupOwner(Integer.valueOf(groupOwnerString));
        }
        AccessManager accessManager = context.getBean(AccessManager.class);
        boolean isOwner = accessManager.isOwner(context, sourceInfo);
        boolean canEdit = false;
        if (isOwner) {
            operations = Sets.newHashSet(Arrays.asList(ReservedOperation.values()));
            if (owner != null) {
                LuceneSearcher.addElement(infoEl, "ownerId", owner.toString());
            }
        } else {
            Set<Integer> groups = accessManager.getUserGroups(context.getUserSession(), context.getIpAddress(), false);
            Set<Integer> editingGroups = accessManager.getUserGroups(context.getUserSession(), context.getIpAddress(), true);
            operations = Sets.newHashSet();
            block0: for (ReservedOperation operation : ReservedOperation.values()) {
                IndexableField[] opFields;
                for (IndexableField field : opFields = doc.getFields("_op" + operation.getId())) {
                    Integer groupId = Integer.valueOf(field.stringValue());
                    if (operation == ReservedOperation.editing && editingGroups.contains(groupId)) {
                        canEdit = true;
                        continue block0;
                    }
                    if (!groups.contains(groupId)) continue;
                    operations.add(operation);
                    continue block0;
                }
            }
        }
        if (isOwner || canEdit) {
            LuceneSearcher.addElement(infoEl, "edit", "true");
        }
        if (isOwner) {
            LuceneSearcher.addElement(infoEl, "owner", "true");
        }
        LuceneSearcher.addElement(infoEl, "isPublishedToAll", LuceneSearcher.hasOperation(doc, ReservedGroup.all, ReservedOperation.view));
        LuceneSearcher.addOperationsElement(infoEl, ReservedOperation.view.name(), operations.contains(ReservedOperation.view));
        LuceneSearcher.addOperationsElement(infoEl, ReservedOperation.notify.name(), operations.contains(ReservedOperation.notify));
        LuceneSearcher.addOperationsElement(infoEl, ReservedOperation.download.name(), operations.contains(ReservedOperation.download));
        LuceneSearcher.addOperationsElement(infoEl, ReservedOperation.dynamic.name(), operations.contains(ReservedOperation.dynamic));
        LuceneSearcher.addOperationsElement(infoEl, ReservedOperation.featured.name(), operations.contains(ReservedOperation.featured));
        if (!operations.contains(ReservedOperation.download)) {
            LuceneSearcher.addElement(infoEl, "guestdownload", LuceneSearcher.hasOperation(doc, ReservedGroup.guest, ReservedOperation.download));
        }
    }

    private static String hasOperation(org.apache.lucene.document.Document doc, ReservedGroup group, ReservedOperation operation) {
        IndexableField[] fields;
        String groupId = String.valueOf(group.getId());
        for (IndexableField field : fields = doc.getFields("_op" + operation.getId())) {
            if (!groupId.equals(field.stringValue())) continue;
            return Boolean.TRUE.toString();
        }
        return Boolean.FALSE.toString();
    }

    private static void addOperationsElement(Element root, String name, Object value) {
        root.addContent((Content)new Element(name).setText(value == null ? "" : value.toString()));
    }

    public static LanguageSelection determineLanguage(@Nullable ServiceContext srvContext, @Nonnull Element request, @Nonnull SettingInfo settingInfo) {
        String presentationLanguage;
        String finalDetectedLanguage = null;
        if (settingInfo != null && settingInfo.getRequestedLanguageOnly() == SettingInfo.SearchRequestLanguage.OFF) {
            LOGGER.debug("requestedlanguage ignored, using default one ");
            finalDetectedLanguage = srvContext.getLanguage();
            return new LanguageSelection(finalDetectedLanguage, finalDetectedLanguage);
        }
        String requestedLanguage = request.getChildText("requestedLanguage");
        if (StringUtils.isNotEmpty((String)requestedLanguage)) {
            LOGGER.debug("found requestedlanguage in request: {}", (Object)requestedLanguage);
            finalDetectedLanguage = requestedLanguage;
        } else {
            boolean detected = false;
            if (settingInfo.getAutoDetect()) {
                LOGGER.debug("auto-detecting request language is enabled");
                StringBuilder test = new StringBuilder();
                LuceneQueryInput luceneQueryInput = new LuceneQueryInput(request);
                Map<String, Set<String>> searchCriteria = luceneQueryInput.getTextCriteria();
                if (!searchCriteria.isEmpty()) {
                    for (Set<String> value : searchCriteria.values()) {
                        for (String v : value) {
                            test.append(" ").append(v);
                        }
                    }
                } else {
                    try {
                        List termQueries = Xml.selectNodes((Element)request, (String)"*//ogc:Literal", Arrays.asList(Geonet.Namespaces.OGC));
                        for (Content literals : termQueries) {
                            if (!(literals instanceof Element)) continue;
                            test.append(" ").append(((Element)literals).getText());
                        }
                    }
                    catch (JDOMException termQueries) {
                        // empty catch block
                    }
                }
                try {
                    if (test.length() > 0) {
                        String detectedLanguage = LanguageDetector.getInstance().detect(srvContext, test.toString());
                        LOGGER.debug("automatic language detection: '{}' is in language {}", (Object)test, (Object)detectedLanguage);
                        finalDetectedLanguage = detectedLanguage;
                        detected = true;
                    }
                }
                catch (Exception x) {
                    LOGGER.error("Error auto-detecting language: {}", (Object)x.getMessage(), (Object)x);
                }
            } else {
                LOGGER.debug("auto-detecting request language is disabled");
            }
            if (!detected) {
                LOGGER.debug("autodetection is disabled or detection failed");
                if (srvContext != null) {
                    LOGGER.debug("taking language from servicecontext");
                    finalDetectedLanguage = srvContext.getLanguage();
                } else {
                    LOGGER.debug("taking GeoNetwork default language");
                    finalDetectedLanguage = "eng";
                }
            }
        }
        LOGGER.debug("determined language is: {}", (Object)finalDetectedLanguage);
        String string = presentationLanguage = finalDetectedLanguage == null ? srvContext.getLanguage() : finalDetectedLanguage;
        if (settingInfo.getRequestedLanguageOnly() == SettingInfo.SearchRequestLanguage.ONLY_UI_DOC_LOCALE || settingInfo.getRequestedLanguageOnly() == SettingInfo.SearchRequestLanguage.ONLY_UI_LOCALE || settingInfo.getRequestedLanguageOnly() == SettingInfo.SearchRequestLanguage.PREFER_UI_DOC_LOCALE || settingInfo.getRequestedLanguageOnly() == SettingInfo.SearchRequestLanguage.PREFER_UI_LOCALE) {
            presentationLanguage = requestedLanguage == null ? srvContext.getLanguage() : requestedLanguage;
        }
        return new LanguageSelection(finalDetectedLanguage, presentationLanguage);
    }

    public static Sort makeSort(List<Pair<String, Boolean>> fields, String requestLanguage, boolean sortRequestedLanguageOnTop) {
        ArrayList<SortField> sortFields = new ArrayList<SortField>();
        if (sortRequestedLanguageOnTop && requestLanguage != null) {
            sortFields.add(new LangSortField(requestLanguage));
        }
        for (Pair<String, Boolean> sortBy : fields) {
            LOGGER.debug("Sorting by : ", sortBy);
            SortField sortField = LuceneSearcher.makeSortField((String)sortBy.one(), (Boolean)sortBy.two(), requestLanguage);
            if (sortField == null) continue;
            sortFields.add(sortField);
        }
        sortFields.add(SortField.FIELD_SCORE);
        return new Sort(sortFields.toArray(new SortField[sortFields.size()]));
    }

    private static SortField makeSortField(String sortBy, boolean sortOrder, String searchLang) {
        SortField.Type sortType = SortField.Type.STRING;
        if (sortBy.equals("relevance")) {
            return null;
        }
        if (sortBy.equals("popularity") || sortBy.equals("rating")) {
            sortType = SortField.Type.INT;
            sortBy = "_" + sortBy;
        } else if (sortBy.equals("denominator")) {
            sortType = SortField.Type.INT;
        } else if (sortBy.equals("changeDate") || sortBy.equals("title")) {
            sortBy = "_" + sortBy;
        }
        LOGGER.debug("Sort by: {} order: {} type: {}", new Object[]{sortBy, sortOrder, sortType});
        if (sortType == SortField.Type.STRING) {
            if (searchLang != null) {
                return new SortField(sortBy, (FieldComparatorSource)new CaseInsensitiveFieldComparatorSource(searchLang), sortOrder);
            }
            return new SortField(sortBy, (FieldComparatorSource)CaseInsensitiveFieldComparatorSource.languageInsensitiveInstance(), sortOrder);
        }
        return new SortField(sortBy, sortType, sortOrder);
    }

    public static Query makeLocalisedQuery(Element xmlQuery, PerFieldAnalyzerWrapper analyzer, LuceneConfig luceneConfig, String langCode, SettingInfo.SearchRequestLanguage requestedLanguageOnly) throws Exception {
        Query returnValue = LuceneSearcher.makeQuery(xmlQuery, analyzer, luceneConfig);
        if (StringUtils.isNotEmpty((String)langCode)) {
            returnValue = LuceneQueryBuilder.addLocaleTerm(returnValue, langCode, requestedLanguageOnly);
        }
        LOGGER.debug("Lucene Query: {}", (Object)returnValue);
        return returnValue;
    }

    private static Query makeQuery(Element xmlQuery, PerFieldAnalyzerWrapper analyzer, LuceneConfig luceneConfig) throws Exception {
        TermRangeQuery returnValue;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("MakeQuery input XML:\n{}", (Object)Xml.getString((Element)xmlQuery));
        }
        String name = xmlQuery.getName();
        Set<String> tokenizedFieldSet = luceneConfig.getTokenizedField();
        Map<String, LuceneConfig.LuceneConfigNumericField> numericFieldSet = luceneConfig.getNumericFields();
        if (name.equals("TermQuery")) {
            String fld = xmlQuery.getAttributeValue("fld");
            returnValue = LuceneSearcher.textFieldToken(luceneConfig, xmlQuery.getAttributeValue("txt"), fld, xmlQuery.getAttributeValue("sim"), analyzer, tokenizedFieldSet);
        } else if (name.equals("FuzzyQuery")) {
            String fld = xmlQuery.getAttributeValue("fld");
            returnValue = LuceneSearcher.textFieldToken(luceneConfig, xmlQuery.getAttributeValue("txt"), fld, xmlQuery.getAttributeValue("sim"), analyzer, tokenizedFieldSet);
        } else if (name.equals("PrefixQuery")) {
            String fld = xmlQuery.getAttributeValue("fld");
            String txt = LuceneSearcher.analyzeQueryText(fld, xmlQuery.getAttributeValue("txt"), analyzer, tokenizedFieldSet);
            returnValue = new PrefixQuery(new Term(fld, txt));
        } else {
            if (name.equals("MatchAllDocsQuery")) {
                return new MatchAllDocsQuery();
            }
            if (name.equals("WildcardQuery")) {
                String fld = xmlQuery.getAttributeValue("fld");
                returnValue = LuceneSearcher.textFieldToken(luceneConfig, xmlQuery.getAttributeValue("txt"), fld, xmlQuery.getAttributeValue("sim"), analyzer, tokenizedFieldSet);
            } else if (name.equals("PhraseQuery")) {
                PhraseQuery query = new PhraseQuery();
                for (Object o : xmlQuery.getChildren()) {
                    Element xmlTerm = (Element)o;
                    String fld = xmlTerm.getAttributeValue("fld");
                    String txt = LuceneSearcher.analyzeQueryText(fld, xmlTerm.getAttributeValue("txt"), analyzer, tokenizedFieldSet);
                    if (txt.length() <= 0) continue;
                    query.add(new Term(fld, txt));
                }
                returnValue = query;
            } else if (name.equals("RangeQuery")) {
                String fld = xmlQuery.getAttributeValue("fld");
                String lowerTxt = xmlQuery.getAttributeValue("lowerTxt");
                String upperTxt = xmlQuery.getAttributeValue("upperTxt");
                String sInclusive = xmlQuery.getAttributeValue("inclusive");
                boolean inclusive = "true".equals(sInclusive);
                LuceneConfig.LuceneConfigNumericField fieldConfig = numericFieldSet.get(fld);
                if (fieldConfig != null) {
                    returnValue = LuceneQueryBuilder.buildNumericRangeQueryForType(fld, lowerTxt, upperTxt, inclusive, inclusive, fieldConfig.getType());
                } else {
                    lowerTxt = lowerTxt == null ? null : LuceneSearcher.analyzeQueryText(fld, lowerTxt, analyzer, tokenizedFieldSet);
                    upperTxt = upperTxt == null ? null : LuceneSearcher.analyzeQueryText(fld, upperTxt, analyzer, tokenizedFieldSet);
                    returnValue = TermRangeQuery.newStringRange((String)fld, (String)lowerTxt, (String)upperTxt, (boolean)inclusive, (boolean)inclusive);
                }
            } else if (name.equals("RangeQuery")) {
                String fld = xmlQuery.getAttributeValue("fld");
                String lowerTxt = xmlQuery.getAttributeValue("lowerTxt");
                String upperTxt = xmlQuery.getAttributeValue("upperTxt");
                String sInclusive = xmlQuery.getAttributeValue("inclusive");
                boolean inclusive = "true".equals(sInclusive);
                LuceneConfig.LuceneConfigNumericField fieldConfig = numericFieldSet.get(fld);
                if (fieldConfig != null) {
                    returnValue = LuceneQueryBuilder.buildNumericRangeQueryForType(fld, lowerTxt, upperTxt, inclusive, inclusive, fieldConfig.getType(), fieldConfig.getPrecisionStep());
                } else {
                    lowerTxt = lowerTxt == null ? null : LuceneSearcher.analyzeQueryText(fld, lowerTxt, analyzer, tokenizedFieldSet);
                    upperTxt = upperTxt == null ? null : LuceneSearcher.analyzeQueryText(fld, upperTxt, analyzer, tokenizedFieldSet);
                    returnValue = TermRangeQuery.newStringRange((String)fld, (String)lowerTxt, (String)upperTxt, (boolean)inclusive, (boolean)inclusive);
                }
            } else if (name.equals("DateRangeQuery")) {
                String fld = xmlQuery.getAttributeValue("fld");
                String lowerTxt = xmlQuery.getAttributeValue("lowerTxt");
                String upperTxt = xmlQuery.getAttributeValue("upperTxt");
                String sInclusive = xmlQuery.getAttributeValue("inclusive");
                returnValue = new DateRangeQuery(fld, lowerTxt, upperTxt, sInclusive);
            } else if (name.equals("BooleanQuery")) {
                BooleanQuery query = new BooleanQuery();
                for (Object o : xmlQuery.getChildren()) {
                    Element xmlSubQuery;
                    Query subQuery;
                    Element xmlBooleanClause = (Element)o;
                    String sRequired = xmlBooleanClause.getAttributeValue("required");
                    String sProhibited = xmlBooleanClause.getAttributeValue("prohibited");
                    boolean required = sRequired != null && sRequired.equals("true");
                    boolean prohibited = sProhibited != null && sProhibited.equals("true");
                    BooleanClause.Occur occur = LuceneUtils.convertRequiredAndProhibitedToOccur(required, prohibited);
                    List subQueries = xmlBooleanClause.getChildren();
                    if (subQueries == null || subQueries.size() == 0 || (subQuery = LuceneSearcher.makeQuery(xmlSubQuery = (Element)subQueries.get(0), analyzer, luceneConfig)) == null) continue;
                    query.add(subQuery, occur);
                }
                BooleanQuery.setMaxClauseCount((int)16384);
                returnValue = query;
            } else {
                throw new Exception("unknown lucene query type: " + name);
            }
        }
        LOGGER.debug("Lucene Query: {}", (Object)returnValue);
        return returnValue;
    }

    private static Query textFieldToken(LuceneConfig luceneConfig, String string, String luceneIndexField, String similarity, PerFieldAnalyzerWrapper analyzer, Set<String> tokenizedFieldSet) {
        if (string == null) {
            throw new IllegalArgumentException("Cannot create Lucene query for null string");
        }
        Query query = null;
        String analyzedString = "";
        if (string.indexOf(42) >= 0 || string.indexOf(63) >= 0) {
            WildCardStringAnalyzer wildCardStringAnalyzer = new WildCardStringAnalyzer();
            analyzedString = wildCardStringAnalyzer.analyze(string, luceneIndexField, analyzer, tokenizedFieldSet);
        } else {
            analyzedString = LuceneSearcher.analyzeQueryText(luceneIndexField, string, analyzer, tokenizedFieldSet);
        }
        return LuceneQueryBuilder.constructQueryFromAnalyzedString(luceneConfig, string, luceneIndexField, similarity, query, analyzedString, tokenizedFieldSet);
    }

    public static Pair<TopDocs, Element> doSearchAndMakeSummary(int numHits, int startHit, int endHit, String langCode, SummaryType summaryConfig, LuceneConfig luceneConfig, IndexReader reader, Query query, Filter cFilter, Sort sort, TaxonomyReader taxonomyReader, boolean buildSummary) throws Exception {
        FacetsConfig facetConfiguration = luceneConfig.getTaxonomyConfiguration();
        boolean trackDocScores = luceneConfig.isTrackDocScores();
        boolean trackMaxScore = luceneConfig.isTrackMaxScore();
        boolean docsScoredInOrder = luceneConfig.isDocsScoredInOrder();
        LOGGER.debug("Build summary: {}", (Object)buildSummary);
        LOGGER.debug("Setting up the TFC with numHits {}", (Object)numHits);
        TopFieldCollector tfc = TopFieldCollector.create((Sort)sort, (int)numHits, (boolean)true, (boolean)trackDocScores, (boolean)trackMaxScore, (boolean)docsScoredInOrder);
        LOGGER.debug("Lucene query: ", (Object)query);
        IndexSearcher searcher = new IndexSearcher(reader);
        Element elSummary = new Element("summary");
        if (taxonomyReader != null && buildSummary) {
            FacetsCollector facetCollector = new FacetsCollector();
            searcher.search(query, cFilter, MultiCollector.wrap((Collector[])new Collector[]{tfc, facetCollector}));
            try {
                LuceneSearcher.buildFacetSummary(elSummary, summaryConfig, facetConfiguration, facetCollector, taxonomyReader, langCode);
            }
            catch (Exception e) {
                LOGGER.warn("BuildFacetSummary error. {}", (Object)e.getMessage(), (Object)e);
            }
        } else {
            searcher.search(query, cFilter, (Collector)tfc);
        }
        elSummary.setAttribute("count", tfc.getTotalHits() + "");
        elSummary.setAttribute("type", "local");
        LOGGER.debug(" Get top docs from {} ... {} (total: {})", new Object[]{startHit, endHit, tfc.getTotalHits()});
        TopDocs tdocs = tfc.topDocs(startHit, endHit - startHit);
        return Pair.read((Object)tdocs, (Object)elSummary);
    }

    private static void buildFacetSummary(Element elSummary, SummaryType summaryConfigValues, FacetsConfig facetConfiguration, FacetsCollector facetCollector, TaxonomyReader taxonomyReader, String langCode) throws IOException {
        Format format = summaryConfigValues.getFormat();
        HashMap configurationErrors = Maps.newHashMap();
        for (ItemConfig itemConfig : summaryConfigValues.getItems()) {
            try {
                DocValuesOrdinalsReader ordsReader = new DocValuesOrdinalsReader(itemConfig.getDimension().getFacetFieldName(langCode));
                TaxonomyFacetCounts facets = new TaxonomyFacetCounts((OrdinalsReader)ordsReader, taxonomyReader, facetConfiguration, facetCollector);
                ItemBuilder builder = new ItemBuilder(itemConfig, langCode, (Facets)facets, format);
                Element facetSummary = builder.build();
                elSummary.addContent((Content)facetSummary);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                configurationErrors.put(itemConfig.getDimension().getFacetFieldName(langCode), e);
            }
        }
        if (!configurationErrors.isEmpty()) {
            StringBuilder message = new StringBuilder();
            message.append("Check facet configuration. \n").append(ArrayIndexOutOfBoundsException.class.getSimpleName()).append(" errors are often caused when a facet is configured but does not exist in the taxonomy index. ").append("The facets that have raised this error are: ");
            for (String facet : configurationErrors.keySet()) {
                message.append("\n  * ").append(facet);
            }
            LOGGER.error("{}", (Object)message);
            ((ArrayIndexOutOfBoundsException)configurationErrors.values().iterator().next()).printStackTrace();
        }
    }

    private static Element getMetadataFromIndexForPdf(UserSession us, Set<Integer> userGroups, org.apache.lucene.document.Document doc, String id, String searchLang, Set<String> multiLangSearchTerm, Map<String, String> dumpFields, Set<String> extraDumpFields) {
        Element md = LuceneSearcher.getMetadataFromIndex(doc, id, true, searchLang, multiLangSearchTerm, dumpFields, extraDumpFields);
        Element info = md.getChild("info", Edit.NAMESPACE);
        if (us.getProfile() == Profile.Administrator) {
            info.addContent((Content)new Element(ReservedOperation.download.name()).setText("true"));
            info.addContent((Content)new Element(ReservedOperation.dynamic.name()).setText("true"));
        } else {
            boolean isOwner = false;
            IndexableField[] values = doc.getFields("_owner");
            if (us.isAuthenticated()) {
                for (IndexableField f : values) {
                    if (f == null || !us.getUserId().equals(f.stringValue())) continue;
                    isOwner = true;
                    break;
                }
            }
            if (isOwner) {
                info.addContent((Content)new Element(ReservedOperation.download.name()).setText("true"));
                info.addContent((Content)new Element(ReservedOperation.dynamic.name()).setText("true"));
            } else {
                for (IndexableField f : values = doc.getFields("_op1")) {
                    if (f == null || !userGroups.contains(Integer.parseInt(f.stringValue()))) continue;
                    info.addContent((Content)new Element(ReservedOperation.download.name()).setText("true"));
                    break;
                }
                for (IndexableField f : values = doc.getFields("_op5")) {
                    if (f == null || !userGroups.contains(Integer.parseInt(f.stringValue()))) continue;
                    info.addContent((Content)new Element(ReservedOperation.dynamic.name()).setText("true"));
                    break;
                }
            }
        }
        return md;
    }

    private static Element getMetadataFromIndex(org.apache.lucene.document.Document doc, String id, boolean dumpAllField, String searchLang, Set<String> multiLangSearchTerm, Map<String, String> dumpFields, Set<String> extraDumpFields) {
        String changeDate;
        String schema = doc.get("_schema");
        String source = doc.get("_source");
        String uuid = doc.get("_uuid");
        String createDate = doc.get("_createDate");
        if (createDate != null) {
            createDate = createDate.toUpperCase();
        }
        if ((changeDate = doc.get("_changeDate")) != null) {
            changeDate = changeDate.toUpperCase();
        }
        Element md = new Element("metadata");
        Element info = new Element("info", Edit.NAMESPACE);
        LuceneSearcher.addElement(info, "id", id);
        LuceneSearcher.addElement(info, "uuid", uuid);
        LuceneSearcher.addElement(info, "schema", schema);
        LuceneSearcher.addElement(info, "createDate", createDate);
        LuceneSearcher.addElement(info, "changeDate", changeDate);
        LuceneSearcher.addElement(info, "source", source);
        LinkedHashSet<String> addedTranslation = new LinkedHashSet<String>();
        if ((dumpAllField || dumpFields != null) && searchLang != null && multiLangSearchTerm != null) {
            for (String string : multiLangSearchTerm) {
                IndexableField[] values;
                for (IndexableField f : values = doc.getFields(LuceneConfig.multilingualSortFieldName(string, searchLang))) {
                    String stringValue;
                    if (f == null || (stringValue = f.stringValue()).trim().isEmpty()) continue;
                    addedTranslation.add(string);
                    md.addContent((Content)new Element(dumpFields.get(string)).setText(stringValue));
                }
            }
        }
        if (addedTranslation.isEmpty()) {
            addedTranslation = null;
        }
        if (dumpFields != null) {
            for (Map.Entry entry : dumpFields.entrySet()) {
                String fieldName = (String)entry.getKey();
                LuceneSearcher.addIndexValues(doc, md, addedTranslation, (String)entry.getValue(), fieldName);
            }
            if (extraDumpFields != null) {
                for (String string : extraDumpFields) {
                    if (string.contains("*")) {
                        String string2 = string.replace("*", ".*");
                        for (IndexableField indexableField : doc) {
                            if (!indexableField.name().matches(string2)) continue;
                            LuceneSearcher.addIndexValue(md, addedTranslation, indexableField.name(), indexableField.name(), indexableField);
                        }
                        continue;
                    }
                    LuceneSearcher.addIndexValues(doc, md, addedTranslation, string, string);
                }
            }
        } else {
            List fields = doc.getFields();
            for (IndexableField field : fields) {
                String fieldName = field.name();
                String fieldValue = field.stringValue();
                if (fieldName.equals("_cat")) {
                    LuceneSearcher.addElement(info, "category", fieldValue);
                    continue;
                }
                if (!dumpAllField || addedTranslation != null && addedTranslation.contains(fieldName)) continue;
                md.addContent((Content)new Element(fieldName).setText(fieldValue));
            }
        }
        md.addContent((Content)info);
        return md;
    }

    private static void addIndexValues(org.apache.lucene.document.Document doc, Element md, HashSet<String> addedTranslation, String outputName, String fieldName) {
        IndexableField[] values;
        for (IndexableField f : values = doc.getFields(fieldName)) {
            LuceneSearcher.addIndexValue(md, addedTranslation, outputName, fieldName, f);
        }
    }

    private static void addIndexValue(Element md, HashSet<String> addedTranslation, String outputName, String fieldName, IndexableField f) {
        if (!(f == null || addedTranslation != null && addedTranslation.contains(fieldName))) {
            md.addContent((Content)new Element(outputName).setText(f.stringValue()));
        }
    }

    public static String getMetadataFromIndex(String priorityLang, String id, String fieldname) throws Exception {
        return LuceneSearcher.getMetadataFromIndex(priorityLang, id, Collections.singleton(fieldname)).get(fieldname);
    }

    public static String getMetadataFromIndexById(String priorityLang, String id, String fieldname) throws Exception {
        return LuceneSearcher.getMetadataFromIndex(priorityLang, "_id", id, Collections.singleton(fieldname)).get(fieldname);
    }

    private static Map<String, String> getMetadataFromIndex(String priorityLang, String uuid, Set<String> fieldnames) throws Exception {
        return LuceneSearcher.getMetadataFromIndex(priorityLang, "_uuid", uuid, fieldnames);
    }

    public static Map<String, String> getMetadataFromIndex(String priorityLang, String idField, String id, Set<String> fieldnames) throws Exception {
        Map<String, Map<String, String>> results = LuceneSearcher.getAllMetadataFromIndexFor(priorityLang, idField, id, fieldnames, false);
        if (results.size() == 1) {
            return results.values().iterator().next();
        }
        return new HashMap<String, String>();
    }

    public static Map<String, Map<String, String>> getAllMetadataFromIndexFor(String priorityLang, String field, String value, Set<String> returnFields, boolean checkAllHits) throws Exception {
        return LuceneSearcher.getAllMetadataFromIndexFor(priorityLang, field, value, returnFields, checkAllHits, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Map<String, String>> getAllMetadataFromIndexFor(String priorityLang, String field, String value, Set<String> returnFields, boolean checkAllHits, boolean allValues) throws Exception {
        ServiceContext context = ServiceContext.get();
        if (context == null) {
            throw new IllegalStateException("There needs to be a ServiceContext in the thread local for this thread");
        }
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        SearchManager searchmanager = gc.getBean(SearchManager.class);
        IndexAndTaxonomy indexAndTaxonomy = searchmanager.getNewIndexReader(priorityLang);
        GeonetworkMultiReader reader = indexAndTaxonomy.indexReader;
        HashMap<String, Map<String, String>> records = new HashMap<String, Map<String, String>>();
        try {
            IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
            TermQuery query = new TermQuery(new Term(field, value));
            SettingInfo settingInfo = searchmanager.getSettingInfo();
            boolean sortRequestedLanguageOnTop = settingInfo.getRequestedLanguageOnTop();
            LOGGER.debug("sortRequestedLanguageOnTop: {}", (Object)sortRequestedLanguageOnTop);
            int numberOfHits = 1;
            int counter = 0;
            if (checkAllHits) {
                numberOfHits = Integer.MAX_VALUE;
            }
            Sort sort = LuceneSearcher.makeSort(Collections.emptyList(), priorityLang, sortRequestedLanguageOnTop);
            Filter filter = NoFilterFilter.instance();
            TopFieldDocs tdocs = searcher.search((Query)query, filter, numberOfHits, sort);
            for (ScoreDoc sdoc : tdocs.scoreDocs) {
                HashMap<String, String> values = new HashMap<String, String>();
                DocumentStoredFieldVisitor docVisitor = new DocumentStoredFieldVisitor(returnFields);
                reader.document(sdoc.doc, (StoredFieldVisitor)docVisitor);
                org.apache.lucene.document.Document doc = docVisitor.getDocument();
                for (String fieldname : returnFields) {
                    if (!allValues) {
                        values.put(fieldname, doc.get(fieldname));
                        continue;
                    }
                    values.put(fieldname, String.join((CharSequence)",", doc.getValues(fieldname)));
                }
                records.put(String.valueOf(counter), values);
                ++counter;
            }
        }
        catch (CorruptIndexException e) {
            LOGGER.error(e.getMessage());
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage());
        }
        finally {
            searchmanager.releaseIndexReader(indexAndTaxonomy);
        }
        return records;
    }

    protected static String analyzeQueryText(String field, String aText, PerFieldAnalyzerWrapper analyzer, Set<String> tokenizedFieldSet) {
        LOGGER.debug("Analyze field {} : {}", (Object)field, (Object)aText);
        if (tokenizedFieldSet.contains(field)) {
            String analyzedText = LuceneSearcher.analyzeText(field, aText, analyzer);
            LOGGER.debug("Analyzed text is {}", (Object)analyzedText);
            return analyzedText;
        }
        return aText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String analyzeText(String field, String requestStr, PerFieldAnalyzerWrapper a) {
        boolean phrase = false;
        if (requestStr.startsWith("\"") && requestStr.endsWith("\"")) {
            phrase = true;
        }
        ArrayList<String> tokenList = new ArrayList<String>();
        TokenStream ts = null;
        try {
            ts = a.tokenStream(field, (Reader)new StringReader(requestStr));
            ts.reset();
            CharTermAttribute termAtt = (CharTermAttribute)ts.addAttribute(CharTermAttribute.class);
            while (ts.incrementToken()) {
                String string = termAtt.toString();
                tokenList.add(string);
            }
        }
        catch (Exception e) {
            LOGGER.error("geonetwork.search", (Object)("analyzeText error:" + e.getMessage()), (Object)e);
        }
        finally {
            if (ts != null) {
                try {
                    ts.close();
                }
                catch (IOException e) {
                    LOGGER.error("geonetwork.search", (Object)("analyzeText error closing TokenStream:" + e.getMessage()), (Object)e);
                }
            }
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < tokenList.size(); ++i) {
            if (i > 0) {
                result.append(" ");
                result.append((String)tokenList.get(i));
                continue;
            }
            result.append((String)tokenList.get(i));
        }
        String outStr = result.toString();
        if (phrase) {
            outStr = "\"" + outStr + "\"";
        }
        return outStr;
    }

    public static String escapeLuceneChars(String aText, String excludes) {
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(aText);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '\\' && !excludes.contains("\\")) {
                result.append("\\");
            } else if (character == '!' && !excludes.contains("!")) {
                result.append("\\");
            } else if (character == '(' && !excludes.contains("(")) {
                result.append("\\");
            } else if (character == ')' && !excludes.contains(")")) {
                result.append("\\");
            } else if (character == '*' && !excludes.contains("*")) {
                result.append("\\");
            } else if (character == '+' && !excludes.contains("+")) {
                result.append("\\");
            } else if (character == '-' && !excludes.contains("-")) {
                result.append("\\");
            } else if (character == ':' && !excludes.contains(":")) {
                result.append("\\");
            } else if (character == '?' && !excludes.contains("?")) {
                result.append("\\");
            } else if (character == '[' && !excludes.contains("[")) {
                result.append("\\");
            } else if (character == ']' && !excludes.contains("]")) {
                result.append("\\");
            } else if (character == '^' && !excludes.contains("^")) {
                result.append("\\");
            } else if (character == '{' && !excludes.contains("{")) {
                result.append("\\");
            } else if (character == '}' && !excludes.contains("}")) {
                result.append("\\");
            }
            result.append(character);
            character = iterator.next();
        }
        LOGGER.debug("Escaped: {}", (Object)result);
        return result.toString();
    }

    @Override
    public void search(ServiceContext srvContext, Element request, ServiceConfig config) throws Exception {
        LOGGER.debug("LuceneSearcher search()");
        String sBuildSummary = request.getChildText("buildSummary");
        boolean buildSummary = sBuildSummary == null || sBuildSummary.equals("true");
        this._language = LuceneSearcher.determineLanguage(srvContext, request, this._sm.getSettingInfo());
        LOGGER.debug("LuceneSearcher initializing search range");
        this.initSearchRange(srvContext);
        LOGGER.debug("LuceneSearcher computing query");
        this.computeQuery(srvContext, request, config);
        LOGGER.debug("LuceneSearcher performing query");
        this.performQuery(srvContext, this.getFrom() - 1, this.getTo(), buildSummary);
        this.updateSearchRange(request);
        if (this._logSearch) {
            LuceneSearcher.logSearch(srvContext, config, this._loggerQuery, this._numHits, this._sort, this._geomWKT, this._sm);
        }
    }

    @Override
    public List<Document> presentDocuments(ServiceContext srvContext, Element request, ServiceConfig config) throws Exception {
        throw new UnsupportedOperationException("Not supported by Lucene searcher");
    }

    @Override
    public Element present(ServiceContext srvContext, Element request, ServiceConfig config) throws Exception {
        String sBuildSummary;
        boolean buildSummary;
        String sFast;
        this.updateSearchRange(request);
        GeonetContext gc = null;
        if (srvContext != null) {
            gc = (GeonetContext)srvContext.getHandlerContext("contextName");
        }
        boolean fast = (sFast = request.getChildText("fast")) != null && sFast.equals("true");
        boolean inFastMode = fast || "index".equals(sFast) || "indexpdf".equals(sFast);
        HashSet extraDumpFields = Sets.newHashSet();
        if (inFastMode) {
            String[] fields;
            for (String field : fields = Util.getParam((Element)request, (String)"extraDumpFields", (String)"").split(",")) {
                if (field.trim().isEmpty()) continue;
                extraDumpFields.add(field);
            }
            extraDumpFields.addAll(Arrays.asList(fields));
        }
        Element response = new Element("response");
        response.setAttribute("from", this.getFrom() + "");
        response.setAttribute("to", this.getTo() + "");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(Xml.getString((Element)response));
        }
        boolean bl = buildSummary = (sBuildSummary = request.getChildText("buildSummary")) == null || sBuildSummary.equals("true");
        if (buildSummary && this._elSummary != null) {
            response.addContent((Content)((Element)this._elSummary.clone()));
        }
        if (this.getTo() > 0) {
            TopDocs tdocs = this.performQuery(srvContext, this.getFrom() - 1, this.getTo(), false);
            int nrHits = this.getTo() - (this.getFrom() - 1);
            if (tdocs.scoreDocs.length >= nrHits) {
                Set<Integer> userGroups = null;
                try (IndexAndTaxonomy indexAndTaxonomy = this._sm.getIndexReader(this._language.presentationLanguage, this._versionToken);){
                    this._versionToken = indexAndTaxonomy.version;
                    for (int i = 0; i < nrHits; ++i) {
                        org.apache.lucene.document.Document doc;
                        if (inFastMode) {
                            doc = indexAndTaxonomy.indexReader.document(tdocs.scoreDocs[i].doc);
                        } else {
                            DocumentStoredFieldVisitor docVisitor = new DocumentStoredFieldVisitor(new String[]{"_id"});
                            indexAndTaxonomy.indexReader.document(tdocs.scoreDocs[i].doc, (StoredFieldVisitor)docVisitor);
                            doc = docVisitor.getDocument();
                        }
                        String id = doc.get("_id");
                        Element md = null;
                        if (fast) {
                            md = LuceneSearcher.getMetadataFromIndex(doc, id, false, null, null, null, extraDumpFields);
                        } else if ("indexpdf".equals(sFast)) {
                            if (userGroups == null) {
                                userGroups = gc.getBean(AccessManager.class).getUserGroups(srvContext.getUserSession(), srvContext.getIpAddress(), false);
                            }
                            md = LuceneSearcher.getMetadataFromIndexForPdf(srvContext.getUserSession(), userGroups, doc, id, this._language.presentationLanguage, this._luceneConfig.getMultilingualSortFields(), this._luceneConfig.getDumpFields(), extraDumpFields);
                        } else if ("index".equals(sFast)) {
                            md = LuceneSearcher.getMetadataFromIndex(doc, id, true, this._language.presentationLanguage, this._luceneConfig.getMultilingualSortFields(), this._luceneConfig.getDumpFields(), extraDumpFields);
                            LuceneSearcher.buildPrivilegesMetadataInfo(srvContext, doc, md.getChild("info", Edit.NAMESPACE));
                        } else if (srvContext != null) {
                            boolean forEditing = false;
                            boolean withValidationErrors = false;
                            boolean keepXlinkAttributes = false;
                            md = gc.getBean(DataManager.class).getMetadata(srvContext, id, forEditing, withValidationErrors, keepXlinkAttributes);
                        }
                        if (md == null) continue;
                        if (this._luceneConfig.isTrackDocScores()) {
                            Float score = Float.valueOf(tdocs.scoreDocs[i].score);
                            Element info = md.getChild("info", Edit.NAMESPACE);
                            LuceneSearcher.addElement(info, "score", score.toString());
                        }
                        response.addContent((Content)md);
                    }
                }
            } else {
                throw new Exception("Failed: Not enough search results (" + tdocs.scoreDocs.length + ") available to meet request for " + nrHits + ".");
            }
        }
        return response;
    }

    public void getSuggestionForFields(ServiceContext srvContext, String searchField, String searchValue, ServiceConfig config, int maxNumberOfTerms, int threshold, Collection<SearchManager.TermFrequency> suggestions) throws Exception {
        LOGGER.debug("Get suggestion on field: '{}'\tsearching: '{}'\tthreshold: '{}'\tmaxNumberOfTerms: '{}'", new Object[]{searchField, searchValue, threshold, maxNumberOfTerms});
        String searchValueWithoutWildcard = searchValue.replaceAll("[*?]", "");
        if (this._language == null) {
            Element request = new Element("request").addContent((Content)new Element("any").setText(searchValue));
            this._language = LuceneSearcher.determineLanguage(srvContext, request, this._sm.getSettingInfo());
        }
        this._logSearch = false;
        Element elData = new Element("request");
        elData.addContent((Content)new Element("fast").addContent("index"));
        elData.addContent((Content)new Element("buildSummary").addContent(Boolean.toString(true)));
        if (!searchValue.equals("")) {
            elData.addContent((Content)new Element(searchField).setText(searchValue));
        }
        elData.addContent((Content)new Element("from").setText("1"));
        elData.addContent((Content)new Element("to").setText("2147483647"));
        elData.addContent((Content)new Element("resultType").setText("suggestions"));
        elData.addContent((Content)new Element("summaryItems").setText(searchField));
        this.search(srvContext, elData, config);
        if (this.getTo() > 0) {
            LinkedHashSet<String> encountered = new LinkedHashSet<String>();
            Iterator descendants = this._elSummary.getDescendants();
            while (descendants.hasNext()) {
                String value;
                Element element;
                Content next = (Content)descendants.next();
                if (!(next instanceof Element) || (element = (Element)next).getContentSize() != 0 || element.getAttribute("name") == null || encountered.contains(value = element.getAttributeValue("name"))) continue;
                encountered.add(value);
                int count = Integer.parseInt(element.getAttributeValue("count"));
                if (!value.toLowerCase().contains(searchValueWithoutWildcard.toLowerCase())) continue;
                SearchManager.TermFrequency term = new SearchManager.TermFrequency(value, count);
                suggestions.add(term);
            }
        }
        if (threshold > 1) {
            int size = suggestions.size();
            Iterator<SearchManager.TermFrequency> it = suggestions.iterator();
            while (it.hasNext()) {
                SearchManager.TermFrequency term = it.next();
                if (term.getFrequency() >= threshold) continue;
                it.remove();
            }
            LOGGER.debug("  {}/{} above threshold: {}", new Object[]{suggestions.size(), size, threshold});
        }
        LOGGER.debug("  {} returned.", (Object)suggestions.size());
    }

    @Override
    public int getSize() {
        return this._numHits;
    }

    @Override
    public Element getSummary() throws Exception {
        Element response = new Element("response");
        response.addContent((Content)((Element)this._elSummary.clone()));
        return response;
    }

    @Override
    public synchronized void close() {
    }

    private void computeQuery(ServiceContext srvContext, Element request, ServiceConfig config) throws Exception {
        DuplicateDocFilter filter;
        String resultType;
        Element child = request.getChild("resultType");
        if (child == null) {
            resultType = config.getValue("resultType", "hits");
        } else {
            resultType = child.getValue();
            child.detach();
        }
        this._summaryConfig = this._luceneConfig.getSummaryTypes().get(resultType);
        Element summaryItemsEl = request.getChild("summaryItems");
        if (summaryItemsEl != null) {
            String[] items;
            summaryItemsEl.detach();
            ArrayList<ItemConfig> requestedItems = new ArrayList<ItemConfig>();
            for (String item : items = summaryItemsEl.getValue().split(",")) {
                if (item.startsWith("any")) {
                    requestedItems.addAll(this._summaryConfig.getItems());
                    break;
                }
                requestedItems.add(this._summaryConfig.get(item.trim()));
            }
            this._summaryConfig = new SummaryType(this._summaryConfig.getName(), requestedItems);
        }
        if (srvContext != null) {
            List requestedGroups = request.getChildren("group");
            Set<Integer> userGroups = srvContext.getBean(AccessManager.class).getUserGroups(srvContext.getUserSession(), srvContext.getIpAddress(), false);
            UserSession userSession = srvContext.getUserSession();
            if ((userSession == null || userSession.getProfile() == null || userSession.getProfile() != Profile.Administrator && userSession.isAuthenticated()) && !CollectionUtils.isEmpty((Collection)requestedGroups)) {
                for (Element group : requestedGroups) {
                    if ("".equals(group.getText()) || userGroups.contains(Integer.valueOf(group.getText()))) continue;
                    throw new UnAuthorizedException("You are not authorized to do this.", null);
                }
            }
            for (String fieldName : UserQueryInput.SECURITY_FIELDS) {
                request.removeChildren(fieldName);
            }
            if (request.getChild("group") == null || StringUtils.isEmpty((String)request.getChild("group").getText().trim())) {
                for (Integer group : userGroups) {
                    request.addContent((Content)new Element("group").addContent("" + group));
                }
                String owner = null;
                if (userSession != null) {
                    owner = userSession.getUserId();
                }
                if (owner != null) {
                    LOGGER.trace("Search using user \"" + owner + "\".");
                    request.addContent((Content)new Element("owner").addContent(owner));
                    Specifications hasUserIdAndProfile = Specifications.where((Specification)Specifications.where((Specification)UserGroupSpecs.hasProfile((Profile)Profile.Reviewer)).or(UserGroupSpecs.hasProfile((Profile)Profile.Editor)).or(UserGroupSpecs.hasProfile((Profile)Profile.UserAdmin))).and(UserGroupSpecs.hasUserId((int)userSession.getUserIdAsInt()));
                    List editableGroups = srvContext.getBean(UserGroupRepository.class).findGroupIds((Specification)hasUserIdAndProfile);
                    LOGGER.trace(" > User has " + editableGroups.size() + " groups with editing privileges.");
                    for (Object group : editableGroups) {
                        LOGGER.trace("   > Group: " + group);
                        request.addContent((Content)new Element("groupEdit").addContent("" + group));
                    }
                }
                if (userSession != null && userSession.isAuthenticated()) {
                    if (userSession.getProfile() == Profile.Administrator) {
                        request.addContent((Content)new Element("isAdmin").addContent("true"));
                    } else if (userSession.getProfile() == Profile.Reviewer) {
                        request.addContent((Content)new Element("isReviewer").addContent("true"));
                    }
                }
            }
            this.processTimeRange(request.getChild("dateFrom"), "0000-01-01", request.getChild("dateTo"), "9999-01-01");
            this.processTimeRange(request.getChild("creationDateFrom"), "0000-01-01", request.getChild("creationDateTo"), "9999-01-01");
            this.processTimeRange(request.getChild("revisionDateFrom"), "0000-01-01", request.getChild("revisionDateTo"), "9999-01-01");
            this.processTimeRange(request.getChild("publicationDateFrom"), "0000-01-01", request.getChild("publicationDateTo"), "9999-01-01");
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("CRITERIA: {}\n", (Object)Xml.getString((Element)request));
            }
            SettingInfo settingInfo = this._sm.getSettingInfo();
            SettingInfo.SearchRequestLanguage requestedLanguageOnly = settingInfo.getRequestedLanguageOnly();
            LOGGER.debug("requestedLanguageOnly: {}", (Object)requestedLanguageOnly);
            ArrayList operations = new ArrayList(request.getChildren("operation"));
            request.removeChildren("operation");
            if (operations.size() > 0) {
                StringBuilder grpList = new StringBuilder();
                for (Integer n : userGroups) {
                    if (grpList.length() > 0) {
                        grpList.append(" or ");
                    }
                    grpList.append(n);
                }
                String grps = grpList.toString();
                for (Object elem : operations) {
                    if (elem.getValue().equalsIgnoreCase("view")) {
                        request.addContent((Content)new Element("_operation0").addContent(grps));
                        continue;
                    }
                    if (elem.getValue().equalsIgnoreCase("download")) {
                        request.addContent((Content)new Element("_operation1").addContent(grps));
                        continue;
                    }
                    if (elem.getValue().equalsIgnoreCase("editing")) {
                        request.addContent((Content)new Element("_operation2").addContent(grps));
                        continue;
                    }
                    if (elem.getValue().equalsIgnoreCase("notify")) {
                        request.addContent((Content)new Element("_operation3").addContent(grps));
                        continue;
                    }
                    if (elem.getValue().equalsIgnoreCase("dynamic")) {
                        request.addContent((Content)new Element("_operation5").addContent(grps));
                        continue;
                    }
                    if (!elem.getValue().equalsIgnoreCase("featured")) continue;
                    request.addContent((Content)new Element("_operation6").addContent(grps));
                }
            }
            if (this._styleSheetName.equals("z3950Server.xsl")) {
                Element xmlQuery = this._sm.transform(this._styleSheetName, request);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("XML QUERY: {}\n", (Object)Xml.getString((Element)xmlQuery));
                }
                this._query = LuceneSearcher.makeLocalisedQuery(xmlQuery, SearchManager.getAnalyzer(this._language.analyzerLanguage, true), this._luceneConfig, this._language.presentationLanguage, requestedLanguageOnly);
            } else {
                LOGGER.debug("LuceneSearcher constructing Lucene query (LQB)");
                LuceneQueryInput luceneQueryInput = new LuceneQueryInput(request);
                luceneQueryInput.setRequestedLanguageOnly(requestedLanguageOnly);
                this._query = new LuceneQueryBuilder(this._luceneConfig, this._tokenizedFieldSet, SearchManager.getAnalyzer(this._language.analyzerLanguage, true), this._language.presentationLanguage).build(luceneQueryInput);
                LOGGER.debug("Lucene query: {}", (Object)this._query);
                boolean ignorePortalFilter = Boolean.parseBoolean(config.getValue("ignorePortalFilter", "false"));
                if (!ignorePortalFilter) {
                    this._query = LuceneSearcher.appendPortalFilter(this._query, this._luceneConfig);
                }
                try {
                    Object elem;
                    IndexAndTaxonomy indexAndTaxonomy = this._sm.getIndexReader(this._language.presentationLanguage, this._versionToken);
                    elem = null;
                    try {
                        this._loggerQuery = this._query.rewrite((IndexReader)indexAndTaxonomy.indexReader);
                    }
                    catch (Throwable throwable) {
                        elem = throwable;
                        throw throwable;
                    }
                    finally {
                        if (indexAndTaxonomy != null) {
                            if (elem != null) {
                                try {
                                    indexAndTaxonomy.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)elem).addSuppressed(throwable);
                                }
                            } else {
                                indexAndTaxonomy.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    LOGGER.warn("Error rewriting Lucene query: {}", (Object)this._query);
                }
            }
            if (this._boostQueryClass != null) {
                try {
                    LOGGER.debug("Create boosting query: {}", (Object)this._boostQueryClass);
                    Class<?> boostClass = Class.forName(this._boostQueryClass);
                    Class<?>[] clTypesArray = this._luceneConfig.getBoostQueryParameterClass();
                    Object[] objectArray = this._luceneConfig.getBoostQueryParameter();
                    Class[] clTypesArrayAll = new Class[clTypesArray.length + 1];
                    clTypesArrayAll[0] = Class.forName("org.apache.lucene.search.Query");
                    System.arraycopy(clTypesArray, 0, clTypesArrayAll, 1, clTypesArray.length);
                    Object[] inParamsArrayAll = new Object[objectArray.length + 1];
                    inParamsArrayAll[0] = this._query;
                    System.arraycopy(objectArray, 0, inParamsArrayAll, 1, objectArray.length);
                    try {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Creating boost query with parameters: {}", (Object)Arrays.toString(inParamsArrayAll));
                        }
                        Constructor<?> c = boostClass.getConstructor(clTypesArrayAll);
                        this._query = (Query)c.newInstance(inParamsArrayAll);
                    }
                    catch (Exception e) {
                        LOGGER.warn(" Failed to create boosting query: {}. Check Lucene configuration", (Object)e.getMessage(), (Object)e);
                    }
                }
                catch (Exception e1) {
                    LOGGER.warn(" Error on boosting query initialization: {}. Check Lucene configuration", (Object)e1.getMessage(), (Object)e1);
                }
            }
        }
        Collection<Geometry> geometry = this.getGeometry(srvContext, request);
        SpatialFilter spatialfilter = null;
        if (geometry != null) {
            StringBuilder wkt = new StringBuilder();
            for (Geometry geom : geometry) {
                wkt.append("geom:").append(geom.toText()).append("\n");
            }
            this._geomWKT = wkt.toString();
            spatialfilter = this._sm.getSpatial().filter(this._query, Integer.MAX_VALUE, geometry, request);
        }
        DuplicateDocFilter duplicateRemovingFilter = new DuplicateDocFilter(this._query);
        if (spatialfilter == null) {
            filter = duplicateRemovingFilter;
        } else {
            Filter[] filters = new Filter[]{duplicateRemovingFilter, spatialfilter};
            filter = new ChainedFilter(filters, 1);
        }
        this._filter = new CachingWrapperFilter((Filter)filter);
        String sortBy = Util.getParam((Element)request, (String)"sortBy", (String)"relevance");
        boolean sortOrder = Util.getParam((Element)request, (String)"sortOrder", (String)"").equals("");
        LOGGER.debug("Sorting by : {}", (Object)sortBy);
        SettingInfo settingInfo = this._sm.getSettingInfo();
        boolean sortRequestedLanguageOnTop = settingInfo.getRequestedLanguageOnTop();
        LOGGER.debug("sortRequestedLanguageOnTop: {}", (Object)sortRequestedLanguageOnTop);
        this._sort = LuceneSearcher.makeSort(Collections.singletonList(Pair.read((Object)sortBy, (Object)sortOrder)), this._language.presentationLanguage, sortRequestedLanguageOnTop);
    }

    public static Query appendPortalFilter(Query q, LuceneConfig luceneConfig) throws ParseException, QueryNodeException {
        NodeInfo node = (NodeInfo)ApplicationContextHolder.get().getBean(NodeInfo.class);
        SourceRepository sourceRepository = (SourceRepository)ApplicationContextHolder.get().getBean(SourceRepository.class);
        if (node != null && !"srv".equals(node.getId())) {
            Source portal = (Source)sourceRepository.findOne((Serializable)((Object)node.getId()));
            if (portal == null) {
                LOGGER.warn("Null portal " + node);
            } else if (StringUtils.isNotEmpty((String)portal.getFilter())) {
                Query portalFilterQuery = null;
                portalFilterQuery = LuceneSearcher.parseLuceneQuery(portal.getFilter(), luceneConfig);
                LOGGER.info("Portal filter is :\n" + portalFilterQuery);
                BooleanQuery query = new BooleanQuery();
                BooleanClause.Occur occur = LuceneUtils.convertRequiredAndProhibitedToOccur(true, false);
                query.add(q, occur);
                if (portalFilterQuery != null) {
                    query.add(portalFilterQuery, occur);
                }
                q = query;
                LOGGER.debug("Lucene query (with portal filter): {}", (Object)q);
            }
        }
        return q;
    }

    private void processTimeRange(Element fromTime, String defaultFromTime, Element toTime, String defaultToTime) {
        if (fromTime != null && toTime != null) {
            if (fromTime.getTextTrim().equals("") && toTime.getTextTrim().equals("")) {
                fromTime.detach();
                toTime.detach();
            } else {
                if (fromTime.getTextTrim().equals("")) {
                    fromTime.setText(defaultFromTime);
                } else if (toTime.getTextTrim().equals("")) {
                    toTime.setText(defaultToTime);
                }
                String newFromTime = ISODate.parseISODateTime((String)fromTime.getText());
                fromTime.setText(newFromTime);
                String newToTime = ISODate.parseISODateTime((String)toTime.getText());
                toTime.setText(newToTime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TopDocs performQuery(ServiceContext context, int startHit, int endHit, boolean buildSummary) throws Exception {
        Pair<TopDocs, Element> results;
        IndexAndTaxonomy indexAndTaxonomy = this._sm.getIndexReader(this._language.presentationLanguage, this._versionToken);
        this._versionToken = indexAndTaxonomy.version;
        try {
            results = LuceneSearcher.doSearchAndMakeSummary(endHit, startHit, endHit, this._language.presentationLanguage, this._summaryConfig, this._luceneConfig, (IndexReader)indexAndTaxonomy.indexReader, this._query, this._filter, this._sort, indexAndTaxonomy.taxonomyReader, buildSummary);
        }
        finally {
            this._sm.releaseIndexReader(indexAndTaxonomy);
        }
        TopDocs hits = (TopDocs)results.one();
        this._elSummary = (Element)results.two();
        this._numHits = Integer.parseInt(this._elSummary.getAttributeValue("count"));
        LOGGER.debug("Hits found : {}", (Object)this._numHits);
        return hits;
    }

    private Collection<Geometry> getGeometry(ServiceContext context, Element request) throws Exception {
        String geomWKT = Util.getParam((Element)request, (String)"geometry", null);
        String prefix = "region:";
        if (StringUtils.startsWithIgnoreCase((String)geomWKT, (String)"region:")) {
            boolean isWithinFilter = "within".equalsIgnoreCase(Util.getParam((Element)request, (String)"relation", null));
            Collection regionDAOs = context.getApplicationContext().getBeansOfType(RegionsDAO.class).values();
            if (regionDAOs.isEmpty()) {
                throw new IllegalArgumentException("Found search with a regions geometry prefix but no RegionsDAO objects are registered!\nThis is probably a configuration error.  Make sure the RegionsDAO objects are registered in spring");
            }
            String[] regionIds = geomWKT.substring("region:".length()).split("\\s*,\\s*");
            Geometry unionedGeom = null;
            ArrayList<Geometry> foundGeometries = new ArrayList<Geometry>();
            block0: for (String regionId : regionIds) {
                if (regionId.startsWith("region:")) {
                    regionId = regionId.substring(0, "region:".length());
                }
                for (RegionsDAO dao : regionDAOs) {
                    Geometry geom = dao.getGeom(context, regionId, false, Region.WGS84);
                    if (geom == null) continue;
                    foundGeometries.add(geom);
                    if (!isWithinFilter) continue block0;
                    if (unionedGeom == null) {
                        unionedGeom = geom;
                        continue block0;
                    }
                    unionedGeom = unionedGeom.union(geom);
                    continue block0;
                }
            }
            if (regionIds.length > 1 && isWithinFilter) {
                foundGeometries.add(0, unionedGeom);
            }
            if (foundGeometries.size() == 0) {
                throw new IllegalArgumentException(String.format("Geometry %s not found in the available source RegionDAO objects", geomWKT));
            }
            return foundGeometries;
        }
        if (geomWKT != null) {
            WKTReader reader = new WKTReader();
            return Arrays.asList(reader.read(geomWKT));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getAllUuids(int maxHits, ServiceContext context) throws Exception {
        ArrayList<String> response = new ArrayList<String>();
        TopDocs tdocs = this.performQuery(context, 0, maxHits, false);
        IndexAndTaxonomy indexAndTaxonomy = this._sm.getIndexReader(this._language.presentationLanguage, this._versionToken);
        this._versionToken = indexAndTaxonomy.version;
        try {
            for (ScoreDoc sdoc : tdocs.scoreDocs) {
                DocumentStoredFieldVisitor docVisitor = new DocumentStoredFieldVisitor(new String[]{"_uuid"});
                indexAndTaxonomy.indexReader.document(sdoc.doc, (StoredFieldVisitor)docVisitor);
                org.apache.lucene.document.Document doc = docVisitor.getDocument();
                String uuid = doc.get("_uuid");
                if (uuid == null) continue;
                response.add(uuid);
            }
        }
        finally {
            this._sm.releaseIndexReader(indexAndTaxonomy);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, AbstractMetadata> getAllMdInfo(ServiceContext context, int maxHits) throws Exception {
        HashMap<Integer, AbstractMetadata> response = new HashMap<Integer, AbstractMetadata>();
        TopDocs tdocs = this.performQuery(context, 0, maxHits, false);
        IndexAndTaxonomy indexAndTaxonomy = this._sm.getIndexReader(this._language.presentationLanguage, this._versionToken);
        this._versionToken = indexAndTaxonomy.version;
        try {
            for (ScoreDoc sdoc : tdocs.scoreDocs) {
                DocumentStoredFieldVisitor docVisitor = new DocumentStoredFieldVisitor(new String[]{"_id", "_root", "_schema", "_createDate", "_changeDate", "_source", "_isTemplate", "_title", "_uuid", "_isHarvested", "_owner", "_groupOwner"});
                indexAndTaxonomy.indexReader.document(sdoc.doc, (StoredFieldVisitor)docVisitor);
                org.apache.lucene.document.Document doc = docVisitor.getDocument();
                Metadata mdInfo = Metadata.createFromLuceneIndexDocument((org.apache.lucene.document.Document)doc);
                response.put(mdInfo.getId(), (AbstractMetadata)mdInfo);
            }
        }
        finally {
            this._sm.releaseIndexReader(indexAndTaxonomy);
        }
        return response;
    }

    @Override
    public long getVersionToken() {
        return this._versionToken;
    }

    public static Query parseLuceneQuery(String cswServiceSpecificConstraint, LuceneConfig _luceneConfig) throws ParseException, QueryNodeException {
        StandardQueryParser parser = new StandardQueryParser((Analyzer)SearchManager.getAnalyzer());
        HashMap<String, NumericConfig> numericMap = new HashMap<String, NumericConfig>();
        for (LuceneConfig.LuceneConfigNumericField field : _luceneConfig.getNumericFields().values()) {
            String name = field.getName();
            int precisionStep = field.getPrecisionStep();
            NumberFormat format = NumberFormat.getNumberInstance();
            FieldType.NumericType type = FieldType.NumericType.valueOf((String)field.getType().toUpperCase());
            NumericConfig config = new NumericConfig(precisionStep, format, type);
            numericMap.put(name, config);
        }
        parser.setNumericConfigMap(numericMap);
        Query q = parser.parse(cswServiceSpecificConstraint, "title");
        List<String> SECURITY_FIELDS = Arrays.asList("_owner");
        if (q instanceof BooleanQuery) {
            BooleanQuery bq = (BooleanQuery)q;
            List clauses = bq.clauses();
            Iterator it = clauses.iterator();
            block1: while (it.hasNext()) {
                BooleanClause bc = (BooleanClause)it.next();
                for (String fieldName : SECURITY_FIELDS) {
                    if (!bc.getQuery().toString().contains(fieldName + ":")) continue;
                    if (Log.isDebugEnabled((String)"geonetwork.csw.search")) {
                        Log.debug((String)"geonetwork.csw.search", (Object)("LuceneSearcher getCswServiceSpecificConstraintQuery removed security field: " + fieldName));
                    }
                    it.remove();
                    continue block1;
                }
            }
        }
        return q;
    }

    public static class LanguageSelection {
        public final String analyzerLanguage;
        public final String presentationLanguage;

        public LanguageSelection(String analyzerLanguage, String presentationLanguage) {
            this.analyzerLanguage = analyzerLanguage;
            this.presentationLanguage = presentationLanguage;
        }
    }
}

