/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.io.ISVNDeltaConsumer;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.diff.SVNDeltaGenerator;

public class SvnUtils {
    public static void addDir(ISVNEditor editor, String dirPath) throws SVNException {
        editor.addDir(dirPath, null, -1L);
        editor.closeDir();
    }

    public static void addFile(ISVNEditor editor, String filePath, byte[] data) throws SVNException {
        editor.addFile(filePath, null, -1L);
        editor.applyTextDelta(filePath, null);
        SVNDeltaGenerator deltaGenerator = new SVNDeltaGenerator();
        String checksum = deltaGenerator.sendDelta(filePath, (InputStream)new ByteArrayInputStream(data), (ISVNDeltaConsumer)editor, true);
        editor.closeFile(filePath, checksum);
    }

    public static void modifyFileProps(ISVNEditor editor, String filePath, Map<String, String> props) throws SVNException {
        for (Map.Entry<String, String> entry : props.entrySet()) {
            String propertyValue = entry.getValue();
            editor.changeFileProperty(filePath, entry.getKey(), SVNPropertyValue.create((String)propertyValue));
        }
    }

    public static void modifyFile(ISVNEditor editor, String filePath, byte[] oldData, byte[] newData) throws SVNException {
        editor.applyTextDelta(filePath, null);
        SVNDeltaGenerator deltaGenerator = new SVNDeltaGenerator();
        deltaGenerator.sendDelta(filePath, (InputStream)new ByteArrayInputStream(oldData), 0L, (InputStream)new ByteArrayInputStream(newData), (ISVNDeltaConsumer)editor, true);
    }

    public static void deleteDir(ISVNEditor editor, String dirPath) throws SVNException {
        editor.openRoot(-1L);
        editor.deleteEntry(dirPath, -1L);
        editor.closeDir();
    }
}

