/*
 * Decompiled with CFR 0.152.
 */
package jeeves.server.overrides;

import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import jeeves.server.overrides.AddInterceptUrlUpdater;
import jeeves.server.overrides.PropertyUpdater;
import jeeves.server.overrides.RemoveInterceptUrlUpdater;
import jeeves.server.overrides.SetInterceptUrlUpdater;
import jeeves.server.overrides.Updater;
import org.jdom.Element;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

public class SpringPropertyOverrides {
    List<Updater> updaters = new LinkedList<Updater>();
    private Properties properties;

    public SpringPropertyOverrides(List<Element> springOverrides, Properties properties) {
        this.properties = properties;
        for (Element element : springOverrides) {
            Updater updater = this.create(element);
            this.updaters.add(updater);
        }
    }

    public void onFinishedRefresh(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        for (Updater updater : this.updaters) {
            if (!updater.runOnFinish()) continue;
            updater.update(beanFactory, this.properties);
        }
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        for (Updater updater : this.updaters) {
            if (updater.runOnFinish()) continue;
            updater.update(beanFactory, this.properties);
        }
    }

    Updater create(Element element) {
        if ("set".equalsIgnoreCase(element.getName()) || "add".equalsIgnoreCase(element.getName())) {
            return PropertyUpdater.create(element);
        }
        if ("addInterceptUrl".equalsIgnoreCase(element.getName())) {
            return new AddInterceptUrlUpdater(element);
        }
        if ("removeInterceptUrl".equalsIgnoreCase(element.getName())) {
            return new RemoveInterceptUrlUpdater(element);
        }
        if ("SetInterceptUrl".equalsIgnoreCase(element.getName())) {
            return new SetInterceptUrlUpdater(element);
        }
        throw new IllegalArgumentException(element.getName() + " is not known type of updater");
    }
}

