/*
 * Decompiled with CFR 0.152.
 */
package jeeves.server;

import java.util.Hashtable;
import javax.servlet.http.HttpSession;
import org.fao.geonet.domain.LDAPUser;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.User;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextImpl;

public class UserSession {
    private Hashtable<String, Object> htProperties = new Hashtable(10, 0.75f);
    private HttpSession sHttpSession;

    public HttpSession getsHttpSession() {
        return this.sHttpSession;
    }

    public void setsHttpSession(HttpSession sHttpSession) {
        this.sHttpSession = sHttpSession;
    }

    public void setProperty(String name, Object value) {
        this.htProperties.put(name, value);
    }

    public Object getProperty(String name) {
        return this.htProperties.get(name);
    }

    public void removeProperty(String name) {
        this.htProperties.remove(name);
    }

    public void clear() {
        this.htProperties.clear();
        SecurityContextHolder.clearContext();
        if (this.sHttpSession != null) {
            this.sHttpSession.invalidate();
        }
    }

    public void loginAs(User user) {
        SecurityContextImpl secContext = new SecurityContextImpl();
        UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)user, null);
        secContext.setAuthentication((Authentication)authentication);
        SecurityContextHolder.setContext((SecurityContext)secContext);
    }

    public boolean isAuthenticated() {
        return !(this.auth() instanceof AnonymousAuthenticationToken);
    }

    public String getUserId() {
        User userDetails = this.getPrincipal();
        if (userDetails == null) {
            return null;
        }
        return String.valueOf(userDetails.getId());
    }

    public String getUsername() {
        User userDetails = this.getPrincipal();
        if (userDetails == null) {
            return null;
        }
        return userDetails.getUsername();
    }

    public String getName() {
        User userDetails = this.getPrincipal();
        if (userDetails == null) {
            return null;
        }
        return userDetails.getName();
    }

    public String getSurname() {
        User userDetails = this.getPrincipal();
        if (userDetails == null) {
            return null;
        }
        return userDetails.getSurname();
    }

    public Profile getProfile() {
        User userDetails = this.getPrincipal();
        if (userDetails == null) {
            return null;
        }
        return userDetails.getProfile();
    }

    public String getEmailAddr() {
        User userDetails = this.getPrincipal();
        if (userDetails == null) {
            return null;
        }
        return userDetails.getEmail();
    }

    public String getOrganisation() {
        User userDetails = this.getPrincipal();
        if (userDetails == null) {
            return null;
        }
        return userDetails.getOrganisation();
    }

    public int getUserIdAsInt() {
        String id = this.getUserId();
        return id == null ? -1 : Integer.parseInt(this.getUserId());
    }

    private SecurityContext secContext() {
        return SecurityContextHolder.getContext();
    }

    private Authentication auth() {
        SecurityContext secContext = this.secContext();
        if (secContext == null) {
            return null;
        }
        Authentication authentication = secContext.getAuthentication();
        return authentication;
    }

    public User getPrincipal() {
        Authentication auth = this.auth();
        if (auth != null) {
            if (auth.getPrincipal() instanceof User) {
                return (User)auth.getPrincipal();
            }
            if (auth.getPrincipal() instanceof LDAPUser) {
                return ((LDAPUser)auth.getPrincipal()).getUser();
            }
        }
        return null;
    }
}

