/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.cluster;

import com.google.common.base.Preconditions;
import io.searchbox.action.AbstractMultiIndexActionBuilder;
import io.searchbox.action.GenericResultAbstractAction;
import io.searchbox.client.config.ElasticsearchVersion;
import io.searchbox.strings.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class Health
extends GenericResultAbstractAction {
    protected Health(Builder builder) {
        super(builder);
    }

    @Override
    protected String buildURI(ElasticsearchVersion elasticsearchVersion) {
        StringBuilder sb = new StringBuilder("/_cluster/health/");
        try {
            if (StringUtils.isNotBlank(this.indexName)) {
                sb.append(URLEncoder.encode(this.indexName, CHARSET));
            }
        }
        catch (UnsupportedEncodingException e) {
            log.error("Error occurred while adding index to uri", (Throwable)e);
        }
        return sb.toString();
    }

    @Override
    public String getRestMethodName() {
        return "GET";
    }

    public static class Builder
    extends AbstractMultiIndexActionBuilder<Health, Builder> {
        public Builder waitForNoRelocatingShards() {
            return this.waitForNoRelocatingShards(true);
        }

        public Builder waitForNoRelocatingShards(boolean wait) {
            return (Builder)this.setParameter("wait_for_no_relocating_shards", wait);
        }

        public Builder waitForStatus(Status status) {
            return this.waitForStatus(status.getKey());
        }

        private Builder waitForStatus(String status) {
            return (Builder)this.setParameter("wait_for_status", status);
        }

        public Builder level(Level level) {
            return this.level(level.getKey());
        }

        private Builder level(String level) {
            return (Builder)this.setParameter("level", level);
        }

        public Builder local(boolean local) {
            return (Builder)this.setParameter("local", local);
        }

        public Builder local() {
            return this.local(true);
        }

        public Builder timeout(int seconds) {
            Preconditions.checkArgument((seconds >= 0 ? 1 : 0) != 0, (Object)"seconds must not be negative");
            return (Builder)this.setParameter("timeout", seconds + "s");
        }

        @Override
        public Health build() {
            return new Health(this);
        }
    }

    public static enum Level {
        CLUSTER("cluster"),
        INDICES("indices"),
        SHARDS("shards");

        private final String key;

        private Level(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }

    public static enum Status {
        RED("red"),
        YELLOW("yellow"),
        GREEN("green");

        private final String key;

        private Status(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

