/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.DataFlowAnalysis;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.LinkedFlowScope;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TypeCheck;
import com.google.javascript.jscomp.TypeTransformation;
import com.google.javascript.jscomp.TypedScope;
import com.google.javascript.jscomp.TypedVar;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.jscomp.type.FlowScope;
import com.google.javascript.jscomp.type.ReverseAbstractInterpreter;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.BooleanLiteralSet;
import com.google.javascript.rhino.jstype.FunctionBuilder;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ModificationVisitor;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.StaticTypedSlot;
import com.google.javascript.rhino.jstype.TemplateType;
import com.google.javascript.rhino.jstype.TemplateTypeMap;
import com.google.javascript.rhino.jstype.TemplateTypeMapReplacer;
import com.google.javascript.rhino.jstype.UnionType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class TypeInference
extends DataFlowAnalysis.BranchedForwardDataFlowAnalysis<Node, FlowScope> {
    static final DiagnosticType FUNCTION_LITERAL_UNDEFINED_THIS = DiagnosticType.warning("JSC_FUNCTION_LITERAL_UNDEFINED_THIS", "Function literal argument refers to undefined this argument");
    private final AbstractCompiler compiler;
    private final JSTypeRegistry registry;
    private final ReverseAbstractInterpreter reverseInterpreter;
    private final TypedScope syntacticScope;
    private final FlowScope functionScope;
    private final FlowScope bottomScope;
    private final Map<String, CodingConvention.AssertionFunctionSpec> assertionFunctionsMap;
    private final ObjectType unknownType;

    TypeInference(AbstractCompiler compiler, ControlFlowGraph<Node> cfg, ReverseAbstractInterpreter reverseInterpreter, TypedScope functionScope, Map<String, CodingConvention.AssertionFunctionSpec> assertionFunctionsMap) {
        super(cfg, new LinkedFlowScope.FlowScopeJoinOp());
        this.compiler = compiler;
        this.registry = compiler.getTypeRegistry();
        this.reverseInterpreter = reverseInterpreter;
        this.unknownType = this.registry.getNativeObjectType(JSTypeNative.UNKNOWN_TYPE);
        this.syntacticScope = functionScope;
        this.inferArguments(functionScope);
        this.functionScope = LinkedFlowScope.createEntryLattice(functionScope);
        this.assertionFunctionsMap = assertionFunctionsMap;
        Iterator<TypedVar> varIt = functionScope.getDeclarativelyUnboundVarsWithoutTypes();
        while (varIt.hasNext()) {
            TypedVar var = varIt.next();
            if (this.isUnflowable(var)) continue;
            this.functionScope.inferSlotType(var.getName(), this.getNativeType(JSTypeNative.VOID_TYPE));
        }
        this.bottomScope = LinkedFlowScope.createEntryLattice(TypedScope.createLatticeBottom(functionScope.getRootNode()));
    }

    private void inferArguments(TypedScope functionScope) {
        Node parameterTypes;
        FunctionType functionType;
        Node functionNode = functionScope.getRootNode();
        Node astParameters = functionNode.getFirstChild().getNext();
        Node iifeArgumentNode = null;
        if (NodeUtil.isCallOrNewTarget(functionNode)) {
            iifeArgumentNode = functionNode.getNext();
        }
        if ((functionType = JSType.toMaybeFunctionType(functionNode.getJSType())) != null && (parameterTypes = functionType.getParametersNode()) != null) {
            Node parameterTypeNode = parameterTypes.getFirstChild();
            for (Node astParameter : astParameters.children()) {
                TypedVar var = functionScope.getVar(astParameter.getString());
                Preconditions.checkNotNull((Object)var);
                if (var.isTypeInferred() && var.getType() == this.unknownType) {
                    JSType newType = null;
                    if (iifeArgumentNode != null) {
                        newType = iifeArgumentNode.getJSType();
                    } else if (parameterTypeNode != null) {
                        newType = parameterTypeNode.getJSType();
                    }
                    if (newType != null) {
                        var.setType(newType);
                        astParameter.setJSType(newType);
                    }
                }
                if (parameterTypeNode != null) {
                    parameterTypeNode = parameterTypeNode.getNext();
                }
                if (iifeArgumentNode == null) continue;
                iifeArgumentNode = iifeArgumentNode.getNext();
            }
        }
    }

    @Override
    FlowScope createInitialEstimateLattice() {
        return this.bottomScope;
    }

    @Override
    FlowScope createEntryLattice() {
        return this.functionScope;
    }

    @Override
    FlowScope flowThrough(Node n, FlowScope input) {
        if (input == this.bottomScope) {
            return input;
        }
        FlowScope output = input.createChildFlowScope();
        output = this.traverse(n, output);
        return output;
    }

    @Override
    List<FlowScope> branchedFlowThrough(Node source, FlowScope input) {
        FlowScope output = this.flowThrough(source, input);
        Node condition = null;
        FlowScope conditionFlowScope = null;
        BooleanOutcomePair conditionOutcomes = null;
        List branchEdges = this.getCfg().getOutEdges(source);
        ArrayList<FlowScope> result = new ArrayList<FlowScope>(branchEdges.size());
        for (DiGraph.DiGraphEdge branchEdge : branchEdges) {
            ControlFlowGraph.Branch branch = (ControlFlowGraph.Branch)((Object)branchEdge.getValue());
            FlowScope newScope = output;
            switch (branch) {
                case ON_TRUE: {
                    if (NodeUtil.isForIn(source)) {
                        Node item = source.getFirstChild();
                        Node obj = item.getNext();
                        FlowScope informed = this.traverse(obj, output.createChildFlowScope());
                        if (item.isVar()) {
                            item = item.getFirstChild();
                        }
                        if (item.isName()) {
                            JSType narrowedKeyType;
                            JSType objIndexType;
                            JSType iterKeyType = this.getNativeType(JSTypeNative.STRING_TYPE);
                            ObjectType objType = this.getJSType(obj).dereference();
                            JSType jSType = objIndexType = objType == null ? null : objType.getTemplateTypeMap().getTemplateType(this.registry.getObjectIndexKey());
                            if (objIndexType != null && !objIndexType.isUnknownType() && !(narrowedKeyType = iterKeyType.getGreatestSubtype(objIndexType)).isEmptyType()) {
                                iterKeyType = narrowedKeyType;
                            }
                            this.redeclareSimpleVar(informed, item, iterKeyType);
                        }
                        newScope = informed;
                        break;
                    }
                }
                case ON_FALSE: {
                    if (condition == null && (condition = NodeUtil.getConditionExpression(source)) == null && source.isCase()) {
                        condition = source;
                        if (conditionFlowScope == null) {
                            conditionFlowScope = this.traverse(condition.getFirstChild(), output.createChildFlowScope());
                        }
                    }
                    if (condition == null) break;
                    if (condition.isAnd() || condition.isOr()) {
                        if (conditionOutcomes == null) {
                            conditionOutcomes = condition.isAnd() ? this.traverseAnd(condition, output.createChildFlowScope()) : this.traverseOr(condition, output.createChildFlowScope());
                        }
                        newScope = this.reverseInterpreter.getPreciserScopeKnowingConditionOutcome(condition, conditionOutcomes.getOutcomeFlowScope(condition.getType(), branch == ControlFlowGraph.Branch.ON_TRUE), branch == ControlFlowGraph.Branch.ON_TRUE);
                        break;
                    }
                    if (conditionFlowScope == null) {
                        conditionFlowScope = this.traverse(condition, output.createChildFlowScope());
                    }
                    newScope = this.reverseInterpreter.getPreciserScopeKnowingConditionOutcome(condition, conditionFlowScope, branch == ControlFlowGraph.Branch.ON_TRUE);
                }
            }
            result.add(newScope.optimize());
        }
        return result;
    }

    private FlowScope traverse(Node n, FlowScope scope) {
        switch (n.getType()) {
            case 86: {
                scope = this.traverseAssign(n, scope);
                break;
            }
            case 38: {
                scope = this.traverseName(n, scope);
                break;
            }
            case 33: {
                scope = this.traverseGetProp(n, scope);
                break;
            }
            case 101: {
                scope = this.traverseAnd(n, scope).getJoinedFlowScope().createChildFlowScope();
                break;
            }
            case 100: {
                scope = this.traverseOr(n, scope).getJoinedFlowScope().createChildFlowScope();
                break;
            }
            case 98: {
                scope = this.traverseHook(n, scope);
                break;
            }
            case 64: {
                scope = this.traverseObjectLiteral(n, scope);
                break;
            }
            case 37: {
                scope = this.traverseCall(n, scope);
                break;
            }
            case 30: {
                scope = this.traverseNew(n, scope);
                break;
            }
            case 21: 
            case 93: {
                scope = this.traverseAdd(n, scope);
                break;
            }
            case 28: 
            case 29: {
                scope = this.traverse(n.getFirstChild(), scope);
                n.setJSType(this.getNativeType(JSTypeNative.NUMBER_TYPE));
                break;
            }
            case 63: {
                scope = this.traverseArrayLiteral(n, scope);
                break;
            }
            case 42: {
                n.setJSType((JSType)scope.getTypeOfThis());
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 102: 
            case 103: {
                scope = this.traverseChildren(n, scope);
                n.setJSType(this.getNativeType(JSTypeNative.NUMBER_TYPE));
                break;
            }
            case 83: {
                scope = this.traverse(n.getFirstChild(), scope);
                n.setJSType(this.getJSType(n.getFirstChild()));
                break;
            }
            case 85: {
                scope = this.traverseChildren(n, scope);
                n.setJSType(this.getJSType(n.getLastChild()));
                break;
            }
            case 32: {
                scope = this.traverseChildren(n, scope);
                n.setJSType(this.getNativeType(JSTypeNative.STRING_TYPE));
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 26: 
            case 31: 
            case 45: 
            case 46: 
            case 51: 
            case 52: {
                scope = this.traverseChildren(n, scope);
                n.setJSType(this.getNativeType(JSTypeNative.BOOLEAN_TYPE));
                break;
            }
            case 35: {
                scope = this.traverseGetElem(n, scope);
                break;
            }
            case 130: {
                scope = this.traverseChildren(n, scope);
                if (!n.getFirstChild().isGetProp()) break;
                this.ensurePropertyDeclared(n.getFirstChild());
                break;
            }
            case 110: {
                scope = this.traverse(n.getFirstChild(), scope);
                break;
            }
            case 4: {
                scope = this.traverseReturn(n, scope);
                break;
            }
            case 49: 
            case 118: {
                scope = this.traverseChildren(n, scope);
                break;
            }
            case 120: {
                scope = this.traverseCatch(n, scope);
                break;
            }
            case 155: {
                scope = this.traverseChildren(n, scope);
                JSDocInfo info = n.getJSDocInfo();
                if (info == null || !info.hasType()) break;
                n.setJSType(info.getType().evaluate(this.syntacticScope, this.registry));
            }
        }
        return scope;
    }

    private FlowScope traverseReturn(Node n, FlowScope scope) {
        FunctionType fnType;
        JSType type;
        scope = this.traverseChildren(n, scope);
        Node retValue = n.getFirstChild();
        if (retValue != null && (type = this.functionScope.getRootNode().getJSType()) != null && (fnType = type.toMaybeFunctionType()) != null) {
            TypeInference.inferPropertyTypesToMatchConstraint(retValue.getJSType(), fnType.getReturnType());
        }
        return scope;
    }

    private FlowScope traverseCatch(Node catchNode, FlowScope scope) {
        Node name = catchNode.getFirstChild();
        JSDocInfo info = name.getJSDocInfo();
        JSType type = info != null && info.hasType() ? info.getType().evaluate(this.syntacticScope, this.registry) : this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        this.redeclareSimpleVar(scope, name, type);
        name.setJSType(type);
        return scope;
    }

    private FlowScope traverseAssign(Node n, FlowScope scope) {
        Node left = n.getFirstChild();
        Node right = n.getLastChild();
        scope = this.traverseChildren(n, scope);
        JSType leftType = left.getJSType();
        JSType rightType = this.getJSType(right);
        n.setJSType(rightType);
        this.updateScopeForTypeChange(scope, left, leftType, rightType);
        return scope;
    }

    private void updateScopeForTypeChange(FlowScope scope, Node left, JSType leftType, JSType resultType) {
        Preconditions.checkNotNull((Object)resultType);
        switch (left.getType()) {
            case 38: {
                boolean isVarTypeBetter;
                String varName = left.getString();
                TypedVar var = this.syntacticScope.getVar(varName);
                JSType varType = var == null ? null : var.getType();
                boolean isVarDeclaration = left.hasChildren() && varType != null && !var.isTypeInferred();
                boolean isTypelessConstDecl = isVarDeclaration && NodeUtil.isConstantDeclaration(this.compiler.getCodingConvention(), var.getJSDocInfo(), var.getNameNode()) && (var.getJSDocInfo() == null || !var.getJSDocInfo().hasType());
                boolean bl = isVarTypeBetter = isVarDeclaration && !resultType.isNullType() && !resultType.isVoidType() && !isTypelessConstDecl;
                if (isVarTypeBetter) {
                    this.redeclareSimpleVar(scope, left, varType);
                } else {
                    this.redeclareSimpleVar(scope, left, resultType);
                }
                left.setJSType(resultType);
                if (var != null && var.isTypeInferred()) {
                    JSType oldType = var.getType();
                    var.setType(oldType == null ? resultType : oldType.getLeastSupertype(resultType));
                    break;
                }
                if (!isTypelessConstDecl) break;
                var.setType(resultType);
                break;
            }
            case 33: {
                String qualifiedName = left.getQualifiedName();
                if (qualifiedName != null) {
                    ObjectType objType;
                    boolean declaredSlotType = false;
                    JSType rawObjType = left.getFirstChild().getJSType();
                    if (rawObjType != null && (objType = ObjectType.cast(rawObjType.restrictByNotNullOrUndefined())) != null) {
                        String propName = left.getLastChild().getString();
                        declaredSlotType = objType.isPropertyTypeDeclared(propName);
                    }
                    JSType safeLeftType = leftType == null ? this.unknownType : leftType;
                    scope.inferQualifiedSlot(left, qualifiedName, safeLeftType, resultType, declaredSlotType);
                }
                left.setJSType(resultType);
                this.ensurePropertyDefined(left, resultType);
            }
        }
    }

    private void ensurePropertyDefined(Node getprop, JSType rightType) {
        boolean propCreationInConstructor;
        String propName = getprop.getLastChild().getString();
        Node obj = getprop.getFirstChild();
        JSType nodeType = this.getJSType(obj);
        ObjectType objectType = ObjectType.cast(nodeType.restrictByNotNullOrUndefined());
        boolean bl = propCreationInConstructor = obj.isThis() && this.getJSType(this.syntacticScope.getRootNode()).isConstructor();
        if (objectType == null) {
            this.registry.registerPropertyOnType(propName, nodeType);
        } else {
            if (nodeType.isStruct() && !objectType.hasProperty(propName)) {
                boolean staticPropCreation = false;
                Node maybeAssignStm = getprop.getParent().getParent();
                if (this.syntacticScope.isGlobal() && NodeUtil.isPrototypePropertyDeclaration(maybeAssignStm)) {
                    String propCreationFilename = maybeAssignStm.getSourceFileName();
                    Node ctor = objectType.getOwnerFunction().getSource();
                    if (ctor != null && ctor.getSourceFileName().equals(propCreationFilename)) {
                        staticPropCreation = true;
                    }
                }
                if (!propCreationInConstructor && !staticPropCreation) {
                    return;
                }
            }
            if (this.ensurePropertyDeclaredHelper(getprop, objectType)) {
                return;
            }
            if (!objectType.isPropertyTypeDeclared(propName)) {
                if (objectType.hasProperty(propName) || !objectType.isInstanceType()) {
                    if ("prototype".equals(propName)) {
                        objectType.defineDeclaredProperty(propName, rightType, getprop);
                    } else {
                        objectType.defineInferredProperty(propName, rightType, getprop);
                    }
                } else if (propCreationInConstructor) {
                    objectType.defineInferredProperty(propName, rightType, getprop);
                } else {
                    this.registry.registerPropertyOnType(propName, objectType);
                }
            }
        }
    }

    private void ensurePropertyDeclared(Node getprop) {
        ObjectType ownerType = ObjectType.cast(this.getJSType(getprop.getFirstChild()).restrictByNotNullOrUndefined());
        if (ownerType != null) {
            this.ensurePropertyDeclaredHelper(getprop, ownerType);
        }
    }

    private boolean ensurePropertyDeclaredHelper(Node getprop, ObjectType objectType) {
        TypedVar var;
        String propName = getprop.getLastChild().getString();
        String qName = getprop.getQualifiedName();
        if (qName != null && (var = this.syntacticScope.getVar(qName)) != null && !var.isTypeInferred() && (propName.equals("prototype") || !objectType.hasOwnProperty(propName) && (!objectType.isInstanceType() || var.isExtern() && !objectType.isNativeObjectType()))) {
            return objectType.defineDeclaredProperty(propName, var.getType(), getprop);
        }
        return false;
    }

    private FlowScope traverseName(Node n, FlowScope scope) {
        String varName = n.getString();
        Node value = n.getFirstChild();
        JSType type = n.getJSType();
        if (value != null) {
            scope = this.traverse(value, scope);
            this.updateScopeForTypeChange(scope, n, n.getJSType(), this.getJSType(value));
            return scope;
        }
        StaticTypedSlot var = scope.getSlot(varName);
        if (var != null) {
            TypedVar maybeOuterVar;
            boolean isInferred = var.isTypeInferred();
            boolean unflowable = isInferred && this.isUnflowable(this.syntacticScope.getVar(varName));
            boolean nonLocalInferredSlot = false;
            if (isInferred && this.syntacticScope.isLocal() && var == (maybeOuterVar = this.syntacticScope.getParent().getVar(varName)) && !maybeOuterVar.isMarkedAssignedExactlyOnce()) {
                nonLocalInferredSlot = true;
            }
            if (!unflowable && !nonLocalInferredSlot && (type = (JSType)var.getType()) == null) {
                type = this.unknownType;
            }
        }
        n.setJSType(type);
        return scope;
    }

    private FlowScope traverseArrayLiteral(Node n, FlowScope scope) {
        scope = this.traverseChildren(n, scope);
        n.setJSType(this.getNativeType(JSTypeNative.ARRAY_TYPE));
        return scope;
    }

    private FlowScope traverseObjectLiteral(Node n, FlowScope scope) {
        JSType type = n.getJSType();
        Preconditions.checkNotNull((Object)type);
        for (Node name = n.getFirstChild(); name != null; name = name.getNext()) {
            scope = this.traverse(name.getFirstChild(), scope);
        }
        ObjectType objectType = ObjectType.cast(type);
        if (objectType == null || n.getBooleanProp(57) || objectType.isEnumType()) {
            return scope;
        }
        String qObjName = NodeUtil.getBestLValueName(NodeUtil.getBestLValue(n));
        for (Node name = n.getFirstChild(); name != null; name = name.getNext()) {
            String memberName = NodeUtil.getObjectLitKeyName(name);
            if (memberName != null) {
                JSType oldType;
                JSType rawValueType = name.getFirstChild().getJSType();
                JSType valueType = TypeCheck.getObjectLitKeyTypeFromValueType(name, rawValueType);
                if (valueType == null) {
                    valueType = this.unknownType;
                }
                objectType.defineInferredProperty(memberName, valueType, name);
                if (qObjName == null || !name.isStringKey()) continue;
                String qKeyName = qObjName + "." + memberName;
                TypedVar var = this.syntacticScope.getVar(qKeyName);
                JSType jSType = oldType = var == null ? null : var.getType();
                if (var != null && var.isTypeInferred()) {
                    var.setType(oldType == null ? valueType : oldType.getLeastSupertype(oldType));
                }
                scope.inferQualifiedSlot(name, qKeyName, oldType == null ? this.unknownType : oldType, valueType, false);
                continue;
            }
            n.setJSType(this.unknownType);
        }
        return scope;
    }

    private FlowScope traverseAdd(Node n, FlowScope scope) {
        Node left = n.getFirstChild();
        Node right = left.getNext();
        scope = this.traverseChildren(n, scope);
        JSType leftType = left.getJSType();
        JSType rightType = right.getJSType();
        JSType type = this.unknownType;
        if (leftType != null && rightType != null) {
            boolean leftIsUnknown = leftType.isUnknownType();
            boolean rightIsUnknown = rightType.isUnknownType();
            type = leftIsUnknown && rightIsUnknown ? this.unknownType : (!leftIsUnknown && leftType.isString() || !rightIsUnknown && rightType.isString() ? this.getNativeType(JSTypeNative.STRING_TYPE) : (leftIsUnknown || rightIsUnknown ? this.unknownType : (this.isAddedAsNumber(leftType) && this.isAddedAsNumber(rightType) ? this.getNativeType(JSTypeNative.NUMBER_TYPE) : this.registry.createUnionType(JSTypeNative.STRING_TYPE, JSTypeNative.NUMBER_TYPE))));
        }
        n.setJSType(type);
        if (n.isAssignAdd()) {
            this.updateScopeForTypeChange(scope, left, leftType, type);
        }
        return scope;
    }

    private boolean isAddedAsNumber(JSType type) {
        return type.isSubtype(this.registry.createUnionType(JSTypeNative.VOID_TYPE, JSTypeNative.NULL_TYPE, JSTypeNative.NUMBER_VALUE_OR_OBJECT_TYPE, JSTypeNative.BOOLEAN_TYPE, JSTypeNative.BOOLEAN_OBJECT_TYPE));
    }

    private FlowScope traverseHook(Node n, FlowScope scope) {
        Node condition = n.getFirstChild();
        Node trueNode = condition.getNext();
        Node falseNode = n.getLastChild();
        scope = this.traverse(condition, scope);
        FlowScope trueScope = this.reverseInterpreter.getPreciserScopeKnowingConditionOutcome(condition, scope, true);
        FlowScope falseScope = this.reverseInterpreter.getPreciserScopeKnowingConditionOutcome(condition, scope, false);
        this.traverse(trueNode, trueScope.createChildFlowScope());
        this.traverse(falseNode, falseScope.createChildFlowScope());
        JSType trueType = trueNode.getJSType();
        JSType falseType = falseNode.getJSType();
        if (trueType != null && falseType != null) {
            n.setJSType(trueType.getLeastSupertype(falseType));
        } else {
            n.setJSType(null);
        }
        return scope.createChildFlowScope();
    }

    private FlowScope traverseCall(Node n, FlowScope scope) {
        scope = this.traverseChildren(n, scope);
        Node left = n.getFirstChild();
        JSType functionType = this.getJSType(left).restrictByNotNullOrUndefined();
        if (functionType.isFunctionType()) {
            FunctionType fnType = functionType.toMaybeFunctionType();
            n.setJSType(fnType.getReturnType());
            this.backwardsInferenceFromCallSite(n, fnType);
        } else if (functionType.isEquivalentTo(this.getNativeType(JSTypeNative.CHECKED_UNKNOWN_TYPE))) {
            n.setJSType(this.getNativeType(JSTypeNative.CHECKED_UNKNOWN_TYPE));
        }
        scope = this.tightenTypesAfterAssertions(scope, n);
        return scope;
    }

    private FlowScope tightenTypesAfterAssertions(FlowScope scope, Node callNode) {
        JSType narrowed;
        Node left = callNode.getFirstChild();
        Node firstParam = left.getNext();
        CodingConvention.AssertionFunctionSpec assertionFunctionSpec = this.assertionFunctionsMap.get(left.getQualifiedName());
        if (assertionFunctionSpec == null || firstParam == null) {
            return scope;
        }
        Node assertedNode = assertionFunctionSpec.getAssertedParam(firstParam);
        if (assertedNode == null) {
            return scope;
        }
        JSType assertedType = assertionFunctionSpec.getAssertedOldType(callNode, this.registry);
        String assertedNodeName = assertedNode.getQualifiedName();
        if (assertedType == null) {
            scope = this.reverseInterpreter.getPreciserScopeKnowingConditionOutcome(assertedNode, scope, true);
            narrowed = this.getJSType(assertedNode).restrictByNotNullOrUndefined();
        } else {
            JSType type = this.getJSType(assertedNode);
            narrowed = assertedType.isUnknownType() || type.isUnknownType() ? assertedType : type.getGreatestSubtype(assertedType);
            if (assertedNodeName != null && type.differsFrom(narrowed)) {
                scope = this.narrowScope(scope, assertedNode, narrowed);
            }
        }
        callNode.setJSType(narrowed);
        return scope;
    }

    private FlowScope narrowScope(FlowScope scope, Node node, JSType narrowed) {
        if (node.isThis()) {
            return scope;
        }
        scope = scope.createChildFlowScope();
        if (node.isGetProp()) {
            scope.inferQualifiedSlot(node, node.getQualifiedName(), this.getJSType(node), narrowed, false);
        } else {
            this.redeclareSimpleVar(scope, node, narrowed);
        }
        return scope;
    }

    private void backwardsInferenceFromCallSite(Node n, FunctionType fnType) {
        boolean updatedFnType = this.inferTemplatedTypesForCall(n, fnType);
        if (updatedFnType) {
            fnType = n.getFirstChild().getJSType().toMaybeFunctionType();
        }
        this.updateTypeOfParameters(n, fnType);
        this.updateBind(n);
    }

    private void updateBind(Node n) {
        JSType thisType;
        CodingConvention.Bind bind = this.compiler.getCodingConvention().describeFunctionBind(n, false, true);
        if (bind == null) {
            return;
        }
        Node target = bind.target;
        FunctionType callTargetFn = this.getJSType(target).restrictByNotNullOrUndefined().toMaybeFunctionType();
        if (callTargetFn == null) {
            return;
        }
        if (bind.thisValue != null && target.isFunction() && (thisType = this.getJSType(bind.thisValue)).toObjectType() != null && !thisType.isUnknownType() && callTargetFn.getTypeOfThis().isUnknownType()) {
            callTargetFn = new FunctionBuilder(this.registry).copyFromOtherFunction(callTargetFn).withTypeOfThis(thisType.toObjectType()).build();
            target.setJSType(callTargetFn);
        }
        n.setJSType(callTargetFn.getBindReturnType(bind.getBoundParameterCount() + 1));
    }

    private void updateTypeOfParameters(Node n, FunctionType fnType) {
        int i = 0;
        int childCount = n.getChildCount();
        for (Node iParameter : fnType.getParameters()) {
            if (i + 1 >= childCount) {
                return;
            }
            JSType iParameterType = this.getJSType(iParameter);
            Node iArgument = n.getChildAtIndex(i + 1);
            JSType iArgumentType = this.getJSType(iArgument);
            TypeInference.inferPropertyTypesToMatchConstraint(iArgumentType, iParameterType);
            FunctionType restrictedParameter = null;
            if (iParameterType.isUnionType()) {
                UnionType union = iParameterType.toMaybeUnionType();
                for (JSType alternative : union.getAlternates()) {
                    if (!alternative.isFunctionType()) continue;
                    restrictedParameter = alternative.toMaybeFunctionType();
                    break;
                }
            } else {
                restrictedParameter = iParameterType.toMaybeFunctionType();
            }
            if (restrictedParameter != null && iArgument.isFunction() && iArgumentType.isFunctionType()) {
                FunctionType argFnType = iArgumentType.toMaybeFunctionType();
                boolean declared = iArgument.getJSDocInfo() != null;
                iArgument.setJSType(this.matchFunction(restrictedParameter, argFnType, declared));
            }
            ++i;
        }
    }

    private FunctionType matchFunction(FunctionType expectedType, FunctionType currentType, boolean declared) {
        if (declared) {
            if (currentType.getTypeOfThis().isUnknownType() && !expectedType.getTypeOfThis().isUnknownType()) {
                FunctionType replacement = new FunctionBuilder(this.registry).copyFromOtherFunction(currentType).withTypeOfThis(expectedType.getTypeOfThis()).build();
                return replacement;
            }
        } else if (currentType.getMaxArguments() <= expectedType.getMaxArguments()) {
            return expectedType;
        }
        return currentType;
    }

    private Map<TemplateType, JSType> inferTemplateTypesFromParameters(FunctionType fnType, Node call) {
        if (fnType.getTemplateTypeMap().getTemplateKeys().isEmpty()) {
            return Collections.emptyMap();
        }
        IdentityHashMap resolvedTypes = Maps.newIdentityHashMap();
        Set seenTypes = Sets.newIdentityHashSet();
        Node callTarget = call.getFirstChild();
        if (NodeUtil.isGet(callTarget)) {
            Node obj = callTarget.getFirstChild();
            this.maybeResolveTemplatedType(fnType.getTypeOfThis(), this.getJSType(obj), resolvedTypes, seenTypes);
        }
        if (call.hasMoreThanOneChild()) {
            this.maybeResolveTemplateTypeFromNodes(fnType.getParameters(), call.getChildAtIndex(1).siblings(), (Map<TemplateType, JSType>)resolvedTypes, (Set<JSType>)seenTypes);
        }
        return resolvedTypes;
    }

    private void maybeResolveTemplatedType(JSType paramType, JSType argType, Map<TemplateType, JSType> resolvedTypes, Set<JSType> seenTypes) {
        block7: {
            block10: {
                block9: {
                    block8: {
                        block6: {
                            if (!paramType.isTemplateType()) break block6;
                            TypeInference.resolvedTemplateType(resolvedTypes, paramType.toMaybeTemplateType(), argType);
                            break block7;
                        }
                        if (!paramType.isUnionType()) break block8;
                        UnionType unionType = paramType.toMaybeUnionType();
                        for (JSType alernative : unionType.getAlternates()) {
                            this.maybeResolveTemplatedType(alernative, argType, resolvedTypes, seenTypes);
                        }
                        break block7;
                    }
                    if (!paramType.isFunctionType()) break block9;
                    FunctionType paramFunctionType = paramType.toMaybeFunctionType();
                    FunctionType argFunctionType = argType.restrictByNotNullOrUndefined().collapseUnion().toMaybeFunctionType();
                    if (argFunctionType == null || !argFunctionType.isSubtype(paramType)) break block7;
                    this.maybeResolveTemplatedType(paramFunctionType.getTypeOfThis(), argFunctionType.getTypeOfThis(), resolvedTypes, seenTypes);
                    this.maybeResolveTemplatedType(paramFunctionType.getReturnType(), argFunctionType.getReturnType(), resolvedTypes, seenTypes);
                    this.maybeResolveTemplateTypeFromNodes(paramFunctionType.getParameters(), argFunctionType.getParameters(), resolvedTypes, seenTypes);
                    break block7;
                }
                if (!paramType.isRecordType() || paramType.isNominalType()) break block10;
                if (!seenTypes.add(paramType)) break block7;
                ObjectType paramRecordType = paramType.toObjectType();
                ObjectType argObjectType = argType.restrictByNotNullOrUndefined().toObjectType();
                if (argObjectType != null && !argObjectType.isUnknownType() && !argObjectType.isEmptyType()) {
                    Set<String> names = paramRecordType.getPropertyNames();
                    for (String name : names) {
                        if (!paramRecordType.hasOwnProperty(name) || !argObjectType.hasProperty(name)) continue;
                        this.maybeResolveTemplatedType(paramRecordType.getPropertyType(name), argObjectType.getPropertyType(name), resolvedTypes, seenTypes);
                    }
                }
                seenTypes.remove(paramType);
                break block7;
            }
            if (paramType.isTemplatizedType()) {
                ObjectType referencedParamType = paramType.toMaybeTemplatizedType().getReferencedType();
                JSType argObjectType = argType.restrictByNotNullOrUndefined().collapseUnion();
                if (argObjectType.isSubtype(referencedParamType)) {
                    TemplateTypeMap paramTypeMap = paramType.getTemplateTypeMap();
                    TemplateTypeMap argTypeMap = argObjectType.getTemplateTypeMap();
                    for (TemplateType key : paramTypeMap.getTemplateKeys()) {
                        this.maybeResolveTemplatedType(paramTypeMap.getTemplateType(key), argTypeMap.getTemplateType(key), resolvedTypes, seenTypes);
                    }
                }
            }
        }
    }

    private void maybeResolveTemplateTypeFromNodes(Iterable<Node> declParams, Iterable<Node> callParams, Map<TemplateType, JSType> resolvedTypes, Set<JSType> seenTypes) {
        this.maybeResolveTemplateTypeFromNodes(declParams.iterator(), callParams.iterator(), resolvedTypes, seenTypes);
    }

    private void maybeResolveTemplateTypeFromNodes(Iterator<Node> declParams, Iterator<Node> callParams, Map<TemplateType, JSType> resolvedTypes, Set<JSType> seenTypes) {
        while (declParams.hasNext() && callParams.hasNext()) {
            Node declParam = declParams.next();
            this.maybeResolveTemplatedType(this.getJSType(declParam), this.getJSType(callParams.next()), resolvedTypes, seenTypes);
            if (!declParam.isVarArgs()) continue;
            while (callParams.hasNext()) {
                this.maybeResolveTemplatedType(this.getJSType(declParam), this.getJSType(callParams.next()), resolvedTypes, seenTypes);
            }
        }
    }

    private static void resolvedTemplateType(Map<TemplateType, JSType> map, TemplateType template, JSType resolved) {
        JSType previous = map.get(template);
        if (!resolved.isUnknownType()) {
            if (previous == null) {
                map.put(template, resolved);
            } else {
                JSType join = previous.getLeastSupertype(resolved);
                map.put(template, join);
            }
        }
    }

    private Map<String, JSType> buildTypeVariables(Map<TemplateType, JSType> inferredTypes) {
        HashMap<String, JSType> typeVars = new HashMap<String, JSType>();
        for (Map.Entry<TemplateType, JSType> e : inferredTypes.entrySet()) {
            if (e.getKey().isTypeTransformation()) continue;
            typeVars.put(e.getKey().getReferenceName(), e.getValue());
        }
        return typeVars;
    }

    private Map<TemplateType, JSType> evaluateTypeTransformations(ImmutableList<TemplateType> templateTypes, Map<TemplateType, JSType> inferredTypes) {
        Map<String, JSType> typeVars = null;
        HashMap<TemplateType, JSType> result = null;
        TypeTransformation ttlObj = null;
        for (TemplateType type : templateTypes) {
            if (!type.isTypeTransformation()) continue;
            if (ttlObj == null) {
                ttlObj = new TypeTransformation(this.compiler, this.syntacticScope);
                typeVars = this.buildTypeVariables(inferredTypes);
                result = new HashMap<TemplateType, JSType>();
            }
            JSType transformedType = ttlObj.eval(type.getTypeTransformation(), (ImmutableMap<String, JSType>)ImmutableMap.copyOf(typeVars));
            result.put(type, transformedType);
            typeVars.put(type.getReferenceName(), transformedType);
        }
        return result;
    }

    private boolean inferTemplatedTypesForCall(Node n, FunctionType fnType) {
        ImmutableList<TemplateType> keys = fnType.getTemplateTypeMap().getTemplateKeys();
        if (keys.isEmpty()) {
            return false;
        }
        Map<TemplateType, JSType> rawInferrence = this.inferTemplateTypesFromParameters(fnType, n);
        IdentityHashMap inferred = Maps.newIdentityHashMap();
        for (TemplateType key : keys) {
            JSType type = rawInferrence.get(key);
            if (type == null) {
                type = this.unknownType;
            }
            inferred.put(key, type);
        }
        Map<TemplateType, JSType> typeTransformations = this.evaluateTypeTransformations(keys, inferred);
        if (typeTransformations != null) {
            inferred.putAll(typeTransformations);
        }
        TemplateTypeReplacer replacer = new TemplateTypeReplacer(this.registry, inferred);
        Node callTarget = n.getFirstChild();
        FunctionType replacementFnType = fnType.visit(replacer).toMaybeFunctionType();
        Preconditions.checkNotNull((Object)replacementFnType);
        callTarget.setJSType(replacementFnType);
        n.setJSType(replacementFnType.getReturnType());
        return replacer.madeChanges;
    }

    private FlowScope traverseNew(Node n, FlowScope scope) {
        scope = this.traverseChildren(n, scope);
        Node constructor = n.getFirstChild();
        JSType constructorType = constructor.getJSType();
        ObjectType type = null;
        if (constructorType != null) {
            if ((constructorType = constructorType.restrictByNotNullOrUndefined()).isUnknownType()) {
                type = this.unknownType;
            } else {
                FunctionType ct = constructorType.toMaybeFunctionType();
                if (ct == null && constructorType instanceof FunctionType) {
                    ct = (FunctionType)constructorType;
                }
                if (ct != null && ct.isConstructor()) {
                    this.backwardsInferenceFromCallSite(n, ct);
                    ObjectType instanceType = ct.getInstanceType();
                    Map<TemplateType, JSType> inferredTypes = this.inferTemplateTypesFromParameters(ct, n);
                    type = inferredTypes.isEmpty() ? instanceType : this.registry.createTemplatizedType(instanceType, inferredTypes);
                }
            }
        }
        n.setJSType(type);
        return scope;
    }

    private BooleanOutcomePair traverseAnd(Node n, FlowScope scope) {
        return this.traverseShortCircuitingBinOp(n, scope);
    }

    private FlowScope traverseChildren(Node n, FlowScope scope) {
        for (Node el = n.getFirstChild(); el != null; el = el.getNext()) {
            scope = this.traverse(el, scope);
        }
        return scope;
    }

    private FlowScope traverseGetElem(Node n, FlowScope scope) {
        scope = this.traverseChildren(n, scope);
        JSType type = this.getJSType(n.getFirstChild()).restrictByNotNullOrUndefined();
        TemplateTypeMap typeMap = type.getTemplateTypeMap();
        if (typeMap.hasTemplateType(this.registry.getObjectElementKey())) {
            n.setJSType(typeMap.getTemplateType(this.registry.getObjectElementKey()));
        }
        return this.dereferencePointer(n.getFirstChild(), scope);
    }

    private FlowScope traverseGetProp(Node n, FlowScope scope) {
        Node objNode = n.getFirstChild();
        Node property = n.getLastChild();
        scope = this.traverseChildren(n, scope);
        n.setJSType(this.getPropertyType(objNode.getJSType(), property.getString(), n, scope));
        return this.dereferencePointer(n.getFirstChild(), scope);
    }

    private static void inferPropertyTypesToMatchConstraint(JSType type, JSType constraint) {
        if (type == null || constraint == null) {
            return;
        }
        type.matchConstraint(constraint);
    }

    private FlowScope dereferencePointer(Node n, FlowScope scope) {
        JSType narrowed;
        JSType type;
        if (n.isQualifiedName() && (type = this.getJSType(n)) != (narrowed = type.restrictByNotNullOrUndefined())) {
            scope = this.narrowScope(scope, n, narrowed);
        }
        return scope;
    }

    private JSType getPropertyType(JSType objType, String propName, Node n, FlowScope scope) {
        ObjectType regType;
        JSType restrictedObjType;
        JSType foundType;
        JSType varType;
        JSType propertyType = null;
        boolean isLocallyInferred = false;
        String qualifiedName = n.getQualifiedName();
        StaticTypedSlot var = scope.getSlot(qualifiedName);
        if (var != null && (varType = (JSType)var.getType()) != null) {
            boolean isDeclared = !var.isTypeInferred();
            boolean bl = isLocallyInferred = var != this.syntacticScope.getSlot(qualifiedName);
            if (isDeclared || isLocallyInferred) {
                propertyType = varType;
            }
        }
        if (propertyType == null && objType != null && (foundType = objType.findPropertyType(propName)) != null) {
            propertyType = foundType;
        }
        if (propertyType != null && objType != null && !(restrictedObjType = objType.restrictByNotNullOrUndefined()).getTemplateTypeMap().isEmpty() && propertyType.hasAnyTemplateTypes()) {
            TemplateTypeMap typeMap = restrictedObjType.getTemplateTypeMap();
            TemplateTypeMapReplacer replacer = new TemplateTypeMapReplacer(this.registry, typeMap);
            propertyType = propertyType.visit(replacer);
        }
        if ((propertyType == null || propertyType.isUnknownType()) && qualifiedName != null && (regType = ObjectType.cast(this.registry.getType(qualifiedName))) != null) {
            propertyType = regType.getConstructor();
        }
        if (propertyType == null) {
            return this.unknownType;
        }
        if (propertyType.isEquivalentTo(this.unknownType) && isLocallyInferred) {
            return this.getNativeType(JSTypeNative.CHECKED_UNKNOWN_TYPE);
        }
        return propertyType;
    }

    private BooleanOutcomePair traverseOr(Node n, FlowScope scope) {
        return this.traverseShortCircuitingBinOp(n, scope);
    }

    private BooleanOutcomePair traverseShortCircuitingBinOp(Node n, FlowScope scope) {
        BooleanOutcomePair outcome;
        JSType type;
        Preconditions.checkArgument((n.isAnd() || n.isOr() ? 1 : 0) != 0);
        boolean nIsAnd = n.isAnd();
        Node left = n.getFirstChild();
        Node right = n.getLastChild();
        BooleanOutcomePair leftOutcome = this.traverseWithinShortCircuitingBinOp(left, scope.createChildFlowScope());
        JSType leftType = left.getJSType();
        FlowScope rightScope = this.reverseInterpreter.getPreciserScopeKnowingConditionOutcome(left, leftOutcome.getOutcomeFlowScope(left.getType(), nIsAnd), nIsAnd);
        BooleanOutcomePair rightOutcome = this.traverseWithinShortCircuitingBinOp(right, rightScope.createChildFlowScope());
        JSType rightType = right.getJSType();
        if (leftType != null && rightType != null) {
            leftType = leftType.getRestrictedTypeGivenToBooleanOutcome(!nIsAnd);
            if (leftOutcome.toBooleanOutcomes == BooleanLiteralSet.get(!nIsAnd)) {
                type = leftType;
                outcome = leftOutcome;
            } else {
                type = leftType.getLeastSupertype(rightType);
                outcome = new BooleanOutcomePair(TypeInference.joinBooleanOutcomes(nIsAnd, leftOutcome.toBooleanOutcomes, rightOutcome.toBooleanOutcomes), TypeInference.joinBooleanOutcomes(nIsAnd, leftOutcome.booleanValues, rightOutcome.booleanValues), leftOutcome.getJoinedFlowScope(), rightOutcome.getJoinedFlowScope());
            }
            if (outcome.booleanValues == BooleanLiteralSet.EMPTY && this.getNativeType(JSTypeNative.BOOLEAN_TYPE).isSubtype(type) && type.isUnionType()) {
                type = type.toMaybeUnionType().getRestrictedUnion(this.getNativeType(JSTypeNative.BOOLEAN_TYPE));
            }
        } else {
            type = null;
            outcome = new BooleanOutcomePair(BooleanLiteralSet.BOTH, BooleanLiteralSet.BOTH, leftOutcome.getJoinedFlowScope(), rightOutcome.getJoinedFlowScope());
        }
        n.setJSType(type);
        return outcome;
    }

    private BooleanOutcomePair traverseWithinShortCircuitingBinOp(Node n, FlowScope scope) {
        switch (n.getType()) {
            case 101: {
                return this.traverseAnd(n, scope);
            }
            case 100: {
                return this.traverseOr(n, scope);
            }
        }
        scope = this.traverse(n, scope);
        return this.newBooleanOutcomePair(n.getJSType(), scope);
    }

    private static BooleanLiteralSet joinBooleanOutcomes(boolean isAnd, BooleanLiteralSet left, BooleanLiteralSet right) {
        return right.union(left.intersection(BooleanLiteralSet.get(!isAnd)));
    }

    private BooleanOutcomePair newBooleanOutcomePair(JSType jsType, FlowScope flowScope) {
        if (jsType == null) {
            return new BooleanOutcomePair(BooleanLiteralSet.BOTH, BooleanLiteralSet.BOTH, flowScope, flowScope);
        }
        return new BooleanOutcomePair(jsType.getPossibleToBooleanOutcomes(), this.registry.getNativeType(JSTypeNative.BOOLEAN_TYPE).isSubtype(jsType) ? BooleanLiteralSet.BOTH : BooleanLiteralSet.EMPTY, flowScope, flowScope);
    }

    private void redeclareSimpleVar(FlowScope scope, Node nameNode, JSType varType) {
        Preconditions.checkState((boolean)nameNode.isName());
        String varName = nameNode.getString();
        if (varType == null) {
            varType = this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }
        if (this.isUnflowable(this.syntacticScope.getVar(varName))) {
            return;
        }
        scope.inferSlotType(varName, varType);
    }

    private boolean isUnflowable(TypedVar v) {
        return v != null && v.isLocal() && v.isMarkedEscaped() && v.getScope() == this.syntacticScope;
    }

    private JSType getJSType(Node n) {
        JSType jsType = n.getJSType();
        if (jsType == null) {
            return this.unknownType;
        }
        return jsType;
    }

    private JSType getNativeType(JSTypeNative typeId) {
        return this.registry.getNativeType(typeId);
    }

    private final class BooleanOutcomePair {
        final BooleanLiteralSet toBooleanOutcomes;
        final BooleanLiteralSet booleanValues;
        final FlowScope leftScope;
        final FlowScope rightScope;
        FlowScope joinedScope = null;

        BooleanOutcomePair(BooleanLiteralSet toBooleanOutcomes, BooleanLiteralSet booleanValues, FlowScope leftScope, FlowScope rightScope) {
            this.toBooleanOutcomes = toBooleanOutcomes;
            this.booleanValues = booleanValues;
            this.leftScope = leftScope;
            this.rightScope = rightScope;
        }

        FlowScope getJoinedFlowScope() {
            if (this.joinedScope == null) {
                this.joinedScope = this.leftScope == this.rightScope ? this.rightScope : TypeInference.this.join(this.leftScope, this.rightScope);
            }
            return this.joinedScope;
        }

        FlowScope getOutcomeFlowScope(int nodeType, boolean outcome) {
            if (nodeType == 101 && outcome || nodeType == 100 && !outcome) {
                return this.rightScope;
            }
            return this.getJoinedFlowScope();
        }
    }

    private static class TemplateTypeReplacer
    extends ModificationVisitor {
        private final Map<TemplateType, JSType> replacements;
        private final JSTypeRegistry registry;
        boolean madeChanges = false;

        TemplateTypeReplacer(JSTypeRegistry registry, Map<TemplateType, JSType> replacements) {
            super(registry, true);
            this.registry = registry;
            this.replacements = replacements;
        }

        @Override
        public JSType caseTemplateType(TemplateType type) {
            this.madeChanges = true;
            JSType replacement = this.replacements.get(type);
            return replacement != null ? replacement : this.registry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }
    }
}

