/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multiset;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.TokenStream;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

class MakeDeclaredNamesUnique
implements NodeTraversal.ScopedCallback {
    public static final String ARGUMENTS = "arguments";
    private Deque<Renamer> nameStack = new ArrayDeque<Renamer>();
    private final Renamer rootRenamer;

    MakeDeclaredNamesUnique() {
        this(new ContextualRenamer());
    }

    MakeDeclaredNamesUnique(Renamer renamer) {
        this.rootRenamer = renamer;
    }

    static CompilerPass getContextualRenameInverter(AbstractCompiler compiler) {
        return new ContextualRenameInverter(compiler);
    }

    @Override
    public void enterScope(NodeTraversal t) {
        Renamer renamer;
        Node declarationRoot = t.getScopeRoot();
        if (this.nameStack.isEmpty()) {
            Preconditions.checkState((!declarationRoot.isFunction() || !(this.rootRenamer instanceof ContextualRenamer) ? 1 : 0) != 0);
            Preconditions.checkState((boolean)t.inGlobalScope());
            renamer = this.rootRenamer;
        } else {
            renamer = this.nameStack.peek().forChildScope();
        }
        if (!declarationRoot.isFunction()) {
            MakeDeclaredNamesUnique.findDeclaredNames(declarationRoot, null, renamer);
        }
        this.nameStack.push(renamer);
    }

    @Override
    public void exitScope(NodeTraversal t) {
        if (!t.inGlobalScope()) {
            this.nameStack.pop();
        }
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        switch (n.getType()) {
            case 105: {
                Renamer renamer = this.nameStack.peek().forChildScope();
                String name = n.getFirstChild().getString();
                if (name != null && !name.isEmpty() && parent != null && !NodeUtil.isFunctionDeclaration(n)) {
                    renamer.addDeclaredName(name);
                }
                this.nameStack.push(renamer);
                break;
            }
            case 83: {
                Renamer renamer = this.nameStack.peek().forChildScope();
                for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
                    String name = c.getString();
                    renamer.addDeclaredName(name);
                }
                Node functionBody = n.getNext();
                MakeDeclaredNamesUnique.findDeclaredNames(functionBody, null, renamer);
                this.nameStack.push(renamer);
                break;
            }
            case 120: {
                Renamer renamer = this.nameStack.peek().forChildScope();
                String name = n.getFirstChild().getString();
                renamer.addDeclaredName(name);
                this.nameStack.push(renamer);
            }
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getType()) {
            case 38: {
                String newName = this.getReplacementName(n.getString());
                if (newName == null) break;
                Renamer renamer = this.nameStack.peek();
                if (renamer.stripConstIfReplaced()) {
                    n.removeProp(43);
                }
                n.setString(newName);
                t.getCompiler().reportCodeChange();
                break;
            }
            case 105: {
                this.nameStack.pop();
                this.nameStack.pop();
                break;
            }
            case 83: {
                break;
            }
            case 120: {
                this.nameStack.pop();
            }
        }
    }

    private String getReplacementName(String oldName) {
        for (Renamer names : this.nameStack) {
            String newName = names.getReplacementName(oldName);
            if (newName == null) continue;
            return newName;
        }
        return null;
    }

    private static void findDeclaredNames(Node n, Node parent, Renamer renamer) {
        if (parent == null || !parent.isFunction() || n == parent.getFirstChild()) {
            if (NodeUtil.isVarDeclaration(n)) {
                renamer.addDeclaredName(n.getString());
            } else if (NodeUtil.isFunctionDeclaration(n)) {
                Node nameNode = n.getFirstChild();
                renamer.addDeclaredName(nameNode.getString());
            }
            for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
                MakeDeclaredNamesUnique.findDeclaredNames(c, n, renamer);
            }
        }
    }

    static class WhitelistedRenamer
    implements Renamer {
        private Renamer delegate;
        private Set<String> whitelist;

        WhitelistedRenamer(Renamer delegate, Set<String> whitelist) {
            this.delegate = delegate;
            this.whitelist = whitelist;
        }

        @Override
        public void addDeclaredName(String name) {
            if (this.whitelist.contains(name)) {
                this.delegate.addDeclaredName(name);
            }
        }

        @Override
        public String getReplacementName(String oldName) {
            return this.whitelist.contains(oldName) ? this.delegate.getReplacementName(oldName) : null;
        }

        @Override
        public boolean stripConstIfReplaced() {
            return this.delegate.stripConstIfReplaced();
        }

        @Override
        public Renamer forChildScope() {
            return new WhitelistedRenamer(this.delegate.forChildScope(), this.whitelist);
        }
    }

    static class BoilerplateRenamer
    extends ContextualRenamer {
        private final Supplier<String> uniqueIdSupplier;
        private final String idPrefix;
        private final CodingConvention convention;

        BoilerplateRenamer(CodingConvention convention, Supplier<String> uniqueIdSupplier, String idPrefix) {
            this.convention = convention;
            this.uniqueIdSupplier = uniqueIdSupplier;
            this.idPrefix = idPrefix;
        }

        @Override
        public Renamer forChildScope() {
            return new InlineRenamer(this.convention, this.uniqueIdSupplier, this.idPrefix, false);
        }
    }

    static class InlineRenamer
    implements Renamer {
        private final Map<String, String> declarations = new HashMap<String, String>();
        private final Supplier<String> uniqueIdSupplier;
        private final String idPrefix;
        private final boolean removeConstness;
        private final CodingConvention convention;

        InlineRenamer(CodingConvention convention, Supplier<String> uniqueIdSupplier, String idPrefix, boolean removeConstness) {
            this.convention = convention;
            this.uniqueIdSupplier = uniqueIdSupplier;
            Preconditions.checkArgument((!idPrefix.isEmpty() ? 1 : 0) != 0);
            this.idPrefix = idPrefix;
            this.removeConstness = removeConstness;
        }

        @Override
        public void addDeclaredName(String name) {
            Preconditions.checkState((!name.equals(MakeDeclaredNamesUnique.ARGUMENTS) ? 1 : 0) != 0);
            if (!this.declarations.containsKey(name)) {
                this.declarations.put(name, this.getUniqueName(name));
            }
        }

        private String getUniqueName(String name) {
            if (name.isEmpty()) {
                return name;
            }
            if (name.contains("$$")) {
                name = name.substring(0, name.lastIndexOf("$$"));
            }
            if (this.convention.isExported(name)) {
                name = "JSCompiler_" + name;
            }
            return name + "$$" + this.idPrefix + (String)this.uniqueIdSupplier.get();
        }

        @Override
        public String getReplacementName(String oldName) {
            return this.declarations.get(oldName);
        }

        @Override
        public Renamer forChildScope() {
            return new InlineRenamer(this.convention, this.uniqueIdSupplier, this.idPrefix, this.removeConstness);
        }

        @Override
        public boolean stripConstIfReplaced() {
            return this.removeConstness;
        }
    }

    static class ContextualRenamer
    implements Renamer {
        private final Multiset<String> nameUsage;
        private final Map<String, String> declarations = new HashMap<String, String>();
        private final boolean global;
        static final String UNIQUE_ID_SEPARATOR = "$$";

        ContextualRenamer() {
            this.global = true;
            this.nameUsage = HashMultiset.create();
        }

        private ContextualRenamer(Multiset<String> nameUsage) {
            this.global = false;
            this.nameUsage = nameUsage;
        }

        @Override
        public Renamer forChildScope() {
            return new ContextualRenamer(this.nameUsage);
        }

        @Override
        public void addDeclaredName(String name) {
            if (!name.equals(MakeDeclaredNamesUnique.ARGUMENTS)) {
                if (this.global) {
                    this.reserveName(name);
                } else if (!this.declarations.containsKey(name)) {
                    int id = this.incrementNameCount(name);
                    String newName = null;
                    if (id != 0) {
                        newName = ContextualRenamer.getUniqueName(name, id);
                    }
                    this.declarations.put(name, newName);
                }
            }
        }

        @Override
        public String getReplacementName(String oldName) {
            return this.declarations.get(oldName);
        }

        private static String getUniqueName(String name, int id) {
            return name + UNIQUE_ID_SEPARATOR + id;
        }

        private void reserveName(String name) {
            this.nameUsage.setCount((Object)name, 0, 1);
        }

        private int incrementNameCount(String name) {
            return this.nameUsage.add((Object)name, 1);
        }

        @Override
        public boolean stripConstIfReplaced() {
            return false;
        }
    }

    static class ContextualRenameInverter
    implements NodeTraversal.ScopedCallback,
    CompilerPass {
        private final AbstractCompiler compiler;
        private Set<String> referencedNames = ImmutableSet.of();
        private Deque<Set<String>> referenceStack = new ArrayDeque<Set<String>>();
        private Map<String, List<Node>> nameMap = new HashMap<String, List<Node>>();

        private ContextualRenameInverter(AbstractCompiler compiler) {
            this.compiler = compiler;
        }

        @Override
        public void process(Node externs, Node js) {
            NodeTraversal.traverse(this.compiler, js, this);
        }

        public static String getOriginalName(String name) {
            int index = ContextualRenameInverter.indexOfSeparator(name);
            return index == -1 ? name : name.substring(0, index);
        }

        private static int indexOfSeparator(String name) {
            return name.lastIndexOf("$$");
        }

        private static boolean containsSeparator(String name) {
            return name.contains("$$");
        }

        @Override
        public void enterScope(NodeTraversal t) {
            if (t.inGlobalScope()) {
                return;
            }
            this.referenceStack.push(this.referencedNames);
            this.referencedNames = new HashSet<String>();
        }

        @Override
        public void exitScope(NodeTraversal t) {
            if (t.inGlobalScope()) {
                return;
            }
            Iterator it = t.getScope().getVars();
            while (it.hasNext()) {
                Var v = (Var)it.next();
                this.handleScopeVar(v);
            }
            Set<String> current = this.referencedNames;
            this.referencedNames = this.referenceStack.pop();
            if (!this.referenceStack.isEmpty()) {
                this.referencedNames.addAll(current);
            }
        }

        void handleScopeVar(Var v) {
            String name = v.getName();
            if (ContextualRenameInverter.containsSeparator(name) && !ContextualRenameInverter.getOriginalName(name).isEmpty()) {
                String newName = this.findReplacementName(name);
                this.referencedNames.remove(name);
                this.referencedNames.add(newName);
                List<Node> references = this.nameMap.get(name);
                Preconditions.checkState((references != null ? 1 : 0) != 0);
                for (Node n : references) {
                    Preconditions.checkState((boolean)n.isName());
                    n.setString(newName);
                }
                this.compiler.reportCodeChange();
                this.nameMap.remove(name);
            }
        }

        private String findReplacementName(String name) {
            String original;
            String newName = original = ContextualRenameInverter.getOriginalName(name);
            int i = 0;
            while (!this.isValidName(newName)) {
                newName = original + "$$" + i++;
            }
            return newName;
        }

        private boolean isValidName(String name) {
            return TokenStream.isJSIdentifier(name) && !this.referencedNames.contains(name) && !name.equals(MakeDeclaredNamesUnique.ARGUMENTS);
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            return true;
        }

        @Override
        public void visit(NodeTraversal t, Node node, Node parent) {
            if (t.inGlobalScope()) {
                return;
            }
            if (NodeUtil.isReferenceName(node)) {
                String name = node.getString();
                this.referencedNames.add(name);
                if (ContextualRenameInverter.containsSeparator(name)) {
                    this.addCandidateNameReference(name, node);
                }
            }
        }

        private void addCandidateNameReference(String name, Node n) {
            List<Node> nodes = this.nameMap.get(name);
            if (null == nodes) {
                nodes = new LinkedList<Node>();
                this.nameMap.put(name, nodes);
            }
            nodes.add(n);
        }
    }

    static interface Renamer {
        public void addDeclaredName(String var1);

        public String getReplacementName(String var1);

        public boolean stripConstIfReplaced();

        public Renamer forChildScope();
    }
}

