/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.pool;

import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import org.apache.commons.lang.Validate;
import org.apache.commons.pool.KeyedObjectPool;
import org.springframework.ldap.core.DirContextProxy;
import org.springframework.ldap.pool.DelegatingContext;
import org.springframework.ldap.pool.DirContextType;

public class DelegatingDirContext
extends DelegatingContext
implements DirContext,
DirContextProxy {
    private DirContext delegateDirContext;

    public DelegatingDirContext(KeyedObjectPool keyedObjectPool, DirContext delegateDirContext, DirContextType dirContextType) {
        super(keyedObjectPool, delegateDirContext, dirContextType);
        Validate.notNull((Object)delegateDirContext, (String)"delegateDirContext may not be null");
        this.delegateDirContext = delegateDirContext;
    }

    public DirContext getDelegateDirContext() {
        return this.delegateDirContext;
    }

    public Context getDelegateContext() {
        return this.getDelegateDirContext();
    }

    public DirContext getInnermostDelegateDirContext() {
        DirContext delegateDirContext = this.getDelegateDirContext();
        if (delegateDirContext instanceof DelegatingDirContext) {
            return ((DelegatingDirContext)delegateDirContext).getInnermostDelegateDirContext();
        }
        return delegateDirContext;
    }

    protected void assertOpen() throws NamingException {
        if (this.delegateDirContext == null) {
            throw new NamingException("DirContext is closed.");
        }
        super.assertOpen();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DirContext)) {
            return false;
        }
        DirContext thisDirContext = this.getInnermostDelegateDirContext();
        DirContext otherDirContext = (DirContext)obj;
        if (otherDirContext instanceof DelegatingDirContext) {
            otherDirContext = ((DelegatingDirContext)otherDirContext).getInnermostDelegateDirContext();
        }
        return thisDirContext == otherDirContext || thisDirContext != null && thisDirContext.equals(otherDirContext);
    }

    public int hashCode() {
        DirContext context = this.getInnermostDelegateDirContext();
        return context != null ? context.hashCode() : 0;
    }

    public String toString() {
        DirContext context = this.getInnermostDelegateDirContext();
        return context != null ? context.toString() : "DirContext is closed";
    }

    public DirContext getTargetContext() {
        return this.getInnermostDelegateDirContext();
    }

    public void bind(Name name, Object obj, Attributes attrs) throws NamingException {
        this.assertOpen();
        this.getDelegateDirContext().bind(name, obj, attrs);
    }

    public void bind(String name, Object obj, Attributes attrs) throws NamingException {
        this.assertOpen();
        this.getDelegateDirContext().bind(name, obj, attrs);
    }

    public DirContext createSubcontext(Name name, Attributes attrs) throws NamingException {
        throw new UnsupportedOperationException("Cannot call createSubcontext on a pooled context");
    }

    public DirContext createSubcontext(String name, Attributes attrs) throws NamingException {
        throw new UnsupportedOperationException("Cannot call createSubcontext on a pooled context");
    }

    public Attributes getAttributes(Name name, String[] attrIds) throws NamingException {
        this.assertOpen();
        return this.getDelegateDirContext().getAttributes(name, attrIds);
    }

    public Attributes getAttributes(Name name) throws NamingException {
        this.assertOpen();
        return this.getDelegateDirContext().getAttributes(name);
    }

    public Attributes getAttributes(String name, String[] attrIds) throws NamingException {
        this.assertOpen();
        return this.getDelegateDirContext().getAttributes(name, attrIds);
    }

    public Attributes getAttributes(String name) throws NamingException {
        this.assertOpen();
        return this.getDelegateDirContext().getAttributes(name);
    }

    public DirContext getSchema(Name name) throws NamingException {
        throw new UnsupportedOperationException("Cannot call getSchema on a pooled context");
    }

    public DirContext getSchema(String name) throws NamingException {
        throw new UnsupportedOperationException("Cannot call getSchema on a pooled context");
    }

    public DirContext getSchemaClassDefinition(Name name) throws NamingException {
        throw new UnsupportedOperationException("Cannot call getSchemaClassDefinition on a pooled context");
    }

    public DirContext getSchemaClassDefinition(String name) throws NamingException {
        throw new UnsupportedOperationException("Cannot call getSchemaClassDefinition on a pooled context");
    }

    public void modifyAttributes(Name name, int mod_op, Attributes attrs) throws NamingException {
        this.assertOpen();
        this.getDelegateDirContext().modifyAttributes(name, mod_op, attrs);
    }

    public void modifyAttributes(Name name, ModificationItem[] mods) throws NamingException {
        this.assertOpen();
        this.getDelegateDirContext().modifyAttributes(name, mods);
    }

    public void modifyAttributes(String name, int mod_op, Attributes attrs) throws NamingException {
        this.assertOpen();
        this.getDelegateDirContext().modifyAttributes(name, mod_op, attrs);
    }

    public void modifyAttributes(String name, ModificationItem[] mods) throws NamingException {
        this.assertOpen();
        this.getDelegateDirContext().modifyAttributes(name, mods);
    }

    public void rebind(Name name, Object obj, Attributes attrs) throws NamingException {
        this.assertOpen();
        this.getDelegateDirContext().rebind(name, obj, attrs);
    }

    public void rebind(String name, Object obj, Attributes attrs) throws NamingException {
        this.assertOpen();
        this.getDelegateDirContext().rebind(name, obj, attrs);
    }

    public NamingEnumeration search(Name name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        this.assertOpen();
        return this.getDelegateDirContext().search(name, matchingAttributes, attributesToReturn);
    }

    public NamingEnumeration search(Name name, Attributes matchingAttributes) throws NamingException {
        this.assertOpen();
        return this.getDelegateDirContext().search(name, matchingAttributes);
    }

    public NamingEnumeration search(Name name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        this.assertOpen();
        return this.getDelegateDirContext().search(name, filterExpr, filterArgs, cons);
    }

    public NamingEnumeration search(Name name, String filter, SearchControls cons) throws NamingException {
        this.assertOpen();
        return this.getDelegateDirContext().search(name, filter, cons);
    }

    public NamingEnumeration search(String name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        this.assertOpen();
        return this.getDelegateDirContext().search(name, matchingAttributes, attributesToReturn);
    }

    public NamingEnumeration search(String name, Attributes matchingAttributes) throws NamingException {
        this.assertOpen();
        return this.getDelegateDirContext().search(name, matchingAttributes);
    }

    public NamingEnumeration search(String name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        this.assertOpen();
        return this.getDelegateDirContext().search(name, filterExpr, filterArgs, cons);
    }

    public NamingEnumeration search(String name, String filter, SearchControls cons) throws NamingException {
        this.assertOpen();
        return this.getDelegateDirContext().search(name, filter, cons);
    }

    public void close() throws NamingException {
        if (this.delegateDirContext == null) {
            return;
        }
        super.close();
        this.delegateDirContext = null;
    }
}

