/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import org.apache.camel.CamelContext;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedSendProcessorMBean;
import org.apache.camel.management.mbean.ManagedProcessor;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.SendProcessor;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.util.URISupport;

@ManagedResource(description="Managed SendProcessor")
public class ManagedSendProcessor
extends ManagedProcessor
implements ManagedSendProcessorMBean {
    private final SendProcessor processor;
    private String destination;

    public ManagedSendProcessor(CamelContext context, SendProcessor processor, ProcessorDefinition<?> definition) {
        super(context, processor, definition);
        this.processor = processor;
    }

    @Override
    public void init(ManagementStrategy strategy) {
        super.init(strategy);
        boolean sanitize = strategy.getManagementAgent().getMask() != null ? strategy.getManagementAgent().getMask() : false;
        this.destination = sanitize ? URISupport.sanitizeUri(this.processor.getDestination().getEndpointUri()) : this.processor.getDestination().getEndpointUri();
    }

    @Override
    public SendProcessor getProcessor() {
        return this.processor;
    }

    @Override
    public String getDestination() {
        return this.destination;
    }

    @Override
    public void setDestination(String uri) {
    }

    @Override
    public String getMessageExchangePattern() {
        if (this.processor.getPattern() != null) {
            return this.processor.getPattern().name();
        }
        return null;
    }
}

