/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.crs;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.crs.AbstractCRS;
import org.geotools.referencing.cs.DefaultCompoundCS;
import org.geotools.referencing.wkt.Formatter;
import org.geotools.resources.UnmodifiableArrayList;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.CheckedCollection;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.CoordinateSystem;

public class DefaultCompoundCRS
extends AbstractCRS
implements CompoundCRS {
    private static final long serialVersionUID = -2656710314586929286L;
    private final List<? extends CoordinateReferenceSystem> crs;
    private transient List<SingleCRS> singles;

    public DefaultCompoundCRS(CompoundCRS crs) {
        super((CoordinateReferenceSystem)crs);
        if (crs instanceof DefaultCompoundCRS) {
            DefaultCompoundCRS that = (DefaultCompoundCRS)crs;
            this.crs = that.crs;
            this.singles = that.singles;
        } else {
            this.crs = this.copy(crs.getCoordinateReferenceSystems());
        }
    }

    public DefaultCompoundCRS(String name, CoordinateReferenceSystem head, CoordinateReferenceSystem tail) {
        this(name, new CoordinateReferenceSystem[]{head, tail});
    }

    public DefaultCompoundCRS(String name, CoordinateReferenceSystem head, CoordinateReferenceSystem middle, CoordinateReferenceSystem tail) {
        this(name, new CoordinateReferenceSystem[]{head, middle, tail});
    }

    public DefaultCompoundCRS(String name, CoordinateReferenceSystem[] crs) {
        this(Collections.singletonMap("name", name), crs);
    }

    public DefaultCompoundCRS(Map<String, ?> properties, CoordinateReferenceSystem[] crs) {
        super(properties, DefaultCompoundCRS.createCoordinateSystem(crs));
        this.crs = this.copy(Arrays.asList(crs));
    }

    private static CoordinateSystem createCoordinateSystem(CoordinateReferenceSystem[] crs) {
        DefaultCompoundCRS.ensureNonNull("crs", crs);
        if (crs.length < 2) {
            throw new IllegalArgumentException(Errors.format(99, "crs[" + crs.length + ']'));
        }
        CoordinateSystem[] cs = new CoordinateSystem[crs.length];
        for (int i = 0; i < crs.length; ++i) {
            DefaultCompoundCRS.ensureNonNull("crs", crs, i);
            cs[i] = crs[i].getCoordinateSystem();
        }
        return new DefaultCompoundCS(cs);
    }

    private List<? extends CoordinateReferenceSystem> copy(List<? extends CoordinateReferenceSystem> crs) {
        crs = this.computeSingleCRS(crs) ? this.singles : UnmodifiableArrayList.wrap(crs.toArray(new CoordinateReferenceSystem[crs.size()]));
        return crs;
    }

    public List<CoordinateReferenceSystem> getCoordinateReferenceSystems() {
        return this.crs;
    }

    public List<SingleCRS> getSingleCRS() {
        return this.singles;
    }

    public static List<SingleCRS> getSingleCRS(CoordinateReferenceSystem crs) {
        List<SingleCRS> singles;
        if (crs instanceof DefaultCompoundCRS) {
            singles = ((DefaultCompoundCRS)crs).getSingleCRS();
        } else if (crs instanceof CompoundCRS) {
            List elements = ((CompoundCRS)crs).getCoordinateReferenceSystems();
            singles = new ArrayList<SingleCRS>(elements.size());
            DefaultCompoundCRS.getSingleCRS(elements, singles);
        } else {
            singles = Collections.singletonList((SingleCRS)crs);
        }
        return singles;
    }

    private static boolean getSingleCRS(List<? extends CoordinateReferenceSystem> source, List<SingleCRS> target) {
        boolean identical = true;
        for (CoordinateReferenceSystem coordinateReferenceSystem : source) {
            if (coordinateReferenceSystem instanceof CompoundCRS) {
                DefaultCompoundCRS.getSingleCRS(((CompoundCRS)coordinateReferenceSystem).getCoordinateReferenceSystems(), target);
                identical = false;
                continue;
            }
            target.add((SingleCRS)coordinateReferenceSystem);
        }
        return identical;
    }

    private boolean computeSingleCRS(List<? extends CoordinateReferenceSystem> crs) {
        this.singles = new ArrayList<SingleCRS>(crs.size());
        boolean identical = DefaultCompoundCRS.getSingleCRS(crs, this.singles);
        this.singles = UnmodifiableArrayList.wrap(this.singles.toArray(new SingleCRS[this.singles.size()]));
        return identical;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Class type;
        in.defaultReadObject();
        if (this.crs instanceof CheckedCollection && SingleCRS.class.isAssignableFrom(type = ((CheckedCollection)((Object)this.crs)).getElementType())) {
            this.singles = this.crs;
            return;
        }
        this.computeSingleCRS(this.crs);
    }

    @Override
    public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, compareMetadata)) {
            DefaultCompoundCRS that = (DefaultCompoundCRS)object;
            return DefaultCompoundCRS.equals(this.crs, that.crs, compareMetadata);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.crs.hashCode() ^ 0x73EE077A;
    }

    @Override
    protected String formatWKT(Formatter formatter) {
        for (CoordinateReferenceSystem coordinateReferenceSystem : this.crs) {
            formatter.append((IdentifiedObject)coordinateReferenceSystem);
        }
        return "COMPD_CS";
    }
}

