/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sailimpl.sync;

import java.util.Map;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.sesame.sail.NamespaceIterator;
import org.openrdf.sesame.sail.RdfRepository;
import org.openrdf.sesame.sail.Sail;
import org.openrdf.sesame.sail.SailChangedListener;
import org.openrdf.sesame.sail.SailInitializationException;
import org.openrdf.sesame.sail.SailInternalException;
import org.openrdf.sesame.sail.SailUpdateException;
import org.openrdf.sesame.sail.StackedSail;
import org.openrdf.sesame.sail.StatementIterator;
import org.openrdf.sesame.sail.query.Query;
import org.openrdf.util.log.ThreadLog;

public class SyncRdfRepository
implements RdfRepository,
StackedSail {
    private RdfRepository _rdfRepository;
    private boolean _transactionStarted = false;
    private boolean _writeRequested = false;
    private int _readingThreads = 0;

    public SyncRdfRepository() {
        ThreadLog.trace((String)"new SyncRdfRepository created");
    }

    public void setBaseSail(Sail sail) {
        if (!(sail instanceof RdfRepository)) {
            throw new SailInternalException("base Sail should be an RdfRepository");
        }
        this._rdfRepository = (RdfRepository)sail;
        ThreadLog.trace((String)"SyncRdfRepository: base sail was set");
    }

    public Sail getBaseSail() {
        return this._rdfRepository;
    }

    public void initialize(Map configParams) throws SailInitializationException {
        if (this._rdfRepository == null) {
            throw new SailInitializationException("Base sail was not set");
        }
        ThreadLog.trace((String)"SyncRdfRepository initialized");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown() {
        this._getWriteLock();
        try {
            this._rdfRepository.shutDown();
        }
        finally {
            this._releaseWriteLock();
        }
    }

    public void startTransaction() {
        this._getWriteLock();
        try {
            this._rdfRepository.startTransaction();
            this._transactionStarted = true;
        }
        catch (RuntimeException e) {
            this._releaseWriteLock();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitTransaction() {
        if (!this._transactionStarted) {
            throw new SailInternalException("No transaction started");
        }
        try {
            this._rdfRepository.commitTransaction();
        }
        finally {
            this._transactionStarted = false;
            this._releaseWriteLock();
        }
    }

    public boolean transactionStarted() {
        return this._transactionStarted;
    }

    public void addStatement(Resource subj, URI pred, Value obj) throws SailUpdateException {
        if (!this._transactionStarted) {
            throw new SailUpdateException("No transaction started");
        }
        this._rdfRepository.addStatement(subj, pred, obj);
    }

    public int removeStatements(Resource subj, URI pred, Value obj) throws SailUpdateException {
        if (!this._transactionStarted) {
            throw new SailUpdateException("No transaction started");
        }
        return this._rdfRepository.removeStatements(subj, pred, obj);
    }

    public void clearRepository() throws SailUpdateException {
        if (!this._transactionStarted) {
            throw new SailUpdateException("No transaction started");
        }
        this._rdfRepository.clearRepository();
    }

    public void changeNamespacePrefix(String namespace, String prefix) throws SailUpdateException {
        if (!this._transactionStarted) {
            throw new SailUpdateException("No transaction started");
        }
        this._rdfRepository.changeNamespacePrefix(namespace, prefix);
    }

    public ValueFactory getValueFactory() {
        return this._rdfRepository.getValueFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatementIterator getStatements(Resource subj, URI pred, Value obj) {
        StatementIterator result = null;
        this._getReadLock();
        try {
            result = this._rdfRepository.getStatements(subj, pred, obj);
        }
        finally {
            this._releaseReadLock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasStatement(Resource subj, URI pred, Value obj) {
        boolean result = false;
        this._getReadLock();
        try {
            result = this._rdfRepository.hasStatement(subj, pred, obj);
        }
        finally {
            this._releaseReadLock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query optimizeQuery(Query qc) {
        Query result = qc;
        this._getReadLock();
        try {
            result = this._rdfRepository.optimizeQuery(qc);
        }
        finally {
            this._releaseReadLock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamespaceIterator getNamespaces() {
        NamespaceIterator result = null;
        this._getReadLock();
        try {
            result = this._rdfRepository.getNamespaces();
        }
        finally {
            this._releaseReadLock();
        }
        return result;
    }

    public void addListener(SailChangedListener listener) {
        this._rdfRepository.addListener(listener);
    }

    public void removeListener(SailChangedListener listener) {
        this._rdfRepository.removeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _getWriteLock() {
        SyncRdfRepository syncRdfRepository = this;
        synchronized (syncRdfRepository) {
            while (this._writeRequested) {
                try {
                    ThreadLog.trace((String)"waiting for other writer to finish");
                    this.wait();
                    ThreadLog.trace((String)"waking up");
                }
                catch (InterruptedException ignore) {}
            }
            this._writeRequested = true;
            while (this._readingThreads > 0) {
                try {
                    ThreadLog.trace((String)"Waiting for readers to finish");
                    this.wait();
                    ThreadLog.trace((String)"waking up");
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _releaseWriteLock() {
        SyncRdfRepository syncRdfRepository = this;
        synchronized (syncRdfRepository) {
            this._writeRequested = false;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _getReadLock() {
        SyncRdfRepository syncRdfRepository = this;
        synchronized (syncRdfRepository) {
            while (this._writeRequested) {
                try {
                    ThreadLog.trace((String)"Waiting for writer to finish");
                    this.wait();
                    ThreadLog.trace((String)"waking up");
                }
                catch (InterruptedException interruptedException) {}
            }
            ++this._readingThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _releaseReadLock() {
        SyncRdfRepository syncRdfRepository = this;
        synchronized (syncRdfRepository) {
            --this._readingThreads;
            if (this._readingThreads == 0) {
                this.notifyAll();
            }
        }
    }
}

