/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sailimpl.rdbms;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.sesame.sail.LiteralIterator;
import org.openrdf.sesame.sail.SailInitializationException;
import org.openrdf.sesame.sail.SailInternalException;
import org.openrdf.sesame.sail.SailUpdateException;
import org.openrdf.sesame.sail.StatementIterator;
import org.openrdf.sesame.sail.query.DirectSubClassOf;
import org.openrdf.sesame.sail.query.DirectSubPropertyOf;
import org.openrdf.sesame.sail.query.DirectType;
import org.openrdf.sesame.sail.query.PathExpression;
import org.openrdf.sesame.sail.query.TriplePattern;
import org.openrdf.sesame.sail.util.EmptyLiteralIterator;
import org.openrdf.sesame.sail.util.EmptyStatementIterator;
import org.openrdf.sesame.sailimpl.rdbms.InferenceServices;
import org.openrdf.sesame.sailimpl.rdbms.RDBMS;
import org.openrdf.sesame.sailimpl.rdbms.RdbmsInferenceServices;
import org.openrdf.sesame.sailimpl.rdbms.RdfRepository;
import org.openrdf.sesame.sailimpl.rdbms.TableNames;
import org.openrdf.sesame.sailimpl.rdbms.iterators.RdbmsLiteralIterator;
import org.openrdf.sesame.sailimpl.rdbms.iterators.RdbmsStatementIterator;
import org.openrdf.util.log.ThreadLog;

public class RdfSchemaRepository
extends RdfRepository
implements org.openrdf.sesame.sail.RdfSchemaRepository,
TableNames {
    public static final String INFERENCER_KEY = "use-inferencer";
    public static final String USE_DEPENDENCY_INFERENCER_KEY = "dependency-inferencing";
    protected InferenceServices _inferencer = null;
    protected boolean _useDependencyInferencer = true;
    public int rdfTypeId;
    public int rdfPropertyId;
    public int rdfXMLLiteralId;
    public int rdfStatementId;
    public int rdfSubjectId;
    public int rdfPredicateId;
    public int rdfObjectId;
    public int rdfAltId;
    public int rdfBagId;
    public int rdfSeqId;
    public int rdfListId;
    public int rdfFirstId;
    public int rdfRestId;
    public int rdfNilId;
    public int rdfValueId;
    public int rdfsResourceId;
    public int rdfsLiteralId;
    public int rdfsClassId;
    public int rdfsSubClassOfId;
    public int rdfsSubPropertyOfId;
    public int rdfsDomainId;
    public int rdfsRangeId;
    public int rdfsCommentId;
    public int rdfsLabelId;
    public int rdfsDatatypeId;
    public int rdfsContainerId;
    public int rdfsMemberId;
    public int rdfsContainerMembershipPropertyId;
    public int rdfsIsDefinedById;
    public int rdfsSeeAlsoId;

    public void initialize(Map configParams) throws SailInitializationException {
        ThreadLog.trace((String)"Initializing RdfSchemaRepository...");
        String inferencerClass = (String)configParams.get(INFERENCER_KEY);
        String useDependencyInferencer = (String)configParams.get(USE_DEPENDENCY_INFERENCER_KEY);
        this._useDependencyInferencer = !"no".equalsIgnoreCase(useDependencyInferencer) && !"false".equalsIgnoreCase(useDependencyInferencer) && !"off".equalsIgnoreCase(useDependencyInferencer);
        ThreadLog.trace((String)("Dependency inferencer used: " + this._useDependencyInferencer));
        if (inferencerClass != null) {
            try {
                this._inferencer = (InferenceServices)Class.forName(inferencerClass).newInstance();
                this._inferencer.setDependencyInferencer(this._useDependencyInferencer);
                ThreadLog.trace((String)("Using inferencer: " + inferencerClass));
            }
            catch (InstantiationException e) {
                throw new SailInternalException(e);
            }
            catch (IllegalAccessException e) {
                throw new SailInternalException(e);
            }
            catch (ClassNotFoundException e) {
                throw new SailInternalException(e);
            }
            catch (ClassCastException e) {
                throw new SailInternalException("The provided class '" + inferencerClass + "' does not implement the '" + InferenceServices.class.getName() + "' interface", e);
            }
        }
        if (this._inferencer == null) {
            ThreadLog.trace((String)"No inferencer specified, using default RDF MT inferencer");
            this._inferencer = new RdbmsInferenceServices(this._useDependencyInferencer);
        }
        this._inferencer.initialize(this, configParams);
        super.initialize(configParams);
        this._inferencer.afterInitialize();
        try {
            this._initRdfSchema();
        }
        catch (SQLException e) {
            throw new SailInitializationException(e);
        }
        ThreadLog.trace((String)"RdfSchemaRepository initialized.");
    }

    protected void _initRdfSchema() throws SQLException {
        this._initRdfPrimitives();
        this._inferencer.initRdfSchema();
        this._rdbms.optimizeTable("allnewtriples");
        this._inferencer.markAxioms();
        this._updateAuxiliaryTables();
        this._rdbms.clearTable("allnewtriples");
        this._setExportStatusUpToDate(false);
    }

    protected void _initRdfPrimitives() {
        this.rdfTypeId = this._insertURI(URIImpl.RDF_TYPE);
        this.rdfPropertyId = this._insertURI(URIImpl.RDF_PROPERTY);
        this.rdfXMLLiteralId = this._insertURI(URIImpl.RDF_XMLLITERAL);
        this.rdfSubjectId = this._insertURI(URIImpl.RDF_SUBJECT);
        this.rdfPredicateId = this._insertURI(URIImpl.RDF_PREDICATE);
        this.rdfObjectId = this._insertURI(URIImpl.RDF_OBJECT);
        this.rdfStatementId = this._insertURI(URIImpl.RDF_STATEMENT);
        this.rdfAltId = this._insertURI(URIImpl.RDF_ALT);
        this.rdfBagId = this._insertURI(URIImpl.RDF_BAG);
        this.rdfSeqId = this._insertURI(URIImpl.RDF_SEQ);
        this.rdfListId = this._insertURI(URIImpl.RDF_LIST);
        this.rdfFirstId = this._insertURI(URIImpl.RDF_FIRST);
        this.rdfRestId = this._insertURI(URIImpl.RDF_REST);
        this.rdfNilId = this._insertURI(URIImpl.RDF_NIL);
        this.rdfValueId = this._insertURI(URIImpl.RDF_VALUE);
        this.rdfsResourceId = this._insertURI(URIImpl.RDFS_RESOURCE);
        this.rdfsClassId = this._insertURI(URIImpl.RDFS_CLASS);
        this.rdfsLiteralId = this._insertURI(URIImpl.RDFS_LITERAL);
        this.rdfsSubClassOfId = this._insertURI(URIImpl.RDFS_SUBCLASSOF);
        this.rdfsSubPropertyOfId = this._insertURI(URIImpl.RDFS_SUBPROPERTYOF);
        this.rdfsDomainId = this._insertURI(URIImpl.RDFS_DOMAIN);
        this.rdfsRangeId = this._insertURI(URIImpl.RDFS_RANGE);
        this.rdfsCommentId = this._insertURI(URIImpl.RDFS_COMMENT);
        this.rdfsLabelId = this._insertURI(URIImpl.RDFS_LABEL);
        this.rdfsIsDefinedById = this._insertURI(URIImpl.RDFS_ISDEFINEDBY);
        this.rdfsSeeAlsoId = this._insertURI(URIImpl.RDFS_SEEALSO);
        this.rdfsDatatypeId = this._insertURI(URIImpl.RDFS_DATATYPE);
        this.rdfsContainerId = this._insertURI(URIImpl.RDFS_CONTAINER);
        this.rdfsMemberId = this._insertURI(URIImpl.RDFS_MEMBER);
        this.rdfsContainerMembershipPropertyId = this._insertURI(URIImpl.RDFS_CONTAINERMEMBERSHIPPROPERTY);
        try {
            this.changeNamespacePrefix("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "rdf");
        }
        catch (SailUpdateException e) {
            // empty catch block
        }
        try {
            this.changeNamespacePrefix("http://www.w3.org/2000/01/rdf-schema#", "rdfs");
        }
        catch (SailUpdateException sailUpdateException) {
            // empty catch block
        }
    }

    protected int _insertURI(URI r) {
        int id = this._getURIId(r);
        if (id == 0) {
            id = this._getNextResourceId();
            int nsId = this._createIdForNamespace(r.getNamespace());
            String lname = this._rdbms.escapeString(r.getLocalName());
            try {
                this._rdbms.executeUpdate("INSERT INTO resources VALUES(" + id + ", " + nsId + ", '" + lname + "')");
            }
            catch (SQLException e) {
                throw new SailInternalException(e);
            }
        }
        return id;
    }

    protected void _createDbSchema() throws SQLException {
        super._createDbSchema();
        if (this._schemaVersion == -1) {
            this._createOneIdColumnTable("class", "id");
            this._createOneIdColumnTable("property", "id");
            this._createTwoIdColumnsTable("subclassof", "sub", "super");
            this._createTwoIdColumnsTable("direct_subclassof", "sub", "super");
            this._createTwoIdColumnsTable("subpropertyof", "sub", "super");
            this._createTwoIdColumnsTable("direct_subpropertyof", "sub", "super");
            this._createTwoIdColumnsTable("instanceof", "inst", "class");
            this._createTwoIdColumnsTable("proper_instanceof", "inst", "class");
            this._createTwoIdColumnsTable("domain", "property", "class");
            this._createTwoIdColumnsTable("range", "property", "class");
        }
        this._createAllNewTriplesTable();
        this._createInferredTriplesTable();
        this._createAllInferredTriplesTable();
        if (this._useDependencyInferencer) {
            this._createDependenciesTable();
            this._createGroundedTriplesTable();
            this._createNewGroundedTriplesTable();
        }
    }

    protected void _createOneIdColumnTable(String tableName, String colName) throws SQLException {
        this._rdbms.executeUpdate("CREATE TABLE " + tableName + " (" + colName + " " + this._rdbms.ID_INT + " NOT NULL PRIMARY KEY)");
    }

    protected void _createTwoIdColumnsTable(String tableName, String col1, String col2) throws SQLException {
        this._rdbms.executeUpdate("CREATE TABLE " + tableName + " (" + col1 + " " + this._rdbms.ID_INT + " NOT NULL, " + col2 + " " + this._rdbms.ID_INT + " NOT NULL, " + "PRIMARY KEY(" + col1 + ", " + col2 + "))");
        this._rdbms.createIndex(tableName, col2);
    }

    protected void _createAllNewTriplesTable() throws SQLException {
        if (this._schemaVersion == -1) {
            this._createTriplesTable("allnewtriples", true);
            this._rdbms.createIndex("allnewtriples", new String[]{"pred", "obj"}, false);
            this._rdbms.createIndex("allnewtriples", new String[]{"obj", "subj"}, false);
        } else {
            if (this._schemaVersion < 4) {
                this._rdbms.renameTableColumn("allnewtriples", "subject", "subj", this._rdbms.ID_INT + " NOT NULL");
                this._rdbms.renameTableColumn("allnewtriples", "predicate", "pred", this._rdbms.ID_INT + " NOT NULL");
                this._rdbms.renameTableColumn("allnewtriples", "object", "obj", this._rdbms.ID_INT + " NOT NULL");
            }
            if (this._schemaVersion < 6) {
                this._rdbms.dropIndex("allnewtriples", "subj");
                this._rdbms.dropIndex("allnewtriples", "pred");
                this._rdbms.dropIndex("allnewtriples", "obj");
                this._rdbms.createIndex("allnewtriples", new String[]{"pred", "obj"}, false);
                this._rdbms.createIndex("allnewtriples", new String[]{"obj", "subj"}, false);
            }
        }
    }

    protected void _createInferredTriplesTable() throws SQLException {
        if (this._schemaVersion == -1) {
            this._createTriplesTable("inferred", false);
        } else if (this._schemaVersion < 4) {
            this._rdbms.renameTableColumn("inferred", "subject", "subj", this._rdbms.ID_INT + " NOT NULL");
            this._rdbms.renameTableColumn("inferred", "predicate", "pred", this._rdbms.ID_INT + " NOT NULL");
            this._rdbms.renameTableColumn("inferred", "object", "obj", this._rdbms.ID_INT + " NOT NULL");
        }
    }

    protected void _createAllInferredTriplesTable() throws SQLException {
        if (this._schemaVersion == -1) {
            this._createTriplesTable("allinferred", false);
        } else if (this._schemaVersion < 4) {
            this._rdbms.renameTableColumn("allinferred", "subject", "subj", this._rdbms.ID_INT + " NOT NULL");
            this._rdbms.renameTableColumn("allinferred", "predicate", "pred", this._rdbms.ID_INT + " NOT NULL");
            this._rdbms.renameTableColumn("allinferred", "object", "obj", this._rdbms.ID_INT + " NOT NULL");
        }
    }

    protected void _createDependenciesTable() throws SQLException {
        if (this._schemaVersion == -1) {
            this._inferencer.createDependenciesTable();
        }
    }

    protected void _createGroundedTriplesTable() throws SQLException {
        if (this._schemaVersion == -1) {
            this._rdbms.executeUpdate("CREATE TABLE groundedtriples (id " + this._rdbms.ID_INT + " NOT NULL PRIMARY KEY)");
        }
    }

    protected void _createNewGroundedTriplesTable() throws SQLException {
        if (this._schemaVersion == -1) {
            this._rdbms.executeUpdate("CREATE TABLE newgroundedtriples (id " + this._rdbms.ID_INT + " NOT NULL PRIMARY KEY)");
        }
    }

    public void clearRepository() throws SailUpdateException {
        super.clearRepository();
        try {
            this._rdbms.clearTable("class");
            this._rdbms.clearTable("property");
            this._rdbms.clearTable("subclassof");
            this._rdbms.clearTable("direct_subclassof");
            this._rdbms.clearTable("subpropertyof");
            this._rdbms.clearTable("direct_subpropertyof");
            this._rdbms.clearTable("instanceof");
            this._rdbms.clearTable("proper_instanceof");
            this._rdbms.clearTable("domain");
            this._rdbms.clearTable("range");
            this._rdbms.clearTable("allnewtriples");
            this._rdbms.clearTable("inferred");
            this._rdbms.clearTable("allinferred");
            if (this._useDependencyInferencer) {
                this._rdbms.clearTable("depend");
                this._rdbms.clearTable("groundedtriples");
                this._rdbms.clearTable("newgroundedtriples");
            }
        }
        catch (SQLException e) {
            throw new SailInternalException(e);
        }
        try {
            this._initRdfSchema();
        }
        catch (SQLException e) {
            throw new SailInternalException(e);
        }
    }

    protected void _processAddedTriples() throws SQLException {
        Connection con = this._rdbms.getConnection();
        Statement st = con.createStatement();
        ResultSet rs = st.executeQuery("SELECT t.id FROM triples t, addedtriples at WHERE t.subj = at.subj AND t.pred = at.pred AND t.obj = at.obj AND t.explicit = " + this._rdbms.FALSE);
        String[] idChunks = this._chunkIdSet(rs, 3500);
        rs.close();
        st.close();
        con.setAutoCommit(false);
        st = con.createStatement();
        for (int i = 0; i < idChunks.length; ++i) {
            st.executeUpdate("UPDATE triples SET explicit = " + this._rdbms.TRUE + " WHERE id IN " + idChunks[i]);
        }
        con.commit();
        st.close();
        con.close();
        super._processAddedTriples();
    }

    protected void _processChangedTriples() throws SQLException {
        int count = this._rdbms.copyRows("newtriples", "allnewtriples");
        if (count > 0) {
            this._inferencer.doInferencing();
            this._inferencer.processNewStatements();
        }
        this._rdbms.optimizeTable("allnewtriples");
        this._updateAuxiliaryTables();
        this._rdbms.clearTable("allnewtriples");
    }

    protected void _removeExpiredStatements() throws SQLException {
        this._inferencer.removeExpiredStatements();
    }

    protected void _updateAuxiliaryTables() throws SQLException {
        ThreadLog.trace((String)"Updating auxiliary tables");
        this._updateClasses();
        this._updateProperties();
        this._updateDomains();
        this._updateRanges();
        int addedSubClassesCount = this._updateSubClasses();
        this._updateSubProperties();
        this._updateInstanceOf(addedSubClassesCount > 0);
    }

    private void _updateClasses() throws SQLException {
        this._updateClassOrProperties("class", this.rdfsClassId);
    }

    private void _updateProperties() throws SQLException {
        this._updateClassOrProperties("property", this.rdfPropertyId);
    }

    private void _updateClassOrProperties(String tableName, int objectId) throws SQLException {
        int count;
        String sourceTable = "allnewtriples";
        if (this._statementsRemoved) {
            sourceTable = "triples";
            this._rdbms.clearTable(tableName);
        }
        if ((count = this._rdbms.executeUpdate("INSERT INTO " + tableName + " SELECT subj FROM " + sourceTable + " WHERE pred = " + this.rdfTypeId + " AND obj = " + objectId)) > 0 || this._statementsRemoved) {
            this._rdbms.optimizeTable(tableName);
        }
    }

    private void _updateDomains() throws SQLException {
        this._updateDomainsOrRanges("domain", this.rdfsDomainId);
    }

    private void _updateRanges() throws SQLException {
        this._updateDomainsOrRanges("range", this.rdfsRangeId);
    }

    private void _updateDomainsOrRanges(String tableName, int predicateId) throws SQLException {
        int count;
        String sourceTable = "allnewtriples";
        if (this._statementsRemoved) {
            sourceTable = "triples";
            this._rdbms.clearTable(tableName);
        }
        if ((count = this._rdbms.executeUpdate("INSERT INTO " + tableName + " SELECT subj, obj FROM " + sourceTable + " WHERE pred = " + predicateId)) > 0 || this._statementsRemoved) {
            this._rdbms.optimizeTable(tableName);
        }
    }

    private int _updateSubClasses() throws SQLException {
        return this._updateSubClassesOrProperties("subclassof", "direct_subclassof", this.rdfsSubClassOfId);
    }

    private int _updateSubProperties() throws SQLException {
        return this._updateSubClassesOrProperties("subpropertyof", "direct_subpropertyof", this.rdfsSubPropertyOfId);
    }

    private int _updateSubClassesOrProperties(String allTable, String directTable, int propId) throws SQLException {
        int count;
        String sourceTable = "allnewtriples";
        if (this._statementsRemoved) {
            sourceTable = "triples";
            this._rdbms.clearTable(allTable);
        }
        if ((count = this._rdbms.executeUpdate("INSERT INTO " + allTable + " SELECT subj, obj FROM " + sourceTable + " WHERE pred = " + propId)) > 0 || this._statementsRemoved) {
            this._rdbms.optimizeTable(allTable);
            this._rdbms.clearTable(directTable);
            this._rdbms.executeUpdate("CREATE TABLE noncycles (sub " + this._rdbms.ID_INT + " NOT NULL, " + "super " + this._rdbms.ID_INT + " NOT NULL, " + "UNIQUE(sub, super))");
            this._rdbms.executeUpdate("INSERT INTO noncycles SELECT s1.* FROM " + allTable + " s1 " + "LEFT JOIN " + allTable + " s2 " + "ON s1.sub = s2.super AND s1.super = s2.sub " + "WHERE s2.sub IS NULL");
            this._rdbms.optimizeTable("noncycles");
            this._rdbms.executeUpdate("INSERT INTO " + directTable + " SELECT nc1.*" + " FROM noncycles nc1" + " LEFT JOIN noncycles nc2" + " ON nc1.sub = nc2.sub" + " LEFT JOIN noncycles nc3" + " ON nc3.sub = nc2.super AND nc3.super = nc1.super" + " GROUP BY nc1.sub, nc1.super" + " HAVING count(nc3.sub) = 0");
            this._rdbms.optimizeTable(directTable);
            this._rdbms.dropTable("noncycles");
        }
        return count;
    }

    protected void _updateInstanceOf(boolean newSubClassesAdded) throws SQLException {
        int count;
        String sourceTable = "allnewtriples";
        if (this._statementsRemoved) {
            sourceTable = "triples";
            this._rdbms.clearTable("instanceof");
        }
        if ((count = this._rdbms.executeUpdate("INSERT INTO instanceof SELECT subj, obj FROM " + sourceTable + " WHERE pred = " + this.rdfTypeId)) > 0 || newSubClassesAdded || this._statementsRemoved) {
            this._rdbms.optimizeTable("instanceof");
            this._rdbms.clearTable("proper_instanceof");
            this._rdbms.executeUpdate("INSERT INTO proper_instanceof SELECT type.inst, type.class FROM instanceof type LEFT JOIN instanceof subtype ON subtype.inst = type.inst LEFT JOIN direct_subclassof dsco ON type.class = dsco.super AND subtype.class = dsco.sub GROUP BY type.inst, type.class HAVING count(dsco.sub) = 0");
            this._rdbms.optimizeTable("proper_instanceof");
        }
    }

    protected void _updateExportedNamespaces() {
        ThreadLog.trace((String)"Updating exported namespaces information.");
        try {
            this._rdbms.executeUpdate("UPDATE namespaces SET export = " + this._rdbms.FALSE + " WHERE userDefined = " + this._rdbms.FALSE);
            Connection con = this._rdbms.getConnection();
            Statement st = con.createStatement();
            ResultSet rs = st.executeQuery("SELECT DISTINCT r.namespace FROM resources r, triples t WHERE t.subj = r.id AND t.pred = " + this.rdfTypeId + " " + "AND t.obj = " + this.rdfPropertyId);
            String[] idChunks = this._chunkIdSet(rs, 3500);
            rs.close();
            st.close();
            con.setAutoCommit(false);
            st = con.createStatement();
            for (int i = 0; i < idChunks.length; ++i) {
                st.executeUpdate("UPDATE namespaces SET export = " + this._rdbms.TRUE + " WHERE id IN " + idChunks[i]);
            }
            con.commit();
            st.close();
            con.close();
            this._setExportStatusUpToDate(true);
            this._initNamespaceCache();
        }
        catch (SQLException e) {
            throw new SailInternalException(e);
        }
    }

    public StatementIterator getExplicitStatements(Resource subj, URI pred, Value obj) {
        return super.getStatements(subj, pred, obj, true);
    }

    public boolean hasExplicitStatement(Resource subj, URI pred, Value obj) {
        return super.hasStatement(subj, pred, obj, true);
    }

    public StatementIterator getClasses() {
        return this._queryOneColumnTable("class", "id", URIImpl.RDF_TYPE, (Resource)URIImpl.RDFS_CLASS);
    }

    public boolean isClass(Resource resource) {
        return this._isRowInOneColumnTable("class", "id", resource);
    }

    public StatementIterator getProperties() {
        return this._queryOneColumnTable("property", "id", URIImpl.RDF_TYPE, (Resource)URIImpl.RDF_PROPERTY);
    }

    public boolean isProperty(Resource resource) {
        return this._isRowInOneColumnTable("property", "id", resource);
    }

    public StatementIterator getSubClassOf(Resource subClass, Resource superClass) {
        return this._queryTwoColumnTable("subclassof", "sub", "super", subClass, URIImpl.RDFS_SUBCLASSOF, superClass);
    }

    public StatementIterator getDirectSubClassOf(Resource subClass, Resource superClass) {
        return this._queryTwoColumnTable("direct_subclassof", "sub", "super", subClass, URIImpl.RDFS_SUBCLASSOF, superClass);
    }

    public boolean isSubClassOf(Resource subClass, Resource superClass) {
        return this._isRowInTwoColumnTable("subclassof", "sub", "super", subClass, superClass);
    }

    public boolean isDirectSubClassOf(Resource subClass, Resource superClass) {
        return this._isRowInTwoColumnTable("direct_subclassof", "sub", "super", subClass, superClass);
    }

    public StatementIterator getSubPropertyOf(Resource subProperty, Resource superProperty) {
        return this._queryTwoColumnTable("subpropertyof", "sub", "super", subProperty, URIImpl.RDFS_SUBPROPERTYOF, superProperty);
    }

    public StatementIterator getDirectSubPropertyOf(Resource subProperty, Resource superProperty) {
        return this._queryTwoColumnTable("direct_subpropertyof", "sub", "super", subProperty, URIImpl.RDFS_SUBPROPERTYOF, superProperty);
    }

    public boolean isSubPropertyOf(Resource subProperty, Resource superProperty) {
        return this._isRowInTwoColumnTable("subpropertyof", "sub", "super", subProperty, superProperty);
    }

    public boolean isDirectSubPropertyOf(Resource subProperty, Resource superProperty) {
        return this._isRowInTwoColumnTable("direct_subpropertyof", "sub", "super", subProperty, superProperty);
    }

    public StatementIterator getDomain(Resource prop, Resource domain) {
        return this._queryTwoColumnTable("domain", "property", "class", prop, URIImpl.RDFS_DOMAIN, domain);
    }

    public StatementIterator getRange(Resource prop, Resource domain) {
        return this._queryTwoColumnTable("range", "property", "class", prop, URIImpl.RDFS_DOMAIN, domain);
    }

    public StatementIterator getType(Resource anInstance, Resource aClass) {
        return this._queryTwoColumnTable("instanceof", "inst", "class", anInstance, URIImpl.RDF_TYPE, aClass);
    }

    public StatementIterator getDirectType(Resource anInstance, Resource aClass) {
        return this._queryTwoColumnTable("proper_instanceof", "inst", "class", anInstance, URIImpl.RDF_TYPE, aClass);
    }

    public boolean isType(Resource anInstance, Resource aClass) {
        return this._isRowInTwoColumnTable("instanceof", "inst", "class", anInstance, aClass);
    }

    public boolean isDirectType(Resource anInstance, Resource aClass) {
        return this._isRowInTwoColumnTable("proper_instanceof", "inst", "class", anInstance, aClass);
    }

    public LiteralIterator getLiterals(String label, String language, URI datatype) {
        int datatypeId = 0;
        if (datatype != null && (datatypeId = this._getURIId(datatype)) == 0) {
            return new EmptyLiteralIterator();
        }
        String query = "SELECT l.id, dt.id, dt.namespace, dt.localname, l.language, l.label FROM literals l, resources dt WHERE l.datatype = dt.id";
        boolean firstPartWritten = false;
        if (label != null) {
            long labelHash = this._getLabelHash(label);
            query = query + " l.labelHash = " + labelHash;
            query = query + " AND l.label ";
            query = this._rdbms.emptyStringIsNull() && label.length() == 0 ? query + "IS NULL" : query + "= '" + this._rdbms.escapeString(label) + "'";
            firstPartWritten = true;
        }
        if (language != null && datatype == null) {
            if (firstPartWritten) {
                query = query + " AND";
            }
            query = query + " l.language = '" + this._rdbms.escapeString(language) + "'";
            firstPartWritten = true;
        }
        if (datatype != null) {
            if (firstPartWritten) {
                query = query + " AND";
            }
            query = query + "dt.id = " + datatypeId;
        }
        try {
            Connection con = this._rdbms.getConnection();
            return new RdbmsLiteralIterator(this, this._namespaceNames, con, query);
        }
        catch (SQLException e) {
            throw new SailInternalException(e);
        }
    }

    protected StatementIterator _queryOneColumnTable(String tableName, String colName, URI prop, Resource obj) {
        String query = "SELECT r.id, r.namespace, r.localname FROM " + tableName + " t, " + "resources" + " r " + "WHERE t." + colName + " = r.id";
        try {
            Connection con = this._rdbms.getConnection();
            return new RdbmsStatementIterator(this, this._namespaceNames, con, query, null, null, prop, (Value)obj);
        }
        catch (SQLException e) {
            throw new SailInternalException(e);
        }
    }

    protected boolean _isRowInOneColumnTable(String tableName, String colName, Resource val) {
        int id = this._getResourceId(val);
        if (id == 0) {
            return false;
        }
        String query = "SELECT * FROM " + tableName + " WHERE " + colName + " = " + id;
        try {
            return this._rdbms.queryHasResults(query);
        }
        catch (SQLException e) {
            throw new SailInternalException(e);
        }
    }

    protected StatementIterator _queryTwoColumnTable(String tableName, String col1Name, String col2Name, Resource val1, URI prop, Resource val2) {
        int id1 = 0;
        int id2 = 0;
        if (val1 != null && (id1 = this._getResourceId(val1)) == 0) {
            return new EmptyStatementIterator();
        }
        if (val2 != null && (id2 = this._getResourceId(val2)) == 0) {
            return new EmptyStatementIterator();
        }
        String select = "SELECT ";
        String from = " FROM " + tableName + " t";
        String where = " WHERE ";
        if (id1 != 0) {
            where = where + "t." + col1Name + " = " + id1;
        } else {
            select = select + "r1.id, r1.namespace, r1.localname";
            from = from + ", resources r1";
            where = where + "t." + col1Name + " = r1.id";
        }
        if (id2 != 0) {
            where = where + " AND t." + col2Name + " = " + id2;
        } else {
            if (id1 == 0) {
                select = select + ", ";
            }
            select = select + "r2.id, r2.namespace, r2.localname";
            from = from + ", resources r2";
            where = where + " AND t." + col2Name + " = r2.id";
        }
        if (id1 != 0 && id2 != 0) {
            select = select + "*";
        }
        String query = select + from + where;
        try {
            Connection con = this._rdbms.getConnection();
            return new RdbmsStatementIterator(this, this._namespaceNames, con, query, null, val1, prop, (Value)val2);
        }
        catch (SQLException e) {
            throw new SailInternalException(e);
        }
    }

    protected boolean _isRowInTwoColumnTable(String tableName, String col1Name, String col2Name, Resource val1, Resource val2) {
        int id1 = this._getResourceId(val1);
        if (id1 == 0) {
            return false;
        }
        int id2 = this._getResourceId(val2);
        if (id2 == 0) {
            return false;
        }
        String query = "SELECT * FROM " + tableName + " WHERE " + col1Name + " = " + id1 + " AND " + col2Name + " = " + id2;
        try {
            return this._rdbms.queryHasResults(query);
        }
        catch (SQLException e) {
            throw new SailInternalException(e);
        }
    }

    protected PathExpression _convertPathExpressionToSQL(PathExpression pathExpr, String peId, StringBuffer from, StringBuffer where, Map varToSqlIdMapping) {
        if (pathExpr instanceof DirectType) {
            DirectType dt = (DirectType)pathExpr;
            from.append(", proper_instanceof " + peId);
            this._processPathExpressionVar(dt.getSubjectVar(), peId + ".inst", where, varToSqlIdMapping);
            this._processPathExpressionVar(dt.getObjectVar(), peId + ".class", where, varToSqlIdMapping);
            return null;
        }
        if (pathExpr instanceof DirectSubClassOf) {
            DirectSubClassOf dsco = (DirectSubClassOf)pathExpr;
            from.append(", direct_subclassof " + peId);
            this._processPathExpressionVar(dsco.getSubjectVar(), peId + ".sub", where, varToSqlIdMapping);
            this._processPathExpressionVar(dsco.getObjectVar(), peId + ".super", where, varToSqlIdMapping);
            return null;
        }
        if (pathExpr instanceof DirectSubPropertyOf) {
            DirectSubPropertyOf dspo = (DirectSubPropertyOf)pathExpr;
            from.append(", direct_subpropertyof " + peId);
            this._processPathExpressionVar(dspo.getSubjectVar(), peId + ".sub", where, varToSqlIdMapping);
            this._processPathExpressionVar(dspo.getObjectVar(), peId + ".super", where, varToSqlIdMapping);
            return null;
        }
        if (pathExpr instanceof TriplePattern) {
            TriplePattern tp = (TriplePattern)pathExpr;
            Value predicate = tp.getPredicateVar().getValue();
            if (URIImpl.RDF_TYPE.equals(predicate)) {
                from.append(", instanceof " + peId);
                this._processPathExpressionVar(tp.getSubjectVar(), peId + ".inst", where, varToSqlIdMapping);
                this._processPathExpressionVar(tp.getObjectVar(), peId + ".class", where, varToSqlIdMapping);
                return null;
            }
            if (URIImpl.RDFS_SUBCLASSOF.equals(predicate)) {
                from.append(", subclassof " + peId);
                this._processPathExpressionVar(tp.getSubjectVar(), peId + ".sub", where, varToSqlIdMapping);
                this._processPathExpressionVar(tp.getObjectVar(), peId + ".super", where, varToSqlIdMapping);
                return null;
            }
            if (URIImpl.RDFS_SUBPROPERTYOF.equals(predicate)) {
                from.append(", subpropertyof " + peId);
                this._processPathExpressionVar(tp.getSubjectVar(), peId + ".sub", where, varToSqlIdMapping);
                this._processPathExpressionVar(tp.getObjectVar(), peId + ".super", where, varToSqlIdMapping);
                return null;
            }
        }
        return super._convertPathExpressionToSQL(pathExpr, peId, from, where, varToSqlIdMapping);
    }

    public RDBMS getRDBMS() {
        return this._rdbms;
    }
}

