/*
 * Decompiled with CFR 0.152.
 */
package thredds.inventory;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.CollectionManager;
import thredds.inventory.CollectionManagerAbstract;
import thredds.inventory.CollectionSpecParser;
import thredds.inventory.MCollection;
import thredds.inventory.MController;
import thredds.inventory.MFile;
import thredds.inventory.MFileCollectionManager;
import thredds.inventory.MFileFilter;
import thredds.inventory.filter.WildcardMatchOnName;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateFormatter;
import ucar.nc2.time.CalendarPeriod;

public class TimePartitionCollection
extends MFileCollectionManager {
    private Type type;

    public static TimePartitionCollection factory(FeatureCollectionConfig config, Formatter errlog, Logger logger) {
        if (config.timePartition == null) {
            throw new IllegalArgumentException("Must specify time partition spec = " + config.spec);
        }
        return new TimePartitionCollection(config, errlog, logger);
    }

    public static TimePartitionCollection fromExistingIndices(FeatureCollectionConfig config, Formatter errlog, Logger logger) {
        if (config.timePartition == null) {
            throw new IllegalArgumentException("Must specify time partition spec = " + config.spec);
        }
        return new TimePartitionCollection(config, errlog, logger);
    }

    private TimePartitionCollection(FeatureCollectionConfig config, Formatter errlog, Logger logger) {
        super(config, errlog, logger);
        if (this.dateExtractor == null) {
            throw new IllegalArgumentException("Time partition must specify a date extractor");
        }
    }

    public List<CollectionManager> makePartitions() throws IOException {
        List<CollectionManager> result = this.config.timePartition.equalsIgnoreCase("directory") ? this.makePartitionsFromSubdirs() : this.makePartitionsByPeriod();
        return result;
    }

    private List<CollectionManager> makePartitionsFromSubdirs() throws IOException {
        this.type = Type.directory;
        MController controller = MFileCollectionManager.getController();
        Formatter errlog = new Formatter();
        CollectionSpecParser sp = new CollectionSpecParser(this.config.spec, errlog);
        MCollection mc = new MCollection(sp.getRootDir(), sp.getRootDir(), false, (MFileFilter)null, null);
        File root = new File(sp.getRootDir());
        if (!root.exists()) {
            this.logger.error("TimePartitionCollections root = {} does not exist ", (Object)sp.getRootDir());
            return null;
        }
        Iterator<MFile> iter = controller.getSubdirs(mc, true);
        if (iter == null) {
            this.logger.error("TimePartitionCollections Invalid collection, no subdirectories found; root = {}, collection= {} ", (Object)sp.getRootDir(), (Object)mc);
            return null;
        }
        ArrayList<MFileFilter> filters = new ArrayList<MFileFilter>(3);
        if (null != sp.getFilter()) {
            filters.add(new WildcardMatchOnName(sp.getFilter()));
        }
        ArrayList<CollectionManager> result = new ArrayList<CollectionManager>();
        while (iter.hasNext()) {
            MFile mfile = iter.next();
            MCollection mcs = new MCollection(mfile.getName(), mfile.getPath(), sp.wantSubdirs(), filters, null);
            CalendarDate cdate = this.dateExtractor.getCalendarDate(mfile);
            if (cdate == null) {
                this.logger.error("TimePartitionCollections dateExtractor = {} not working on mfile = {} ", (Object)this.dateExtractor, (Object)mfile.getPath());
                return null;
            }
            String name = mfile.getName();
            MFileCollectionManager dcm = new MFileCollectionManager(name, mcs, cdate, this.logger);
            dcm.setDateExtractor(this.dateExtractor);
            if (this.config != null && this.config.gribConfig != null) {
                dcm.putAuxInfo("gribConfig", this.config.gribConfig);
            }
            dcm.scan(false);
            result.add(dcm);
        }
        Collections.sort(result, new Comparator<CollectionManager>(){

            @Override
            public int compare(CollectionManager o1, CollectionManager o2) {
                return o1.getStartCollection().compareTo(o2.getStartCollection());
            }
        });
        return result;
    }

    private List<CollectionManager> makePartitionsByPeriod() throws IOException {
        this.type = Type.timePeriod;
        ArrayList<DatedMFile> files = new ArrayList<DatedMFile>();
        for (MFile mfile : this.getFiles()) {
            CalendarDate cdate = this.dateExtractor.getCalendarDate(mfile);
            if (cdate == null) {
                this.logger.error("Date extraction failed on file= {} dateExtractor = {}", (Object)mfile.getPath(), (Object)this.dateExtractor);
            }
            files.add(new DatedMFile(mfile, cdate));
        }
        Collections.sort(files);
        CalendarDateFormatter cdf = new CalendarDateFormatter("yyyyMMdd");
        ArrayList<CollectionManager> result = new ArrayList<CollectionManager>();
        TimePartitionCollectionManager curr = null;
        for (DatedMFile dmf : files) {
            if (curr == null || !curr.endPartition.isAfter(dmf.cdate)) {
                CalendarPeriod period = CalendarPeriod.of(this.config.timePartition);
                CalendarDate start = dmf.cdate.truncate(period.getField());
                CalendarDate end = start.add(period);
                String name = this.collectionName + "-" + cdf.toString(dmf.cdate);
                curr = new TimePartitionCollectionManager(name, start, end, this.getRoot(), this.auxInfo, this.logger);
                result.add(curr);
            }
            curr.add(dmf);
        }
        return result;
    }

    @Override
    public CalendarDate getStartCollection() {
        return null;
    }

    @Override
    public String toString() {
        return "TimePartitionCollection{name='" + this.collectionName + '\'' + ", dateExtractor=" + this.dateExtractor + ", type=" + (Object)((Object)this.type) + '}';
    }

    private static void doit(FeatureCollectionConfig config) throws IOException {
        TimePartitionCollection tpc = TimePartitionCollection.factory(config, new Formatter(System.out), null);
        System.out.printf("tpc = %s%n", tpc);
        if (tpc.makePartitions() == null) {
            System.out.printf("*** No partitions%n", new Object[0]);
            return;
        }
        List<CollectionManager> m = tpc.makePartitions();
        for (CollectionManager dcm : m) {
            System.out.printf(" dcm = %s timePartition=%s %n", dcm, dcm.getStartCollection());
        }
        System.out.printf("-----------------------------------%n", new Object[0]);
    }

    public static void main(String[] args) throws IOException {
        FeatureCollectionConfig config = new FeatureCollectionConfig();
        config.spec = "G:/nomads/cfsr/timeseries/**/.*grb2$";
        config.dateFormatMark = "#timeseries/#yyyyMM";
        config.timePartition = "true";
        config = new FeatureCollectionConfig();
        config.spec = "G:/mlode/gefs/.*grib2$";
        config.dateFormatMark = "#GEFS_Global_1p0deg_Ensemble_#yyyyMMdd_HHmm";
        config.timePartition = "day";
        config = new FeatureCollectionConfig();
        config.spec = "g:/mlode/SREF_CONUS_40km/.*grib2$";
        config.dateFormatMark = "yyyyMMdd_HHmm#.grib2#";
        config.timePartition = "day";
        config = new FeatureCollectionConfig();
        config.spec = "g:/mlode/radar/**/.*grib2$";
        config.dateFormatMark = "#radar/#yyyyMMdd";
        config.timePartition = "directory";
        TimePartitionCollection.doit(config);
    }

    private class TimePartitionCollectionManager
    extends CollectionManagerAbstract {
        final String root;
        final CalendarDate startPartition;
        final CalendarDate endPartition;
        List<MFile> files;

        TimePartitionCollectionManager(String name, CalendarDate start, CalendarDate end, String root, Map<String, Object> auxInfo, Logger logger) {
            super(name, logger);
            this.startPartition = start;
            this.endPartition = end;
            this.files = new ArrayList<MFile>();
            this.root = root;
            this.auxInfo = auxInfo;
        }

        void add(DatedMFile dmfile) {
            this.files.add(dmfile.mfile);
        }

        @Override
        public boolean isScanNeeded() {
            return false;
        }

        @Override
        public boolean scanIfNeeded() {
            return false;
        }

        @Override
        public boolean hasDateExtractor() {
            return true;
        }

        @Override
        public CalendarDate getStartCollection() {
            return this.startPartition;
        }

        @Override
        public boolean scan(boolean sendEvent) throws IOException {
            return false;
        }

        @Override
        public long getLastScanned() {
            return -1L;
        }

        @Override
        public long getLastChanged() {
            return -1L;
        }

        @Override
        public String getRoot() {
            return this.root;
        }

        @Override
        public Iterable<MFile> getFiles() {
            return this.files;
        }

        @Override
        public void setFiles(Iterable<MFile> files) {
            ArrayList<MFile> result = new ArrayList<MFile>();
            for (MFile f : files) {
                result.add(f);
            }
            this.files = result;
        }

        @Override
        public CalendarDate extractRunDate(MFile mfile) {
            return TimePartitionCollection.this.dateExtractor.getCalendarDate(mfile);
        }

        public String toString() {
            return "TimePartitionCollectionManager{name='" + this.collectionName + '\'' + ", startPartition=" + this.startPartition + ", endPartition=" + this.endPartition + '}';
        }
    }

    private class DatedMFile
    implements Comparable<DatedMFile> {
        MFile mfile;
        CalendarDate cdate;

        private DatedMFile(MFile mfile, CalendarDate cdate) {
            this.mfile = mfile;
            this.cdate = cdate;
        }

        @Override
        public int compareTo(DatedMFile o) {
            return this.cdate.compareTo(o.cdate);
        }
    }

    private static enum Type {
        setfromExistingIndices,
        directory,
        timePeriod;

    }
}

