/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.ows;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.geotools.data.ows.CRSEnvelope;
import org.geotools.data.ows.StyleImpl;
import org.geotools.data.wms.xml.Attribution;
import org.geotools.data.wms.xml.Dimension;
import org.geotools.data.wms.xml.Extent;
import org.geotools.data.wms.xml.MetadataURL;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

public class Layer
implements Comparable<Layer> {
    private String name;
    private Layer parent;
    private List<Layer> children = new ArrayList<Layer>();
    private String title;
    private String _abstract;
    private String[] keywords;
    private Set<String> srs = null;
    private List<CRSEnvelope> boundingBoxes = new ArrayList<CRSEnvelope>();
    private CRSEnvelope latLonBoundingBox = null;
    private List<StyleImpl> styles;
    private Boolean queryable = null;
    private int cascaded;
    private double scaleHintMin = Double.NaN;
    private double scaleHintMax = Double.NaN;
    private double scaleDenominatorMin = Double.NaN;
    private double scaleDenominatorMax = Double.NaN;
    private List<Dimension> dimensions = new ArrayList<Dimension>();
    private List<Extent> extents = new ArrayList<Extent>();
    private Set<String> allSRSCache = null;
    private Map<String, CRSEnvelope> allBoundingBoxesCache = null;
    private HashMap<String, Dimension> allDimensionsCache = null;
    private HashMap<String, Extent> allExtentsCache = null;
    private Map<CoordinateReferenceSystem, Envelope> envelopeCache = Collections.synchronizedMap(new WeakHashMap());
    private List<MetadataURL> metadataURL;
    private Attribution attribution;

    public void clearCache() {
        this.allSRSCache = null;
        this.allExtentsCache = null;
        this.allDimensionsCache = null;
        this.allBoundingBoxesCache = null;
        this.envelopeCache.clear();
        for (Layer child : this.children) {
            child.clearCache();
        }
    }

    public Layer() {
        this(null);
    }

    public Layer(String title) {
        this.title = title;
    }

    public List<CRSEnvelope> getLayerBoundingBoxes() {
        return this.boundingBoxes;
    }

    public synchronized Map<String, CRSEnvelope> getBoundingBoxes() {
        if (this.allBoundingBoxesCache == null) {
            this.allBoundingBoxesCache = new HashMap<String, CRSEnvelope>();
            for (CRSEnvelope bbox : this.getLayerBoundingBoxes()) {
                this.allBoundingBoxesCache.put(bbox.getSRSName(), bbox);
            }
            for (Layer parent = this.getParent(); parent != null && this.allBoundingBoxesCache.size() == 0; parent = parent.getParent()) {
                for (CRSEnvelope bbox : parent.getLayerBoundingBoxes()) {
                    this.allBoundingBoxesCache.put(bbox.getSRSName(), bbox);
                }
            }
        }
        return this.allBoundingBoxesCache;
    }

    public void setBoundingBoxes(CRSEnvelope boundingBox) {
        this.boundingBoxes.clear();
        this.boundingBoxes.add(boundingBox);
    }

    public void setBoundingBoxes(Map<String, CRSEnvelope> boundingBoxes) {
        this.boundingBoxes.clear();
        this.boundingBoxes.addAll(boundingBoxes.values());
    }

    public List<Dimension> getLayerDimensions() {
        return this.dimensions;
    }

    public synchronized Map<String, Dimension> getDimensions() {
        if (this.allDimensionsCache == null) {
            this.allDimensionsCache = new HashMap();
            for (Layer layer = this; layer != null; layer = layer.getParent()) {
                for (Dimension dimension : layer.getLayerDimensions()) {
                    this.allDimensionsCache.put(dimension.getName(), dimension);
                }
            }
        }
        return Collections.unmodifiableMap(this.allDimensionsCache);
    }

    public void setDimensions(Map<String, Dimension> dimensionMap) {
        this.dimensions.clear();
        if (dimensionMap != null) {
            this.dimensions.addAll(dimensionMap.values());
        }
        this.clearCache();
    }

    public void setDimensions(Collection<Dimension> dimensionList) {
        this.dimensions.clear();
        if (dimensionList != null) {
            this.dimensions.addAll(dimensionList);
        }
        this.clearCache();
    }

    public void setDimensions(Dimension dimension) {
        this.dimensions.clear();
        if (dimension != null) {
            this.dimensions.add(dimension);
        }
        this.clearCache();
    }

    public Dimension getDimension(String name) {
        return this.getDimensions().get(name);
    }

    public List<Extent> getLayerExtents() {
        return this.extents;
    }

    public synchronized Map<String, Extent> getExtents() {
        if (this.allExtentsCache == null) {
            this.allExtentsCache = new HashMap();
            for (Layer layer = this; layer != null; layer = layer.getParent()) {
                for (Extent extent : layer.getLayerExtents()) {
                    this.allExtentsCache.put(extent.getName(), extent);
                }
                for (Dimension dimension : layer.getLayerDimensions()) {
                    Extent extent = dimension.getExtent();
                    if (extent == null || extent.isEmpty()) continue;
                    this.allExtentsCache.put(extent.getName(), extent);
                }
            }
        }
        return Collections.unmodifiableMap(this.allExtentsCache);
    }

    public Extent getExtent(String name) {
        return this.getExtents().get(name);
    }

    public void setExtents(Map<String, Extent> extentMap) {
        this.extents.clear();
        if (extentMap != null) {
            this.extents.addAll(extentMap.values());
        }
        this.clearCache();
    }

    public void setExtents(Collection<Extent> extentList) {
        this.extents.clear();
        if (extentList != null) {
            this.extents.addAll(extentList);
        }
        this.clearCache();
    }

    public void setExtents(Extent extent) {
        this.extents.clear();
        if (extent != null) {
            this.extents.add(extent);
        }
        this.clearCache();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getSrs() {
        Layer layer = this;
        synchronized (layer) {
            if (this.allSRSCache == null) {
                Set<String> parentSrs;
                this.allSRSCache = new HashSet<String>(this.srs);
                Layer parent = this.getParent();
                if (parent != null && (parentSrs = parent.getSrs()) != null) {
                    this.allSRSCache.addAll(parentSrs);
                }
            }
            return this.allSRSCache;
        }
    }

    public void setSrs(Set<String> srs) {
        this.srs = srs;
    }

    public List<StyleImpl> getStyles() {
        List<StyleImpl> parentStyles;
        ArrayList<StyleImpl> allStyles = new ArrayList<StyleImpl>();
        Layer parent = this.getParent();
        if (parent != null && (parentStyles = parent.getStyles()) != null) {
            allStyles.addAll(parentStyles);
        }
        if (this.styles != null && !this.styles.isEmpty()) {
            for (StyleImpl style : this.styles) {
                if (allStyles.contains(style)) continue;
                allStyles.add(style);
            }
        }
        return allStyles;
    }

    public void setStyles(List<StyleImpl> styles) {
        this.styles = styles;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean isQueryable() {
        if (this.queryable == null) {
            for (Layer parent = this.getParent(); parent != null; parent = parent.getParent()) {
                Boolean q = parent.getQueryable();
                if (q == null) continue;
                return q;
            }
            return false;
        }
        return this.queryable;
    }

    private Boolean getQueryable() {
        return this.queryable;
    }

    public void setQueryable(boolean queryable) {
        this.queryable = new Boolean(queryable);
    }

    @Override
    public int compareTo(Layer layer) {
        if (this.getName() != null && layer.getName() != null) {
            return this.getName().compareTo(layer.getName());
        }
        return this.getTitle().compareTo(layer.getTitle());
    }

    public Layer getParent() {
        return this.parent;
    }

    public void setParent(Layer parentLayer) {
        this.parent = parentLayer;
        if (!parentLayer.children.contains(this)) {
            parentLayer.children.add(this);
        }
    }

    public CRSEnvelope getLatLonBoundingBox() {
        if (this.latLonBoundingBox == null) {
            for (Layer parent = this.getParent(); parent != null; parent = parent.getParent()) {
                CRSEnvelope llbb = parent.getLatLonBoundingBox();
                if (llbb == null) continue;
                return llbb;
            }
        }
        return this.latLonBoundingBox;
    }

    public void setLatLonBoundingBox(CRSEnvelope latLonBoundingBox) {
        String srsName;
        if (latLonBoundingBox.getSRSName() != null && !(srsName = latLonBoundingBox.getSRSName()).equals("CRS:84")) {
            throw new IllegalStateException("Layer LatLonBoundingBox srsName required to be null or CRS:84");
        }
        this.latLonBoundingBox = latLonBoundingBox;
    }

    public List<Layer> getLayerChildren() {
        return new AbstractList<Layer>(){

            @Override
            public Layer get(int index) {
                return (Layer)Layer.this.children.get(index);
            }

            @Override
            public int size() {
                return Layer.this.children.size();
            }

            @Override
            public Layer set(int index, Layer element) {
                Layer replaced = Layer.this.children.set(index, element);
                replaced.parent = null;
                element.parent = Layer.this;
                return replaced;
            }

            @Override
            public void add(int index, Layer element) {
                Layer.this.children.add(index, element);
                element.parent = Layer.this;
            }

            @Override
            public Layer remove(int index) {
                Layer removed = (Layer)Layer.this.children.remove(index);
                if (removed != null) {
                    removed.parent = null;
                }
                return removed;
            }
        };
    }

    public Layer[] getChildren() {
        return this.children.toArray(new Layer[this.children.size()]);
    }

    public void setChildren(Layer[] childrenArray) {
        this.children.clear();
        for (Layer child : childrenArray) {
            if (child == null || this.children.contains(child)) continue;
            child.parent = this;
            this.children.add(child);
        }
    }

    public void addChildren(Layer child) {
        child.parent = this;
        this.children.add(child);
    }

    public String get_abstract() {
        return this._abstract;
    }

    public void set_abstract(String _abstract) {
        this._abstract = _abstract;
    }

    public String[] getKeywords() {
        return this.keywords;
    }

    public void setKeywords(String[] keywords) {
        this.keywords = keywords;
    }

    public void setScaleDenominatorMax(double scaleDenominatorMax) {
        this.scaleDenominatorMax = scaleDenominatorMax;
    }

    public double getScaleDenominatorMax() {
        return this.scaleDenominatorMax;
    }

    public void setScaleDenominatorMin(double scaleDenominatorMin) {
        this.scaleDenominatorMin = scaleDenominatorMin;
    }

    public double getScaleDenominatorMin() {
        return this.scaleDenominatorMin;
    }

    public double getScaleHintMax() {
        return this.scaleHintMax;
    }

    public void setScaleHintMax(double scaleHintMax) {
        this.scaleHintMax = scaleHintMax;
    }

    public double getScaleHintMin() {
        return this.scaleHintMin;
    }

    public void setScaleHintMin(double scaleHintMin) {
        this.scaleHintMin = scaleHintMin;
    }

    public GeneralEnvelope getEnvelope(CoordinateReferenceSystem crs) {
        if (crs == null) {
            return null;
        }
        GeneralEnvelope found = (GeneralEnvelope)this.envelopeCache.get(crs);
        if (found != null) {
            return found;
        }
        ArrayList<String> identifiers = new ArrayList<String>();
        for (Object identifier : crs.getIdentifiers()) {
            String srsName = identifier.toString();
            identifiers.add(srsName);
            if (!srsName.startsWith("EPSG:")) continue;
            String urn = srsName.replace("EPSG:", "urn:ogc:def:crs:EPSG::");
            identifiers.add(urn);
        }
        if (crs == DefaultGeographicCRS.WGS84 || crs == DefaultGeographicCRS.WGS84_3D) {
            identifiers.add("CRS:84");
        }
        CRSEnvelope tempBBox = null;
        for (String srsName : identifiers) {
            Map<String, CRSEnvelope> boxes = this.getBoundingBoxes();
            tempBBox = boxes.get(srsName);
            if (tempBBox != null) break;
            if (!"CRS:84".equals(srsName.toUpperCase()) && !"EPSG:4326".equals(srsName.toUpperCase())) continue;
            tempBBox = this.getLatLonBoundingBox();
            break;
        }
        if (tempBBox == null) {
            tempBBox = this.getLatLonBoundingBox();
        }
        if (tempBBox == null && this.getBoundingBoxes() != null && this.getBoundingBoxes().size() > 0) {
            tempBBox = this.getBoundingBoxes().values().iterator().next();
        }
        if (tempBBox != null) {
            GeneralEnvelope env;
            try {
                GeneralEnvelope fixed = CRS.transform((Envelope)tempBBox, (CoordinateReferenceSystem)crs);
                env = new GeneralEnvelope((Envelope)fixed);
            }
            catch (TransformException e) {
                env = new GeneralEnvelope(new double[]{tempBBox.getMinX(), tempBBox.getMinY()}, new double[]{tempBBox.getMaxX(), tempBBox.getMaxY()});
                env.setCoordinateReferenceSystem(crs);
            }
            this.envelopeCache.put(crs, (Envelope)env);
            return env;
        }
        return null;
    }

    public int getCascaded() {
        return this.cascaded;
    }

    public void setCascaded(int cascadedValue) {
        this.cascaded = cascadedValue;
    }

    public List<MetadataURL> getMetadataURL() {
        return this.metadataURL;
    }

    public void setMetadataURL(List<MetadataURL> metadataURL) {
        this.metadataURL = metadataURL;
    }

    public Attribution getAttribution() {
        return this.attribution;
    }

    public void setAttribution(Attribution attribution) {
        this.attribution = attribution;
    }

    public String toString() {
        if (this.title != null) {
            return this.title;
        }
        return this.name;
    }
}

