/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers;

import java.util.List;
import javax.servlet.Filter;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExceptionHandlingConfigurer;
import org.springframework.security.config.annotation.web.configurers.LogoutConfigurer;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.servletapi.SecurityContextHolderAwareRequestFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServletApiConfigurer<H extends HttpSecurityBuilder<H>>
extends AbstractHttpConfigurer<ServletApiConfigurer<H>, H> {
    private SecurityContextHolderAwareRequestFilter securityContextRequestFilter = new SecurityContextHolderAwareRequestFilter();

    public ServletApiConfigurer<H> rolePrefix(String rolePrefix) {
        this.securityContextRequestFilter.setRolePrefix(rolePrefix);
        return this;
    }

    @Override
    public void configure(H http) throws Exception {
        this.securityContextRequestFilter.setAuthenticationManager(http.getSharedObject(AuthenticationManager.class));
        ExceptionHandlingConfigurer exceptionConf = http.getConfigurer(ExceptionHandlingConfigurer.class);
        AuthenticationEntryPoint authenticationEntryPoint = exceptionConf == null ? null : exceptionConf.getAuthenticationEntryPoint(http);
        this.securityContextRequestFilter.setAuthenticationEntryPoint(authenticationEntryPoint);
        LogoutConfigurer logoutConf = http.getConfigurer(LogoutConfigurer.class);
        List<LogoutHandler> logoutHandlers = logoutConf == null ? null : logoutConf.getLogoutHandlers();
        this.securityContextRequestFilter.setLogoutHandlers(logoutHandlers);
        AuthenticationTrustResolver trustResolver = http.getSharedObject(AuthenticationTrustResolver.class);
        if (trustResolver != null) {
            this.securityContextRequestFilter.setTrustResolver(trustResolver);
        }
        this.securityContextRequestFilter = this.postProcess(this.securityContextRequestFilter);
        http.addFilter((Filter)this.securityContextRequestFilter);
    }
}

