/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.traverse.basic;

import org.geotools.graph.structure.Graph;
import org.geotools.graph.structure.GraphVisitor;
import org.geotools.graph.structure.Graphable;
import org.geotools.graph.traverse.GraphIterator;
import org.geotools.graph.traverse.GraphWalker;
import org.geotools.graph.traverse.basic.BasicGraphTraversal;

public class StagedGraphTraversal
extends BasicGraphTraversal {
    private int m_stage = 0;

    public StagedGraphTraversal(Graph graph, GraphWalker walker, GraphIterator iterator) {
        super(graph, walker, iterator);
    }

    @Override
    public void init() {
        this.getGraph().visitNodes(new GraphVisitor(){

            @Override
            public int visit(Graphable component) {
                component.setCount(0);
                return 0;
            }
        });
    }

    @Override
    public boolean isVisited(Graphable g) {
        return g.getCount() == this.m_stage;
    }

    @Override
    public void setVisited(Graphable g, boolean visited) {
        g.setCount(visited ? this.m_stage : -1);
    }
}

