/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.security.ldap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.domain.LDAPUser;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.User;
import org.fao.geonet.kernel.security.WritableUserDetailsContextMapper;
import org.fao.geonet.kernel.security.ldap.LDAPUtils;
import org.fao.geonet.utils.Log;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.ldap.DefaultSpringSecurityContextSource;
import org.springframework.security.ldap.userdetails.InetOrgPerson;
import org.springframework.security.provisioning.UserDetailsManager;
import org.springframework.util.StringUtils;

public abstract class AbstractLDAPUserDetailsContextMapper
implements WritableUserDetailsContextMapper {
    protected boolean importPrivilegesFromLdap;
    protected DefaultSpringSecurityContextSource contextSource;
    Map<String, String[]> mapping;
    Map<String, Profile> profileMapping;
    private boolean createNonExistingLdapGroup = true;
    private boolean createNonExistingLdapUser = false;
    private UserDetailsManager ldapManager;
    private String ldapBaseDnPattern = "uid={0},ou=users";
    private String ldapBaseDn;
    private boolean ldapUsernameCaseInsensitive = true;
    private LDAPUtils ldapUtils;

    public void setLdapUtils(LDAPUtils utils) {
        this.ldapUtils = utils;
    }

    public void mapUserToContext(UserDetails user, DirContextAdapter ctx) {
        ctx.setAttributeValues("objectclass", (Object[])new String[]{"top", "person", "organizationalPerson", "inetOrgPerson"});
        ctx.setAttributeValue("sn", (Object)user.getUsername());
        ctx.setAttributeValue("cn", (Object)user.getUsername());
        ctx.setAttributeValue("uid", (Object)user.getUsername());
        if (user instanceof InetOrgPerson) {
            InetOrgPerson p = (InetOrgPerson)user;
            ctx.setAttributeValue("mail", (Object)p.getMail());
            ctx.setAttributeValue("displayName", (Object)p.getDisplayName());
            ctx.setAttributeValue("sn", (Object)p.getSn());
        }
    }

    public UserDetails mapUserFromContext(DirContextOperations userCtx, String username, Collection<? extends GrantedAuthority> authorities) {
        Profile defaultProfile = this.mapping.get("profile") != null && this.mapping.get("profile")[1] != null ? Profile.valueOf((String)this.mapping.get("profile")[1]) : Profile.RegisteredUser;
        String defaultGroup = this.mapping.get("privilege")[1];
        LDAPUtils ldapUtils = (LDAPUtils)ApplicationContextHolder.get().getBean(LDAPUtils.class);
        Map<String, ArrayList<String>> userInfo = ldapUtils.convertAttributes(userCtx.getAttributes().getAll());
        if (this.isLdapUsernameCaseInsensitive()) {
            username = username.toLowerCase();
        }
        if (!userInfo.containsKey("dn")) {
            ArrayList<String> dns = new ArrayList<String>(Arrays.asList(userCtx.getDn().toString(), userCtx.getNameInNamespace()));
            userInfo.put("dn", dns);
        }
        LDAPUser userDetails = new LDAPUser(username);
        User user = userDetails.getUser();
        user.setName(this.getUserInfo(userInfo, "name"));
        user.setSurname(this.getUserInfo(userInfo, "surname"));
        user.setOrganisation(this.getUserInfo(userInfo, "organisation"));
        user.getEmailAddresses().clear();
        user.getEmailAddresses().add(this.getUserInfo(userInfo, "mail"));
        user.getPrimaryAddress().setAddress(this.getUserInfo(userInfo, "address")).setState(this.getUserInfo(userInfo, "state")).setZip(this.getUserInfo(userInfo, "zip")).setCity(this.getUserInfo(userInfo, "city")).setCountry(this.getUserInfo(userInfo, "country"));
        if (this.importPrivilegesFromLdap) {
            this.setProfilesAndPrivileges(defaultProfile, defaultGroup, userInfo, userDetails);
        }
        if (user.getProfile() == null) {
            user.setProfile(defaultProfile);
            if (userDetails.getPrivileges().size() == 0 && defaultGroup != null) {
                if (Log.isDebugEnabled((String)"geonetwork.ldap")) {
                    Log.debug((String)"geonetwork.ldap", (Object)("  No privilege defined, setting privilege for group " + defaultGroup + " as " + userDetails.getUser().getProfile()));
                }
                userDetails.addPrivilege(defaultGroup, userDetails.getUser().getProfile());
            }
        }
        this.saveUser(userDetails);
        return userDetails;
    }

    protected abstract void setProfilesAndPrivileges(Profile var1, String var2, Map<String, ArrayList<String>> var3, LDAPUser var4);

    protected void addProfile(@Nonnull LDAPUser userDetails, @Nonnull String profileName, @Nullable Set<Profile> profileList) {
        Profile mapped;
        if (this.profileMapping != null && (mapped = this.profileMapping.get(profileName)) != null) {
            profileName = mapped.name();
        }
        if (Log.isDebugEnabled((String)"geonetwork.ldap")) {
            Log.debug((String)"geonetwork.ldap", (Object)("  Assigning profile " + profileName));
        }
        try {
            Profile profile = Profile.valueOf((String)profileName);
            if (profile != null) {
                userDetails.getUser().setProfile(profile);
                if (profileList != null) {
                    profileList.add(profile);
                }
            } else {
                Log.error((String)"geonetwork.ldap", (Object)("  Profile " + profileName + " does not exist."));
            }
        }
        catch (Exception e) {
            Log.warning((String)"geonetwork.ldap", (Object)("  Profile " + profileName + " is not a valid profile. " + e.getMessage()));
        }
    }

    @Override
    public synchronized void saveUser(LDAPUser userDetails) {
        try {
            LDAPUtils ldapUtils;
            LDAPUtils lDAPUtils = ldapUtils = this.ldapUtils != null ? this.ldapUtils : (LDAPUtils)ApplicationContextHolder.get().getBean(LDAPUtils.class);
            if (this.createNonExistingLdapUser && !this.ldapManager.userExists(userDetails.getUsername())) {
                InetOrgPerson.Essence p = new InetOrgPerson.Essence((InetOrgPerson)userDetails);
                p.setDn(this.ldapBaseDnPattern.replace("{0}", userDetails.getUsername()));
                String surname = userDetails.getUser().getSurname();
                if (StringUtils.isEmpty((Object)surname)) {
                    surname = userDetails.getUsername();
                }
                p.setSn(surname);
                p.setUid(userDetails.getUsername());
                p.setMail(userDetails.getUser().getEmail());
                String name = userDetails.getUser().getName();
                if (StringUtils.isEmpty((Object)name)) {
                    name = userDetails.getUsername();
                }
                p.setDisplayName(name);
                String[] cn = this.ldapBaseDn.split(",");
                for (int i = 0; i < cn.length; ++i) {
                    cn[i] = cn[i].substring(cn[i].indexOf("=") + 1);
                }
                p.setCn(cn);
                this.ldapManager.createUser((UserDetails)p.createUserDetails());
            }
            ldapUtils.saveUser(userDetails, this.importPrivilegesFromLdap, this.createNonExistingLdapGroup);
        }
        catch (Exception e) {
            throw new AuthenticationServiceException("Unexpected error while saving/updating LDAP user in database", (Throwable)e);
        }
    }

    private String getUserInfo(Map<String, ArrayList<String>> userInfo, String attributeName) {
        return this.getUserInfo(userInfo, attributeName, "");
    }

    private String getValue(Map<String, ArrayList<String>> userInfo, String ldapAttributeName) {
        if (ldapAttributeName == null || userInfo == null) {
            return null;
        }
        ArrayList<String> info = userInfo.get(ldapAttributeName);
        if (info == null || info.size() == 0) {
            return null;
        }
        if (info.size() == 1) {
            return info.get(0);
        }
        if (info.get(1) == null) {
            return info.get(0);
        }
        if (info.get(0).length() < info.get(1).length()) {
            return info.get(0);
        }
        return info.get(1);
    }

    private String getUserInfo(Map<String, ArrayList<String>> userInfo, String attributeName, String defaultValue) {
        String[] attributeMapping = this.mapping.get(attributeName);
        String value = "";
        if (attributeMapping != null) {
            String ldapAttributeName = attributeMapping[0];
            String configDefaultValue = attributeMapping[1];
            String v = this.getValue(userInfo, ldapAttributeName);
            value = v != null ? v : (configDefaultValue != null ? configDefaultValue : defaultValue);
        } else {
            value = defaultValue;
        }
        if (Log.isDebugEnabled((String)"geonetwork.ldap")) {
            Log.debug((String)"geonetwork.ldap", (Object)("LDAP attribute '" + attributeName + "' = " + value));
        }
        return value;
    }

    public boolean isCreateNonExistingLdapGroup() {
        return this.createNonExistingLdapGroup;
    }

    public void setCreateNonExistingLdapGroup(boolean createNonExistingLdapGroup) {
        this.createNonExistingLdapGroup = createNonExistingLdapGroup;
    }

    public String[] getMappingValue(String key) {
        return this.mapping.get(key);
    }

    public Map<String, String[]> getMapping() {
        return this.mapping;
    }

    public void setMapping(Map<String, String[]> mapping) {
        this.mapping = mapping;
    }

    public Profile getProfileMappingValue(String key) {
        return this.profileMapping.get(key);
    }

    public Map<String, Profile> getProfileMapping() {
        return this.profileMapping;
    }

    public void setProfileMapping(Map<String, Profile> profileMapping) {
        this.profileMapping = profileMapping;
    }

    public boolean isImportPrivilegesFromLdap() {
        return this.importPrivilegesFromLdap;
    }

    public void setImportPrivilegesFromLdap(boolean importPrivilegesFromLdap) {
        this.importPrivilegesFromLdap = importPrivilegesFromLdap;
    }

    public DefaultSpringSecurityContextSource getContextSource() {
        return this.contextSource;
    }

    public void setContextSource(DefaultSpringSecurityContextSource contextSource) {
        this.contextSource = contextSource;
    }

    public UserDetailsManager getLdapManager() {
        return this.ldapManager;
    }

    public void setLdapManager(UserDetailsManager ldapManager) {
        this.ldapManager = ldapManager;
    }

    public boolean isCreateNonExistingLdapUser() {
        return this.createNonExistingLdapUser;
    }

    public void setCreateNonExistingLdapUser(boolean createNonExistingLdapUser) {
        this.createNonExistingLdapUser = createNonExistingLdapUser;
    }

    public String getLdapBaseDnPattern() {
        return this.ldapBaseDnPattern;
    }

    public void setLdapBaseDnPattern(String ldapBaseDnPattern) {
        this.ldapBaseDnPattern = ldapBaseDnPattern;
    }

    public String getLdapBaseDn() {
        return this.ldapBaseDn;
    }

    public void setLdapBaseDn(String ldapBaseDn) {
        this.ldapBaseDn = ldapBaseDn;
    }

    public void setLdapUsernameCaseInsensitive(boolean ldapUsernameCaseInsensitive) {
        this.ldapUsernameCaseInsensitive = ldapUsernameCaseInsensitive;
    }

    public boolean isLdapUsernameCaseInsensitive() {
        return this.ldapUsernameCaseInsensitive;
    }
}

