/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.search.facet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.Facets;
import org.apache.lucene.facet.LabelAndValue;
import org.fao.geonet.kernel.search.Translator;
import org.fao.geonet.kernel.search.facet.CategorySummary;
import org.fao.geonet.kernel.search.facet.Format;
import org.fao.geonet.kernel.search.facet.Formatter;
import org.fao.geonet.kernel.search.facet.ItemConfig;
import org.fao.geonet.kernel.search.facet.SortBy;
import org.fao.geonet.kernel.search.facet.SortOrder;
import org.fao.geonet.utils.Log;
import org.jdom.Content;
import org.jdom.Element;

public class ItemBuilder {
    private final String langCode;
    private ItemConfig config;
    private Facets facets;
    private Translator translator;
    private Formatter formatter;

    public ItemBuilder(ItemConfig config, String langCode, Facets facets, Format format) {
        this.config = config;
        this.facets = facets;
        this.translator = config.getTranslator(langCode);
        this.formatter = format.getFormatter(config.getDimension());
        this.langCode = langCode;
    }

    public Element build() {
        FacetResult dimensionResult = this.getTopChildren(new String[0]);
        Element dimensionElement = this.buildDimensionElement(dimensionResult);
        if (dimensionResult != null) {
            this.addResultSubCategoriesToElement(dimensionResult, dimensionElement, new String[0]);
        }
        return dimensionElement;
    }

    private Element buildDimensionElement(FacetResult facetResults) {
        if (facetResults == null) {
            Log.debug((String)"geonetwork.facet", (Object)("Null facet results for field " + this.config.getDimension().getIndexKey()));
            return this.formatter.buildDimensionTag(0);
        }
        return this.formatter.buildDimensionTag(this.getCount(facetResults));
    }

    private int getCount(FacetResult facetResult) {
        if (facetResult == null) {
            return 0;
        }
        return facetResult.value.intValue();
    }

    private void addResultSubCategoriesToElement(FacetResult facetResult, Element dimensionElement, String ... path) {
        List<CategorySummary> subCategories = this.toSubCategories(facetResult.labelValues);
        List<CategorySummary> sortedSubCategories = this.sort(subCategories);
        for (CategorySummary subCategory : sortedSubCategories) {
            this.addSubCategoryToElement(subCategory, dimensionElement, path);
        }
    }

    private void addSubCategoryToElement(CategorySummary subCategory, Element parent, String ... parentPath) {
        Element categoryTag = this.buildCategoryTag(subCategory);
        String[] path = this.addCategoryToPath(subCategory.value, parentPath);
        FacetResult subCategoryResult = this.getTopChildren(path);
        if (subCategoryResult != null) {
            this.addResultSubCategoriesToElement(subCategoryResult, categoryTag, path);
        }
        parent.addContent((Content)categoryTag);
    }

    private List<CategorySummary> toSubCategories(LabelAndValue[] labelValues) {
        ArrayList<CategorySummary> result = new ArrayList<CategorySummary>();
        for (LabelAndValue labelAndValue : labelValues) {
            result.add(this.toCategoryResult(labelAndValue));
        }
        return result;
    }

    private CategorySummary toCategoryResult(LabelAndValue labelAndValue) {
        CategorySummary result = new CategorySummary();
        result.value = labelAndValue.label;
        result.label = this.translator.translate(labelAndValue.label);
        result.count = labelAndValue.value.intValue();
        return result;
    }

    private FacetResult getTopChildren(String ... path) {
        try {
            if (this.config.getDimension().isLocalized() && !this.config.getDimension().getLocales().contains(this.langCode)) {
                return new FacetResult(this.config.getDimension().getName(this.langCode), path, (Number)0, new LabelAndValue[0], 0);
            }
            return this.facets.getTopChildren(this.config.getMax(), this.config.getDimension().getName(this.langCode), path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private List<CategorySummary> sort(List<CategorySummary> categories) {
        if (Log.isDebugEnabled((String)"geonetwork.facet")) {
            Log.debug((String)"geonetwork.facet", (Object)(this.config.getDimension().getName() + ":\tSorting facet by " + this.config.getSortBy().toString() + " (" + this.config.getSortOrder().toString() + ")"));
        }
        if (SortBy.COUNT != this.config.getSortBy()) {
            Collections.sort(categories, this.getComparator());
        }
        return categories;
    }

    private Comparator<CategorySummary> getComparator() {
        Comparator<CategorySummary> comparator = SortBy.LABEL == this.config.getSortBy() ? this.labelComparator() : (SortBy.NUMVALUE == this.config.getSortBy() ? this.numericComparator() : this.valueComparator());
        if (SortOrder.DESCENDING == this.config.getSortOrder()) {
            comparator = this.descendingComparator(comparator);
        }
        return comparator;
    }

    private Element buildCategoryTag(CategorySummary result) {
        if (Log.isDebugEnabled((String)"geonetwork.facet")) {
            Log.debug((String)"geonetwork.facet", (Object)(" - " + result.value + " (" + result.count + ")"));
        }
        return this.formatter.buildCategoryTag(result);
    }

    private String[] addCategoryToPath(String category, String ... parentPath) {
        String[] path = Arrays.copyOf(parentPath, parentPath.length + 1);
        path[parentPath.length] = category;
        return path;
    }

    private Comparator<CategorySummary> valueComparator() {
        return new Comparator<CategorySummary>(){

            @Override
            public int compare(CategorySummary e1, CategorySummary e2) {
                return e1.value.compareTo(e2.value);
            }
        };
    }

    private Comparator<CategorySummary> numericComparator() {
        return new Comparator<CategorySummary>(){

            @Override
            public int compare(CategorySummary e1, CategorySummary e2) {
                try {
                    Double d1 = Double.valueOf(e1.value);
                    Double d2 = Double.valueOf(e2.value);
                    return d1.compareTo(d2);
                }
                catch (NumberFormatException e) {
                    Log.warning((String)"geonetwork.facet", (Object)("Failed to compare numeric values (" + e1.value + " / " + e2.value + ") for facet. Check sortBy option in summary configuration."));
                    return e1.value.compareTo(e2.value);
                }
            }
        };
    }

    private Comparator<CategorySummary> labelComparator() {
        return new Comparator<CategorySummary>(){

            @Override
            public int compare(CategorySummary e1, CategorySummary e2) {
                return e1.label.compareToIgnoreCase(e2.label);
            }
        };
    }

    private Comparator<CategorySummary> descendingComparator(final Comparator<CategorySummary> wrappedComparator) {
        return new Comparator<CategorySummary>(){

            @Override
            public int compare(CategorySummary e1, CategorySummary e2) {
                return wrappedComparator.compare(e2, e1);
            }
        };
    }

    public String toString() {
        return "ItemBuilder{Item Config =" + this.config + ", langCode='" + this.langCode + '\'' + '}';
    }
}

