/*
 * Decompiled with CFR 0.152.
 */
package jeeves.services.db;

import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.sql.DataSource;
import jeeves.interfaces.Service;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Element;

public class Select
implements Service {
    private static final String DEFAULT_DATE_FORMAT = "dd-MM-yyyy";
    private static final String DEFAULT_TIME_FORMAT = "HH:mm:ss";
    private static final String DEFAULT_TIMESTAMP_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    private String query;
    private Vector<Element> inFields;
    private Vector<Element> outFields;

    public static Vector<Object> scanInFields(Element params, Vector<Element> inFields, Element result, ServiceContext context) throws Exception {
        Vector<Object> vArgs = new Vector<Object>();
        for (Element field : inFields) {
            Number n;
            Format df;
            String type;
            boolean fFlag;
            boolean mFlag;
            String name = field.getAttributeValue("name");
            String mandatory = field.getAttributeValue("mandatory");
            String nullText = field.getAttributeValue("null");
            String format = field.getAttributeValue("format");
            String sqlValue = field.getAttributeValue("value");
            String forward = field.getAttributeValue("forward");
            String value = params.getChildText(name);
            if (name == null) {
                throw new IllegalArgumentException("undefined field name: " + Xml.getString((Element)field));
            }
            if (sqlValue != null) {
                Element el = Select.select(context, sqlValue);
                value = el.getChild("record").getChildText(name);
            }
            if (mandatory == null || mandatory.equals("false")) {
                mFlag = false;
            } else if (mandatory.equals("true")) {
                mFlag = true;
            } else {
                throw new IllegalArgumentException("bad mandatory attribute value: " + mandatory);
            }
            if (mFlag && value == null) {
                throw new IllegalArgumentException("mandatory parameter missing: " + name);
            }
            if (value == null || nullText != null && nullText.equals(value)) {
                vArgs.add(null);
                continue;
            }
            if (forward == null || forward.equals("false")) {
                fFlag = false;
            } else if (forward.equals("true")) {
                fFlag = true;
            } else {
                throw new IllegalArgumentException("bad forward attribute value: " + forward);
            }
            if (fFlag && result != null) {
                result.addContent((Content)new Element(name).setText(value));
            }
            if ((type = field.getAttributeValue("type")) == null || type.equals("string")) {
                vArgs.add(value);
                continue;
            }
            if (type.equals("int")) {
                if (format == null) {
                    vArgs.add(Integer.valueOf(value));
                    continue;
                }
                df = new DecimalFormat(format);
                n = ((NumberFormat)df).parse(value);
                vArgs.add(n.intValue());
                continue;
            }
            if (type.equals("double")) {
                if (format == null) {
                    vArgs.add(new Double(value));
                    continue;
                }
                df = new DecimalFormat(format);
                n = ((NumberFormat)df).parse(value);
                vArgs.add(new Double(n.doubleValue()));
                continue;
            }
            if (type.equals("date")) {
                df = format == null ? new SimpleDateFormat(DEFAULT_DATE_FORMAT) : new SimpleDateFormat(format);
                java.util.Date date = ((DateFormat)df).parse(value);
                vArgs.add(new Date(date.getTime()));
                continue;
            }
            throw new IllegalArgumentException("bad field type: " + type);
        }
        return vArgs;
    }

    public static Hashtable<String, String> scanOutFields(Vector<Element> outFields) throws Exception {
        Hashtable<String, String> formats = new Hashtable<String, String>();
        for (Element field : outFields) {
            String name = field.getAttributeValue("name");
            if (name == null) {
                throw new IllegalArgumentException("undefined field name: " + Xml.getString((Element)field));
            }
            String format = field.getAttributeValue("format");
            if (format == null) continue;
            formats.put(name, format);
        }
        return formats;
    }

    public static Element select(ServiceContext context, String query) throws SQLException {
        return Select.selectFull(context, query, Collections.emptyMap(), new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element selectFull(ServiceContext context, String query, Map<String, String> formats, Object ... args) throws SQLException {
        DataSource datasource = context.getBean(DataSource.class);
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        try {
            Element result;
            conn = datasource.getConnection();
            stmt = conn.prepareStatement(query);
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    Select.setObject(stmt, i, args[i]);
                }
            }
            resultSet = stmt.executeQuery();
            Element element = result = Select.buildResponse(resultSet, formats);
            return element;
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                finally {
                    if (conn != null) {
                        conn.close();
                    }
                }
            }
        }
    }

    private static void setObject(PreparedStatement stmt, int i, Object obj) throws SQLException {
        if (obj instanceof String) {
            String s = (String)obj;
            if (s.length() < 4000) {
                stmt.setString(i + 1, s);
            } else {
                stmt.setCharacterStream(i + 1, (Reader)new StringReader(s), s.length());
            }
        } else {
            stmt.setObject(i + 1, obj);
        }
    }

    private static Element buildResponse(ResultSet rs, Map<String, String> formats) throws SQLException {
        ResultSetMetaData md = rs.getMetaData();
        int colNum = md.getColumnCount();
        Vector<String> vHeaders = new Vector<String>();
        Vector<Integer> vTypes = new Vector<Integer>();
        for (int i = 0; i < colNum; ++i) {
            vHeaders.add(md.getColumnLabel(i + 1).toLowerCase());
            vTypes.add(md.getColumnType(i + 1));
        }
        Element root = new Element("response");
        while (rs.next()) {
            Element record = new Element("record");
            for (int i = 0; i < colNum; ++i) {
                String name = ((String)vHeaders.get(i)).toString();
                int type = (Integer)vTypes.get(i);
                record.addContent((Content)Select.buildElement(rs, i, name, type, formats));
            }
            root.addContent((Content)record);
        }
        return root;
    }

    private static Element buildElement(ResultSet rs, int col, String name, int type, Map<String, String> formats) throws SQLException {
        String value = null;
        switch (type) {
            case 91: {
                Date date = rs.getDate(col + 1);
                if (date == null) {
                    value = null;
                    break;
                }
                String format = formats.get(name);
                SimpleDateFormat df = format == null ? new SimpleDateFormat(DEFAULT_DATE_FORMAT) : new SimpleDateFormat(format);
                value = df.format(date);
                break;
            }
            case 92: {
                Time time = rs.getTime(col + 1);
                if (time == null) {
                    value = null;
                    break;
                }
                String format = formats.get(name);
                SimpleDateFormat df = format == null ? new SimpleDateFormat(DEFAULT_TIME_FORMAT) : new SimpleDateFormat(format);
                value = df.format(time);
                break;
            }
            case 93: {
                Timestamp timestamp = rs.getTimestamp(col + 1);
                if (timestamp == null) {
                    value = null;
                    break;
                }
                String format = formats.get(name);
                SimpleDateFormat df = format == null ? new SimpleDateFormat(DEFAULT_TIMESTAMP_FORMAT) : new SimpleDateFormat(format);
                value = df.format(timestamp);
                break;
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                long l = rs.getLong(col + 1);
                if (rs.wasNull()) {
                    value = null;
                    break;
                }
                String format = formats.get(name);
                if (format == null) {
                    value = l + "";
                    break;
                }
                DecimalFormat df = new DecimalFormat(format);
                value = df.format(l);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                double n = rs.getDouble(col + 1);
                if (rs.wasNull()) {
                    value = null;
                    break;
                }
                String format = formats.get(name);
                if (format == null) {
                    value = n + "";
                    if (!value.endsWith(".0")) break;
                    value = value.substring(0, value.length() - 2);
                    break;
                }
                DecimalFormat df = new DecimalFormat(format);
                value = df.format(n);
                break;
            }
            default: {
                value = rs.getString(col + 1);
                if (value == null) break;
                value = Select.stripIllegalChars(value);
            }
        }
        return new Element(name).setText(value);
    }

    private static String stripIllegalChars(String input) {
        String output = input;
        for (int i = 127; i < 160; ++i) {
            String c = String.valueOf((char)i);
            if (!output.contains(c)) continue;
            output = output.replaceAll(c, "");
        }
        return output;
    }

    @Override
    public void init(Path appPath, ServiceConfig params) throws Exception {
        this.query = params.getMandatoryValue("query");
        List<Element> inList = params.getChildren("inFields", "field");
        this.inFields = new Vector();
        if (inList != null) {
            for (Element field : inList) {
                this.inFields.add(field);
            }
        }
        List<Element> outList = params.getChildren("outFields", "field");
        this.outFields = new Vector();
        if (outList != null) {
            for (Element field : outList) {
                this.outFields.add(field);
            }
        }
    }

    @Override
    public Element exec(Element params, ServiceContext context) throws Exception {
        Vector<Object> vArgs = Select.scanInFields(params, this.inFields, null, context);
        Hashtable<String, String> formats = Select.scanOutFields(this.outFields);
        return Select.selectFull(context, this.query, formats, vArgs.toArray());
    }
}

