/*
 * Decompiled with CFR 0.152.
 */
package jeeves.server.context;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.persistence.EntityManager;
import jeeves.component.ProfileManager;
import jeeves.server.UserSession;
import jeeves.server.context.BasicContext;
import jeeves.server.context.ServiceExecutionFailedException;
import jeeves.server.dispatchers.ServiceManager;
import jeeves.server.local.LocalServiceRequest;
import jeeves.server.sources.ServiceRequest;
import jeeves.server.sources.http.JeevesServlet;
import jeeves.transaction.TransactionManager;
import jeeves.transaction.TransactionTask;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.Logger;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.utils.Log;
import org.jdom.Element;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.transaction.TransactionStatus;

public class ServiceContext
extends BasicContext {
    private static final InheritableThreadLocal<ServiceContext> THREAD_LOCAL_INSTANCE = new InheritableThreadLocal();
    private UserSession _userSession = new UserSession();
    private ServiceRequest.InputMethod _input;
    private ServiceRequest.OutputMethod _output;
    private Map<String, String> _headers;
    private String _language;
    private String _service;
    private String _ipAddress;
    private int _maxUploadSize;
    private JeevesServlet _servlet;
    private boolean _startupError = false;
    private Map<String, String> _startupErrors;
    private Map<String, String> _responseHeaders;
    private Integer _statusCode;

    public ServiceContext(String service, ConfigurableApplicationContext jeevesApplicationContext, Map<String, Object> contexts, EntityManager entityManager) {
        super(jeevesApplicationContext, contexts, entityManager);
        this.setService(service);
        this.setResponseHeaders(new HashMap<String, String>());
    }

    @CheckForNull
    public static ServiceContext get() {
        return (ServiceContext)THREAD_LOCAL_INSTANCE.get();
    }

    public void setAsThreadLocal() {
        THREAD_LOCAL_INSTANCE.set(this);
        ApplicationContextHolder.set((ConfigurableApplicationContext)this.getApplicationContext());
    }

    public String getLanguage() {
        return this._language;
    }

    public void setLanguage(String lang) {
        this._language = lang;
    }

    public String getService() {
        return this._service;
    }

    public void setService(String service) {
        this._service = service;
        this.logger = Log.createLogger((String)("jeeves.webapp." + service));
    }

    public String getIpAddress() {
        return this._ipAddress;
    }

    public void setIpAddress(String address) {
        this._ipAddress = address;
    }

    public Path getUploadDir() {
        return this.getBean(GeonetworkDataDirectory.class).getUploadDir();
    }

    public int getMaxUploadSize() {
        return this._maxUploadSize;
    }

    public void setMaxUploadSize(int size) {
        this._maxUploadSize = size;
    }

    public UserSession getUserSession() {
        return this._userSession;
    }

    public void setUserSession(UserSession session) {
        this._userSession = session;
    }

    public ProfileManager getProfileManager() {
        return this.getBean(ProfileManager.class);
    }

    public ServiceRequest.InputMethod getInputMethod() {
        return this._input;
    }

    public void setInputMethod(ServiceRequest.InputMethod m) {
        this._input = m;
    }

    public ServiceRequest.OutputMethod getOutputMethod() {
        return this._output;
    }

    public void setOutputMethod(ServiceRequest.OutputMethod m) {
        this._output = m;
    }

    public Map<String, String> getStartupErrors() {
        return this._startupErrors;
    }

    public void setStartupErrors(Map<String, String> errs) {
        this._startupErrors = errs;
        this._startupError = true;
    }

    public boolean isStartupError() {
        return this._startupError;
    }

    public boolean isServletInitialized() {
        if (this._servlet != null) {
            return this._servlet.isInitialized();
        }
        return true;
    }

    public void setLogger(Logger l) {
        this.logger = l;
    }

    public Map<String, String> getHeaders() {
        return this._headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this._headers = headers;
    }

    public JeevesServlet getServlet() {
        return this._servlet;
    }

    public void setServlet(JeevesServlet serv) {
        this._servlet = serv;
    }

    public void executeOnly(final LocalServiceRequest request) throws Exception {
        TransactionManager.runInTransaction("ServiceContext#executeOnly: " + request.getAddress(), (ApplicationContext)this.getApplicationContext(), TransactionManager.TransactionRequirement.CREATE_NEW, TransactionManager.CommitBehavior.ALWAYS_COMMIT, false, new TransactionTask<Void>(){

            @Override
            public Void doInTransaction(TransactionStatus transaction) throws Throwable {
                ServiceContext context = new ServiceContext(request.getService(), ServiceContext.this.getApplicationContext(), ServiceContext.this.htContexts, ServiceContext.this.getEntityManager());
                UserSession session = ServiceContext.this._userSession;
                if (session == null) {
                    session = new UserSession();
                }
                try {
                    ServiceManager serviceManager = context.getBean(ServiceManager.class);
                    serviceManager.dispatch(request, session, context);
                }
                catch (Exception e) {
                    Log.error((String)"jeeves.xlinkprocessor", (Object)("Failed to parse result xml" + request.getService()));
                    throw new ServiceExecutionFailedException(request.getService(), e);
                }
                finally {
                    ServiceContext.this.setAsThreadLocal();
                }
                return null;
            }
        });
    }

    public Element execute(LocalServiceRequest request) throws Exception {
        this.executeOnly(request);
        try {
            return request.getResult();
        }
        catch (Exception e) {
            Log.error((String)"jeeves.xlinkprocessor", (Object)("Failed to parse result xml from service:" + request.toString() + "\n" + request.getResultString()));
            throw new ServiceExecutionFailedException(request.getService(), e);
        }
    }

    public Map<String, String> getResponseHeaders() {
        return this._responseHeaders;
    }

    private void setResponseHeaders(Map<String, String> responseHeaders) {
        this._responseHeaders = responseHeaders;
    }

    public Integer getStatusCode() {
        return this._statusCode;
    }

    public void setStatusCode(Integer statusCode) {
        this._statusCode = statusCode;
    }
}

