/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.a2j.codec.util;

import java.io.StringWriter;
import java.util.Hashtable;
import org.jzkit.a2j.codec.util.OIDRegConfigurator;
import org.jzkit.a2j.codec.util.OIDRegisterEntry;

public class OIDRegister {
    private Hashtable register_by_name = new Hashtable();
    private Hashtable register_by_value = new Hashtable();

    public OIDRegister(String[] resources) {
        for (int i = 0; i < resources.length; ++i) {
            OIDRegConfigurator.load(this, resources[i]);
        }
    }

    public OIDRegister(String resource) {
        OIDRegConfigurator.load(this, resource);
    }

    public void register_oid(OIDRegisterEntry entry) {
        this.register_by_name.put(entry.getName(), entry);
        this.register_by_value.put(entry.getStringValue(), entry);
    }

    public OIDRegisterEntry lookupByOID(String oid_as_string) {
        OIDRegisterEntry e = (OIDRegisterEntry)this.register_by_value.get(oid_as_string);
        return e;
    }

    public OIDRegisterEntry lookupByOID(int[] oid) {
        StringWriter sw = new StringWriter(32);
        sw.write("{");
        for (int i = 0; i < oid.length; ++i) {
            if (i > 0) {
                sw.write(",");
            }
            sw.write("" + oid[i]);
        }
        sw.write("}");
        return this.lookupByOID(sw.toString());
    }

    public int[] oidByName(String name) {
        OIDRegisterEntry o = this.lookupByName(name);
        if (null != o) {
            return o.getValue();
        }
        return null;
    }

    public OIDRegisterEntry lookupByName(String name) {
        return (OIDRegisterEntry)this.register_by_name.get(name);
    }
}

