/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.repository.specification;

import java.util.Collection;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.MetadataFileDownload;
import org.fao.geonet.domain.MetadataFileDownload_;
import org.fao.geonet.domain.MetadataSourceInfo_;
import org.fao.geonet.domain.Metadata_;
import org.springframework.data.jpa.domain.Specification;

public class MetadataFileDownloadSpecs {
    private MetadataFileDownloadSpecs() {
    }

    public static Specification<MetadataFileDownload> downloadDateBetweenAndByGroups(final ISODate downloadFrom, final ISODate downloadTo, final Collection<Integer> groups) {
        return new Specification<MetadataFileDownload>(){

            public Predicate toPredicate(Root<MetadataFileDownload> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                Path downloadDateAttributePath = root.get(MetadataFileDownload_.downloadDate);
                Path metadataIdAttributePath = root.get(MetadataFileDownload_.metadataId);
                Predicate downloadDateBetweenPredicate = cb.between((Expression)downloadDateAttributePath, (Comparable)((Object)downloadFrom.toString()), (Comparable)((Object)downloadTo.toString()));
                if (!groups.isEmpty()) {
                    Root metadataRoot = query.from(Metadata.class);
                    Path groupOwnerPath = metadataRoot.get(Metadata_.sourceInfo).get(MetadataSourceInfo_.groupOwner);
                    Predicate inGroups = groupOwnerPath.in(groups);
                    downloadDateBetweenPredicate = cb.and((Expression)cb.equal((Expression)metadataRoot.get(Metadata_.id), (Expression)metadataIdAttributePath), (Expression)cb.and((Expression)downloadDateBetweenPredicate, (Expression)inGroups));
                }
                return downloadDateBetweenPredicate;
            }
        };
    }
}

