/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.domain;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyColumn;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.fao.geonet.domain.Localized;
import org.fao.geonet.domain.MetadataCategory;
import org.fao.geonet.domain.ReservedGroup;
import org.fao.geonet.domain.converter.BooleanToYNConverter;
import org.fao.geonet.entitylistener.GroupEntityListenerManager;

@Entity
@Table(name="Groups")
@Cacheable
@Access(value=AccessType.PROPERTY)
@EntityListeners(value={GroupEntityListenerManager.class})
@SequenceGenerator(name="group_id_seq", initialValue=100, allocationSize=1)
public class Group
extends Localized
implements Serializable {
    static final String ID_SEQ_NAME = "group_id_seq";
    private int _id;
    private String _name;
    private String _description;
    private String _email;
    private Integer _referrer;
    private String logo;
    private String website;
    private MetadataCategory defaultCategory;
    private List<MetadataCategory> allowedCategories;
    private Boolean enableAllowedCategories;

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="group_id_seq")
    @Column(nullable=false)
    public int getId() {
        return this._id;
    }

    public Group setId(int id) {
        this._id = id;
        return this;
    }

    @Column(nullable=false, length=32)
    public String getName() {
        return this._name;
    }

    public Group setName(String name) {
        this._name = name;
        return this;
    }

    @Column(length=255)
    public String getDescription() {
        return this._description;
    }

    public Group setDescription(String description) {
        this._description = description;
        return this;
    }

    @Column(length=128)
    public String getEmail() {
        return this._email;
    }

    public Group setEmail(String email) {
        this._email = email;
        return this;
    }

    @Column(nullable=true)
    public Integer getReferrer() {
        return this._referrer;
    }

    public void setReferrer(Integer referrer) {
        this._referrer = referrer;
    }

    @Override
    @ElementCollection(fetch=FetchType.LAZY, targetClass=String.class)
    @CollectionTable(joinColumns={@JoinColumn(name="idDes")}, name="GroupsDes")
    @MapKeyColumn(name="langId", length=5)
    @Column(name="label", nullable=false, length=255)
    public Map<String, String> getLabelTranslations() {
        return super.getLabelTranslations();
    }

    public String toString() {
        return "Group [_id=" + this._id + ", _name=" + this._name + ", _email=" + this._email + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this._id;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Group other = (Group)obj;
        return this._id == other._id;
    }

    @Transient
    public boolean isReserved() {
        return ReservedGroup.isReserved(this.getId());
    }

    @Nullable
    public String getLogo() {
        return this.logo;
    }

    @Nonnull
    public Group setLogo(@Nullable String logo) {
        this.logo = logo;
        return this;
    }

    @Nullable
    public String getWebsite() {
        return this.website;
    }

    @Nonnull
    public Group setWebsite(@Nullable String website) {
        this.website = website;
        return this;
    }

    @ManyToOne(cascade={CascadeType.DETACH, CascadeType.REFRESH, CascadeType.MERGE}, fetch=FetchType.EAGER)
    public MetadataCategory getDefaultCategory() {
        return this.defaultCategory;
    }

    public Group setDefaultCategory(MetadataCategory defaultCategory) {
        this.defaultCategory = defaultCategory;
        return this;
    }

    @ManyToMany(fetch=FetchType.EAGER, cascade={CascadeType.DETACH, CascadeType.PERSIST, CascadeType.REFRESH})
    @JoinTable(name="group_category", joinColumns={@JoinColumn(name="GROUP_ID", nullable=false, updatable=false)}, inverseJoinColumns={@JoinColumn(name="CATEGORY_ID", nullable=false, updatable=false)})
    public List<MetadataCategory> getAllowedCategories() {
        return this.allowedCategories;
    }

    public void setAllowedCategories(List<MetadataCategory> allowedCategories) {
        this.allowedCategories = allowedCategories;
    }

    @Column(name="enableCategoriesRestriction", nullable=true, length=1, columnDefinition="CHAR(1) DEFAULT 'n'")
    @Convert(converter=BooleanToYNConverter.class)
    public Boolean getEnableAllowedCategories() {
        if (this.enableAllowedCategories == null) {
            this.enableAllowedCategories = false;
        }
        return this.enableAllowedCategories;
    }

    public Group setEnableAllowedCategories(Boolean enableAllowedCategories) {
        this.enableAllowedCategories = enableAllowedCategories;
        return this;
    }
}

